unit siBtns;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type

  TAnimOrientation = (aoHorizontal, aoVertical);

  TsiBitBtn = class(TBitBtn)
  private
    { Private declarations }
    FAnimGlyph: TBitmap;
    FTempGlyph: TBitmap;
    FTimer: TTimer;
    FAnimCount: integer;
    FInterval: integer;
    FAnimated: boolean;
    FAnimOrientation: TAnimOrientation;
    FIndex: integer;
    procedure SetAnimGlyph(Value: TBitmap);
    procedure SetAnimated(Value: boolean);
    procedure SetInterval(Value: integer);
    procedure SetAnimOrientation(Value: TAnimOrientation);
  protected
    { Protected declarations }
    procedure TimerEvent(Sender: TObject);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property AnimGlyph: TBitmap
      read FAnimGlyph
      write SetAnimGlyph;
    property Animated: boolean
      read FAnimated
      write SetAnimated;
    property Interval: integer
      read FInterval
      write SetInterval;
    property AnimOrientation: TAnimOrientation
      read FAnimOrientation
      write SetAnimOrientation;
  end;

  TsiSpeedButton = class(TSpeedButton)
  private
    { Private declarations }
    FAnimGlyph: TBitmap;
    FTempGlyph: TBitmap;
    FTimer: TTimer;
    FAnimCount: integer;
    FInterval: integer;
    FAnimated: boolean;
    FAnimOrientation: TAnimOrientation;
    FIndex: integer;
    procedure SetAnimGlyph(Value: TBitmap);
    procedure SetAnimated(Value: boolean);
    procedure SetInterval(Value: integer);
    procedure SetAnimOrientation(Value: TAnimOrientation);
  protected
    { Protected declarations }
    procedure TimerEvent(Sender: TObject);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property AnimGlyph: TBitmap
      read FAnimGlyph
      write SetAnimGlyph;
    property Animated: boolean
      read FAnimated
      write SetAnimated;
    property Interval: integer
      read FInterval
      write SetInterval;
    property AnimOrientation: TAnimOrientation
      read FAnimOrientation
      write SetAnimOrientation;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('siComponents', [TsiBitBtn, TsiSpeedButton]);
end;

constructor TsiBitBtn.Create(AOwner: TComponent);
begin
//
  inherited Create(AOwner);
  FTimer := TTimer.Create(Self);
  FInterval := 100;
  FAnimated := False;
  FTimer.Enabled := False;
  FTimer.Interval := FInterval;
  FTimer.OnTimer := TimerEvent;
  FAnimCount := 0;
  FAnimOrientation := aoHorizontal;
  FAnimGlyph := TBitmap.Create;
  FTempGlyph := TBitmap.Create;
end;

destructor TsiBitBtn.Destroy;
begin
//
  FTimer.Enabled := False;
  FTimer.Free;
  FAnimGlyph.Free;
  FTempGlyph.Free;
  inherited Destroy;
end;

procedure TsiBitBtn.SetAnimGlyph(Value: TBitmap);
var
   WasAnim: boolean;
begin
//
  if FAnimGlyph <> Value then begin
    WasAnim := FAnimated;
    Animated := False;
    FAnimGlyph.Assign(Value);
    if FAnimGlyph <> Nil then FAnimCount := Value.Width div Value.Height;
    Animated := WasAnim;
  end;
end;

procedure TsiBitBtn.SetAnimated(Value: Boolean);
begin
//
  if FAnimated <> Value then begin
    FAnimated := Value;
    if Value then begin
      FTempGlyph.Assign(Glyph);
      FIndex := 1;
      TimerEvent(Self);
    end
    else
      Glyph.Assign(FTempGlyph);
    FTimer.Enabled := Value;
  end;
end;

procedure TsiBitBtn.SetInterval(Value: integer);
begin
//
  if FInterval <> Value then begin
    FInterval := Value;
    if Animated then begin
      FTimer.Enabled := False;
      FTimer.Interval := Value;
      FTimer.Enabled := True;
    end
    else begin
      FTimer.Interval := Value;
    end;
  end;
end;

procedure TsiBitBtn.SetAnimOrientation(Value: TAnimOrientation);
begin
  if Value <> FAnimOrientation then begin
    If Animated then begin
      Animated := False;
      FAnimOrientation := Value;
      Animated := True;
    end
    else FAnimOrientation := Value;
  end;
end;

procedure TsiBitBtn.TimerEvent(Sender: TObject);
var
   tmpBmp: TBitmap;
begin
//
//  if csDesigning in ComponentState then Exit;
  if FAnimGlyph = Nil then Exit;
  if FAnimGlyph.Empty then Exit;
  if FAnimOrientation = aoHorizontal then
    FAnimCount := FAnimGlyph.Width div FAnimGlyph.Height
  else
    FAnimCount := FAnimGlyph.Height div FAnimGlyph.Width;
  tmpBmp := TBitmap.Create;
  try
    if FAnimOrientation = aoHorizontal then begin
      tmpBmp.Height := FAnimGlyph.Height;
      tmpBmp.Width := FAnimGlyph.Height;
      tmpBmp.Canvas.CopyMode := cmSrcCopy;
      tmpBmp.Canvas.CopyRect(Rect(0,0,tmpBmp.Height,tmpBmp.Height),
                            FAnimGlyph.Canvas,Rect(FAnimGlyph.Height*(FIndex-1),0,FAnimGlyph.Height*FIndex,FAnimGlyph.Height));
    end
    else begin
      tmpBmp.Height := FAnimGlyph.Width;
      tmpBmp.Width := FAnimGlyph.Width;
      tmpBmp.Canvas.CopyMode := cmSrcCopy;
      tmpBmp.Canvas.CopyRect(Rect(0,0,tmpBmp.Width,tmpBmp.Width),
                            FAnimGlyph.Canvas,Rect(0,FAnimGlyph.Width*(FIndex-1),FAnimGlyph.Width,FAnimGlyph.Width*FIndex));
    end;
    Glyph.Assign(tmpBmp);
    Inc(FIndex);
    if FIndex > FAnimCount then FIndex := 1;
  finally
    tmpBmp.Free;
  end;
end;


constructor TsiSpeedButton.Create(AOwner: TComponent);
begin
//
  inherited Create(AOwner);
  FTimer := TTimer.Create(Self);
  FInterval := 100;
  FAnimated := False;
  FTimer.Enabled := False;
  FTimer.Interval := FInterval;
  FTimer.OnTimer := TimerEvent;
  FAnimCount := 0;
  FAnimOrientation := aoHorizontal;
  FAnimGlyph := TBitmap.Create;
  FTempGlyph := TBitmap.Create;
end;

destructor TsiSpeedButton.Destroy;
begin
//
  FTimer.Enabled := False;
  FTimer.Free;
  FAnimGlyph.Free;
  FTempGlyph.Free;
  inherited Destroy;
end;

procedure TsiSpeedButton.SetAnimGlyph(Value: TBitmap);
var
   WasAnim: boolean;
begin
//
  if FAnimGlyph <> Value then begin
    WasAnim := FAnimated;
    Animated := False;
    FAnimGlyph.Assign(Value);
    //FAnimCount := Value.Width div Value.Height;
    Animated := WasAnim;
  end;
end;

procedure TsiSpeedButton.SetAnimated(Value: Boolean);
begin
//
  if FAnimated <> Value then begin
    FAnimated := Value;
    if Value then begin
      FTempGlyph.Assign(Glyph);
      FIndex := 1;
      TimerEvent(Self);
    end
    else
      Glyph.Assign(FTempGlyph);
    FTimer.Enabled := Value;
  end;
end;

procedure TsiSpeedButton.SetInterval(Value: integer);
begin
//
  if FInterval <> Value then begin
    FInterval := Value;
    if Animated then begin
      FTimer.Enabled := False;
      FTimer.Interval := Value;
      FTimer.Enabled := True;
    end
    else begin
      FTimer.Interval := Value;
    end;
  end;
end;

procedure TsiSpeedButton.SetAnimOrientation(Value: TAnimOrientation);
begin
  if Value <> FAnimOrientation then begin
    If Animated then begin
      Animated := False;
      FAnimOrientation := Value;
      Animated := True;
    end
    else FAnimOrientation := Value;
  end;
end;

procedure TsiSpeedButton.TimerEvent(Sender: TObject);
var
   tmpBmp: TBitmap;
begin
//
//  if csDesigning in ComponentState then Exit;
  if FAnimGlyph = Nil then Exit;
  if FAnimGlyph.Empty then Exit;
  if FAnimOrientation = aoHorizontal then
    FAnimCount := FAnimGlyph.Width div FAnimGlyph.Height
  else
    FAnimCount := FAnimGlyph.Height div FAnimGlyph.Width;
  tmpBmp := TBitmap.Create;
  try
    if FAnimOrientation = aoHorizontal then begin
      tmpBmp.Height := FAnimGlyph.Height;
      tmpBmp.Width := FAnimGlyph.Height;
      tmpBmp.Canvas.CopyMode := cmSrcCopy;
      tmpBmp.Canvas.CopyRect(Rect(0,0,tmpBmp.Height,tmpBmp.Height),
                            FAnimGlyph.Canvas,Rect(FAnimGlyph.Height*(FIndex-1),0,FAnimGlyph.Height*FIndex,FAnimGlyph.Height));
    end
    else begin
      tmpBmp.Height := FAnimGlyph.Width;
      tmpBmp.Width := FAnimGlyph.Width;
      tmpBmp.Canvas.CopyMode := cmSrcCopy;
      tmpBmp.Canvas.CopyRect(Rect(0,0,tmpBmp.Width,tmpBmp.Width),
                            FAnimGlyph.Canvas,Rect(0,FAnimGlyph.Width*(FIndex-1),FAnimGlyph.Width,FAnimGlyph.Width*FIndex));
    end;
    Glyph.Assign(tmpBmp);
    Inc(FIndex);
    if FIndex > FAnimCount then FIndex := 1;
  finally
    tmpBmp.Free;
  end;
end;

end.
