unit Ssave;

interface


uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
     IniFiles, SysUtils, Messages, ExtCtrls;

type
  TScrn = class(TForm)
    Image: TImage;                                     { True If Loading }
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    ptMpos : TPoint;                                       { The mouse position }

    Procedure DoSs(Var WinMsg : TMessage);
                                message WM_USER + 1;       { Trigger Message }
    Procedure GetPwd(Var WinMsg : TMessage);
                                message WM_USER + 2;       { Get The Password }
    Procedure GetPassword;                                 { Get password, if any }
    procedure Trigger(Sender : TObject; Var Done : Boolean);                   { On Idle Trigger }
    Procedure OnTop(TopMost : Boolean);

    { Private declarations }
  public
    LoadingApp : Boolean;

    { Public declarations }
  end;

var
  Scrn: TScrn;

implementation
Uses
  Globals,
  GetPass,
  CodeMsg,
  CodeBall,
  CodeSpot,
  Bitmap;

{$R *.DFM}

Procedure TScrn.DoSs(Var WinMsg : TMessage);               { Called by trigger to activate a display routine }
Begin
  Case SsType Of                                           { Work on SS Type }
    1 : MoveMsg;
    2 : BallDisplay;
    3 : DrawSpot;
    4 : MovePic;
    end;
end;

Procedure TScrn.GetPwd(Var WinMsg : TMessage);             { Get a password }
Begin
  GetPassword;                                             { Get a password }
end;

Procedure TScrn.OnTop(TopMost : Boolean);                  { Set FLOATING style }
Begin
  if TopMost then                                          { If floating }
    SetWindowPos(Handle,HWND_TOPMOST,0,0,0,0,
                 SWP_NOSIZE + SWP_NOMOVE)                  { Set it }
  else
    SetWindowPos(Handle,HWND_NOTOPMOST,0,0,0,0,
                 SWP_NOSIZE + SWP_NOMOVE);                 { No Float }
End;

Procedure TScrn.GetPassword;                               { Get a Password }
Var
  CanExit : Boolean;                                       { True if we let them Exit }
begin
  Application.OnIdle := nil;
  ReleaseCapture;                                          { Release the Capture }
  if (TestMode) or (PwdType = 0) or
     ((PwdType = 1) and (Pwd = '')) then                   { If A NO password Needed }
    CanExit := True                                        { we Can Exit }
  else begin
    OnTop(False);                                          { Drop On Top }
    CursorOn;                                              { Turn the Cursor On }
    Wpwd := TWpwd.Create(Application);                     { Create the dialog }
    Wpwd.ShowModal;                                        { Show the Dialog }
    CanExit := Wpwd.PwdOk;                                 { Get the Result }
    Wpwd.Free;                                             { Free it }
    end;
  if CanExit then                                          { If we can Now get out }
    Close                                                  { Do So }
  else begin
    CursorOff;
    SetCapture(Scrn.Handle);                               { Capture the Cursor }
    SetFocus;                                              { Reset focus to the Screen }
    OnTop(True);
    Application.OnIdle := Trigger;                         { Set the OnIdle Proc }
    end;
end;

procedure TScrn.Trigger(Sender : TObject; Var Done : Boolean);                 { Called when Delphi gets bored }
begin
  PostMessage(Handle,WM_USER + 1,0,0);                     { Move it, and trigger again }
end;


procedure TScrn.FormKeyDown(Sender: TObject;
                            var Key: Word;
                            Shift: TShiftState);
begin
  GetPassword;                                             { Get the Password }
end;

procedure TScrn.FormMouseMove(Sender: TObject;
                              Shift: TShiftState;
                              X,  Y: Integer);
begin
  if (ptMpos.X = -1) and (ptMpos.Y = -1) then begin        { If the mouse has moved }
    ptMpos.X := X;                                         { Grab the X }
    ptMpos.Y := Y;                                         { Grab the Y }
    end
  else if (Abs(X - ptMpos.X) > 2) and
          (Abs(Y - ptmPos.Y) > 2) then Begin               { if a move > 2 pixels }
    ptMpos.X := X;                                         { Grab the New X }
    ptMpos.Y := Y;                                         { Grab the New Y }
    GetPassword;                                           { Get the Password }
    end;
end;


procedure TScrn.FormCreate(Sender: TObject);
begin
  LoadingApp := True;                                         { We are Loading }
end;

procedure TScrn.FormActivate(Sender: TObject);
begin
  If LoadingApp then begin                                    { If Loading }
    LoadingApp := False;                                      { Reset Flag }
(*    Scrn.Visible := False;*)
    If not DelayInit then Delay(0);                        { If delay NOT done then init }
    
    if Not TestMode then ReadDefaults;                     { Read the Defaults }
    ptMpos.X := -1;                                        { Reset mouse X }
    ptMpos.Y := -1;                                        { Reset Mouse Y }
    ScreenWd := Screen.Width;                              { Set GLOBAL Screen Ht }
    ScreenHt := Screen.Height;                             { Set GLOBAL Screen Width }

    case SsType of                                         { No based on the Type of the Saver .... }
      1 : Begin                                            { Message }
          InitMessage;                                     { Init }
          Scrn.Color := BkGrnd;                            { Set the Screen background }
          OnTop(True);                                     { Stay On Top }
          end;
      2 : Begin
          InitBalls;                                       { Init Spheres }
          Scrn.Color := clBlack;                           { Set the Screen background }
          end;
      3 : Begin
          InitSpot;                                        { Init Spot }
          Scrn.Color := clBlack;                           { Set the Screen background }
          end;
      4 : Begin                                            { Bitmap }
          InitPicture;                                     { Init }
          Scrn.Color := BkGrnd;                            { Set the Screen background }
          OnTop(True);                                     { Stay On Top }
          end;

      end;
    Scrn.Top := 0;                                         { Set top }
    Scrn.Left := 0;                                        { Set Left }
    Scrn.Width := ScreenWd;                                { Full Screen }
    Scrn.Height := ScreenHt;                               { Full Screen }
    OnTop(True);                                           { Set on Top }
    CursorOff;                                             { Turn the Cursor Off }
    Application.OnIdle := Trigger;                         { Set the OnIdle Proc }
    Scrn.Visible := True;                                  { Make It Visible }
    SetCapture(Scrn.Handle);                               { Capture the Mouse }
  end;
end;


procedure TScrn.FormMouseDown(Sender: TObject;
                              Button: TMouseButton;
                              Shift: TShiftState;
                              X, Y: Integer);
begin
  GetPassword;                                             { Get Password }
end;

procedure TScrn.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Application.OnIdle := nil;                               { Loose the trigger }
  CursorOn;                                                { Set the Cursor On }
  Case SsType of
    1 : FreeMsg;
    2 : FreeBalls;
    3 : FreeSpot;                                          { Free if required }
    4 : FreePic;
    end;
end;

end.
