unit Sprite;

interface
Uses
  WinTypes, WinProcs, Graphics, Classes, IniFiles, StdCtrls;

const
   NULL = 0;
var
  imgBackground: TBitmap;
  imgSave: TBitmap;
  imgWork: TBitmap;
  imgSeal: TBitmap;
  imgMask: TBitmap;
  SpriteX : Integer;

Function Initialize (MaskImage: TBitmap; Image: TBitmap): Boolean;
Function MoveTo (HDc: HDC; X: Integer; Y: Integer): Boolean;

implementation

Function Initialize (MaskImage: TBitmap; Image: TBitmap): Boolean;
var
  DestRect : TRect;
  SourceRect : TRect;
begin
  {Save the background}
  imgBackground := TBitmap.Create;
  imgSave := TBitmap.Create;
  imgWork := TBitmap.Create;
  imgSeal := TBitmap.Create;
  imgMask := TBitmap.Create;
  with imgBackground do
    SourceRect := Rect(0, (imgBackground.Height - imgSave.Height),
                       imgSave.Width, imgBackground.Height);
  with imgSave do
    begin
      DestRect := Rect(0, 0, imgSave.Width, imgSave.Height);
      Canvas.CopyMode :=cmSrcCopy;
      Canvas.CopyRect(DestRect, imgBackground.Canvas, SourceRect);
    end;
  {Put up the initial image - Start with the Mask}
  with imgBackground do
    begin
      DestRect := Rect(0, (imgBackground.Height - imgWork.Height),
                       imgMask.Width, (imgBackground.Height - 4));
      SourceRect := Rect(0, 0, imgMask.Width, imgMask.Height);
      Canvas.CopyMode := cmSrcAnd;
      Canvas.CopyRect(DestRect, imgMask.Canvas, SourceRect);
                             {Finish with the image}
      Canvas.CopyMode := cmSrcPaint;
      Canvas.CopyRect(DestRect, imgSeal.Canvas, SourceRect);
    end;
  SpriteX := 0;
  Result := True;
End;

Function MoveTo (HDc: HDC; X: Integer; Y: Integer): Boolean;
var
  SRect : TRect;
  DRect : TRect;
  SpriteInc : Integer;
  Counter : Integer;
begin
  SpriteInc := 1;
  with imgWork do
    begin
      {Get the work buffer}
      DRect := Rect(X, Y, imgWork.Width, imgWork.Height);
      SRect := Rect(X, (imgBackground.Height - imgWork.Height),
                   (X + imgWork.Width), imgBackground.Height);
      Canvas.CopyMode := cmSrcCopy;
      Canvas.CopyRect(DRect, imgBackground.Canvas, SRect);
      {Restore background to work buffer, erasing the seal}
      DRect := Rect(X, Y, imgSave.Width, imgSave.Height);
      SRect := Rect(X, Y, imgSave.Width, imgSave.Height);
      Canvas.CopyRect(DRect, imgSave.Canvas, SRect);
      {Save the new background from the work buffer}
      DRect := Rect(X, Y, imgSave.Width, imgSave.Height);
      SRect := Rect(SpriteInc, Y, (imgSave.Width + SpriteInc), imgSave.Height);
      imgSave.Canvas.CopyRect(DRect, imgWork.Canvas, SRect);
      {Pop the Mask into the work buffer}
      SRect := Rect(X, Y, imgMask.Width, imgMask.Height);
      DRect := Rect(SpriteInc, Y, (imgMask.Width + SpriteInc), imgMask.Height);
      Canvas.CopyMode := cmSrcAnd;
      Canvas.CopyRect(DRect, imgMask.Canvas, SRect);
      {Place the sprite in the mask}
      SRect := Rect(X, Y, imgMask.Width, imgMask.Height);
      DRect := Rect(SpriteInc, 0, (imgMask.Width + SpriteInc), imgMask.Height);
      Canvas.CopyMode := cmSrcPaint;
      Canvas.CopyRect(DRect, imgSeal.Canvas, SRect);
      {Place the work buffer on the screen}
      SRect := Rect(X, Y, imgWork.Width, imgWork.Height);
      DRect := Rect(X, (imgBackground.Height - imgWork.Height),
                   (X + imgWork.Width), imgBackground.Height);
      imgBackground.Canvas.CopyMode := cmSrcCopy;
      imgBackground.Canvas.CopyRect(DRect, imgWork.Canvas, SRect);
      X := X + SpriteInc;
    end;
  if X > imgBackground.Width then
    X := -(imgWork.Width);
end;

end.
