unit Picdlg;

interface

uses SysUtils, WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs;

type
  TBitmapDlg = class(TForm)
    OKBtn: TBitBtn;
    Bevel1: TBevel;
    OpenDialog: TOpenDialog;
    EditFile: TEdit;
    FileBtn: TSpeedButton;
    Panel1: TPanel;
    Image: TImage;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Spd: TScrollBar;
    MoveCheckBox: TCheckBox;
    procedure FileBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure GetBitmap;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BitmapDlg: TBitmapDlg;

implementation

uses Globals, IniFiles, Bitmap, Ssave;
{$R *.DFM}

procedure TBitmapDlg.FileBtnClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    EditFile.Text := OpenDialog.Filename;
    BitmapFile    := EditFile.Text;
    GetBitmap;
  end;
end;

procedure TBitmapDlg.OKBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TBitmapDlg.GetBitmap;
begin
  if FileExists(BitmapFile) then
    Image.Picture.LoadFromFile(BitmapFile)
  else
    begin
      MessageDlg('File Does Not Exist', mtError, [mbOk], 0);
    end;
end;

procedure TBitmapDlg.FormShow(Sender: TObject);
var
  Ini   : TiniFile;
begin
  Ini := TIniFile.Create('Wow.Ini');                   { Open the Ini File }
  Apptitle := 'Bitmap';
  EditFile.Text := Ini.ReadString(Apptitle, 'Bitmap File Location', #0); { bitmap filename }
  BitmapFile := EditFile.Text;
  MoveCheckBox.Checked  := Boolean(Ini.ReadInteger(Apptitle,
                             'MoveOrPlot',1));                    { Get the Speed }
  Spd.Position := Ini.ReadInteger(Apptitle, 'Speed', 25); { bitmap speed }
  Ini.Free;
  GetBitmap;
end;

procedure TBitmapDlg.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Ini   : TiniFile;
begin
  Ini := TIniFile.Create('Wow.Ini');                   { Open the Ini File }
  Apptitle := 'Bitmap';                                { Set title }
  Ini.WriteString(Apptitle, 'Bitmap File Location', BitmapFile); { bitmap filename }
  Ini.WriteInteger(Apptitle,'Speed',Spd.Position);         { Write the Speed }
  if MoveCheckBox.Checked then
    Ini.WriteInteger(Apptitle,'MoveOrPlot',1)
  else
    Ini.WriteInteger(Apptitle,'MoveOrPlot',0);
  Ini.Free;
end;

end.
