unit Msgdefs;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons, IniFiles, Dialogs, Messages, ColorGrd;

type
  TMiniScrn = Class(TCustomControl)
  Protected
    procedure Paint; Override;
  end;

  TSetupMsg = class(TForm)
    Pos: TGroupBox;
    Ctr: TRadioButton;
    Rnd: TRadioButton;
    GroupBox1: TGroupBox;
    Spd: TScrollBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    NewMsg: TEdit;
    Ok: TBitBtn;
    Cancel: TBitBtn;
    TxtFont: TBitBtn;
    GroupBox2: TGroupBox;
    SetPwd: TBitBtn;
    Fd: TFontDialog;
    Cd: TColorDialog;
    Msg: TLabel;
    Cg: TColorGrid;
    Label4: TLabel;
    PassType: TComboBox;                                      { Bitmap of the Message }
    procedure FormCreate(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure TxtFontClick(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure NewMsgChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SetPwdClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CgChange(Sender: TObject);
    procedure PassTypeClick(Sender: TObject);
    procedure SpdChange(Sender: TObject);
  private
    iMsgL : Integer;                                       { Current LEFT position of Message }
    iMsgR : Integer;                                       { Current RIGHT position of Message }
    iMsgT : Integer;                                       { Current TOP position of Message }
    BitMsg : TBitmap;                                      { Bitmap of the Message }
    Scrn   : TMiniScrn;
    Loading : Boolean;
    Procedure MoveMsg(Var WinMsg : TMessage); message WM_USER + 1;
    Procedure CreateBitMsg(FreeIt : Boolean);

    { Private declarations }
  public
    Procedure Trigger(Sender : TObject; Var Done : Boolean);

    { Public declarations }
  end;

var
  SetupMsg : TSetupMsg;
  Ini   : TIniFile;

implementation

Uses Globals, NewPass, CodeMsg;

{$R *.DFM}
procedure TMiniScrn.Paint;                                 { Paint the Mini Screen }
var
  R: TRect;                                                { Size }
begin
  R := ClientRect;                                         { Get the Size }
  FillRect(Canvas.Handle,R,Canvas.Brush.Handle);           { Fill It }
end;

Procedure TSetupMsg.CreateBitMsg(FreeIt : Boolean);
Var
  Tr : TRect;                                              { Size }
Begin
  If FreeIt then BitMsg.Free;
  BitMsg := TBitmap.Create;                                { Create the Bitmap }
  BitMsg.Canvas.Font := Msg.Font;                          { Set Font }
  BitMsg.Width := BitMsg.Canvas.TextWidth(Msg.Caption) +
                  Msg.Width;                               { Set width to Message Width }
  BitMsg.Height := BitMsg.Canvas.TextHeight(Msg.Caption);  { Set Height to Message Height}
  Tr.Top := 0;                                             { Rect the top }
  Tr.Left := 0;                                            { Blew up the Left }
  Tr.Right := BitMsg.Width;                                { Destroyed the Width }
  Tr.Bottom := BitMsg.Height;                              { Broke the Height }
  with BitMsg.Canvas do begin                              { Now transfer the Message to the bitmap }
    Brush.Color := Scrn.Canvas.Brush.Color;                { Background to default }
    FillRect(Tr);                                          { Fill It }
    TextOut(0,0,Msg.Caption + ' ');                        { Wack the Text in }
    end;
  iMsgL := Msg.Width;
  iMsgR := BitMsg.Width;                                   { Grab the width }
  Scrn.Refresh;                                            { Refresh }
end;

Procedure TSetupMsg.MoveMsg(Var WinMsg : TMessage);
Begin
  Dec(iMsgL,1);                                            { Move Left }
  Dec(iMsgR,1);                                            { Adjust RIGHT }
  if iMsgR < 0 then begin                                  { if OFF screen }
    iMsgL := Scrn.Width;                                   { Reset the RIGHT edge }
    iMsgR := BitMsg.Width;                                 { Reset R margin }
    end;
  Scrn.Canvas.Draw(iMsgL,iMsgT,BitMsg);                    { Draw the Message }
  Delay(Spd.Position);                                     { Delay a Bit }
End;

Procedure TSetupMsg.Trigger(Sender : TObject; Var Done : Boolean);
Begin
  PostMessage(Handle,WM_USER + 1,0,0);                     { Move it, and trigger again }
End;

procedure TSetupMsg.FormCreate(Sender: TObject);
begin
  Loading := True;                                         { Loading }
 End;


procedure TSetupMsg.CancelClick(Sender: TObject);
begin
  Close;                                                   { Bye Bye }
end;

procedure TSetupMsg.TxtFontClick(Sender: TObject);
begin
  Fd.Font := Msg.Font;                                     { Set font }
  Fd.Execute;                                              { Run the Dialog }
  Msg.Font := Fd.Font;                                     { Reset the Font }
  CreateBitMsg(True);
end;

procedure TSetupMsg.OkClick(Sender: TObject);
Var
  Fnt : Integer;                                           { Temp for font style }
begin
  Ini := TIniFile.Create('Wow.Ini');                   { Create the Ini file }
  Ini.WriteString(AppTitle,'FontName',Msg.Font.Name);      { Write Font.Name }
  Ini.WriteInteger(AppTitle,'FontSize',Msg.Font.Size);     { Write Font.Size }
  Ini.WriteInteger(AppTitle,'FontHeight',Msg.Font.Height); { Write Font.Height }
  Ini.WriteInteger(AppTitle,'FontColour',Msg.Font.Color);  { Write Font.Colour }

  Fnt := 0;                                                { Reset font }
  if fsBold in Msg.Font.Style then Fnt := 1;               { Set }
  if fsItalic in Msg.Font.Style then Inc(Fnt,2);           { Set }
  if fsUnderline in Msg.Font.Style then Inc(Fnt,4);        { Set }
  if fsStrikeOut in Msg.Font.Style then Inc(Fnt,8);        { Set }
  Ini.WriteInteger(AppTitle,'FontStyle',Fnt);              { Write Font.Style }

  Ini.WriteInteger(Apptitle,'BkGrnd',
                   Scrn.Canvas.Brush.Color);               { Write the Background colour }
  Ini.WriteString(Apptitle,'Msg',Msg.Caption);             { Write the Message }
  Ini.WriteInteger(Apptitle,'Speed',Spd.Position);         { Write the Speed }
  Ini.WriteBool(AppTitle,'Centered',Ctr.Checked);          { Write Text orientation }
  Ini.WriteInteger(AppTitle,'PwdType',
                   PassType.ItemIndex);                    { Write the Password type }
  Ini.WriteInteger(AppTitle,'Fg',Cg.ForegroundIndex);      { Write The Foreground Color }
  Ini.WriteInteger(AppTitle,'Bg',Cg.BackgroundIndex);      { Write The Background Color }
  Close;
end;

procedure TSetupMsg.NewMsgChange(Sender: TObject);
begin
  If Loading then Exit;                                    { Not id we are loading }
  Msg.Caption := NewMsg.Text;                              { Set new text }
  CreateBitMsg(True);                                      { Recreate the Bitmap }
end;

procedure TSetupMsg.FormActivate(Sender: TObject);
begin
  If Loading then begin                                    { App is loading }
    Refresh;                                               { Show the screen }
    If Not DelayInit then Delay(0);                        { Calibrate }
    ReadMsgDefaults;                                       { Read Message defaults }
    if Not CntrText then Rnd.Checked := True;              { If not centred then must be random }
    Spd.Position := Speed;                                 { Set Speed }
    PassType.ItemIndex := PwdType;                         { Set Passord }
    Msg.Caption := MsgText + ' ';                          { Set Msg, add a space to avoid trails }
    NewMsg.Text := MsgText;                                { Set the Text }
    Msg.Font := MsgFont;                                   { Set the Font }
    Scrn := TMiniScrn.Create(Self);                        { Create a Mini Scrn }
    Scrn.Parent := Self;                                   { Set parent to us }
    Scrn.Top := Msg.Top;                                   { Align with Msg }
    Scrn.Left := Msg.Left;                                 { Align with Msg }
    Scrn.Width := Msg.Width;                               { Align with Msg }
    Scrn.Height := Msg.Height;                             { Align with Msg }
    Scrn.Canvas.Brush.Color := BkGrnd;                     { Set Background }
    Scrn.Canvas.Brush.Style := BsSolid;                    { Set forground }
    CreateBitMsg(False);                                   { Create the Bitmap }
    Cg.BackgroundIndex := Bg;                              { Set the colour }
    Cg.ForegroundIndex := Fg;                              { Set the colour }
    Loading := False;                                      { Reset Flag }
    Application.OnIdle := Trigger;                         { Set OnIdle Proc }
  end;
end;

procedure TSetupMsg.SetPwdClick(Sender: TObject);
begin
  ChPwd := TChPwd.Create(Application);
  if Pwd = '' then begin
    ChPwd.OldPwd.Enabled := False;
    ChPwd.NewPwd.Enabled := True;
    ChPwd.Rpwd.Enabled := True;
    end
  else begin
    ChPwd.OldPwd.Enabled := True;
    ChPwd.NewPwd.Enabled := False;
    ChPwd.Rpwd.Enabled := False;
    end;
  ChPwd.ShowModal;
  ChPwd.Free;
end;

procedure TSetupMsg.FormDestroy(Sender: TObject);
begin
  BitMsg.Free;
  Scrn.Free;
  Application.OnIdle := nil;
end;

procedure TSetupMsg.CgChange(Sender: TObject);
begin
  If Loading then Exit;
  Scrn.Canvas.Brush.Color := Cg.BackGroundColor;
  Msg.Font.Color := Cg.ForeGroundColor;

  CreateBitMsg(True);

end;

procedure TSetupMsg.PassTypeClick(Sender: TObject);
begin
  If PassType.ItemIndex = 1 then                           { If using the WINDOWS Password }
    SetPwd.Enabled := True                                 { Activate the Set Password Button }
  else
    SetPwd.Enabled := False;                               { Deactivate the Password Button }
end;

procedure TSetupMsg.SpdChange(Sender: TObject);
begin
  SetFocus;
end;

end.
