unit MovePic;

interface
Uses
  WinTypes, WinProcs, Graphics, Classes, IniFiles, StdCtrls;

const
   NULL = 0;
var
   mHBMImage:       HBITMAP;
   mHBMMask:        HBITMAP;
   mHBMSave:        HBITMAP;
   mX, mY:          Integer;
   mWidth, mHeight: Integer;
   HMemDC:  HDC;
   HMemDCHold: HDC;

Function Initialize (HBMMask: HBITMAP; HBMImage: HBITMAP): Boolean;
Function MoveTo (HDc: HDC; X: Integer; Y: Integer): Boolean;

implementation

Function Initialize (HBMMask: HBITMAP; HBMImage: HBITMAP): Boolean;
{ assigns the bitmaps containing the sprite image and
  prepares the sprite object for a new animation sequence; may
  be called more than once for a given object}
var
   HDCScreen:  HDC;
   HBMSave: HBITMAP;
   ImageBM: TBitmap;
   MaskBM: TBitmap;
   GetResult: Integer;
Begin
   {get and compare the sizes of the mask and image bitmaps: }
   
   GetResult := GetObject (HBMMask, sizeof (TBitmap), MaskBM);
   if (GetResult = 0) then
      Result := FALSE;

   GetResult := GetObject (HBMImage, sizeof (TBitmap), ImageBM);
   if (GetResult = 0) then
      Result := FALSE;

   { return an error code if sizes are unequal: }
   if (MaskBM.Width <> ImageBM.Width) or
      (MaskBM.Height <> ImageBM.Height) then
      Result := FALSE;
   
   { create the "save" bitmap for saving and restoring screen
     graphics: }
   HDCScreen := GetDC (NULL);
   HBMSave := CreateCompatibleBitmap
      (HDCScreen,
      MaskBM.Width,    { same size as mask and image bitmaps }
      MaskBM.Height);
   ReleaseDC (NULL, HDCScreen);
   if (HBMSave = NULL) then
      Result := FALSE;
      
   { delete prior "save" bitmap, if any: }
   if (mHBMSave <> 0) then
      DeleteObject (mHBMSave);
                                         
   { function is successful; now assign values to data members: }
   mHBMSave := HBMSave;
   mHBMMask := HBMMask;
   mHBMImage := HBMImage;
   mWidth := MaskBM.Width;
   mHeight := MaskBM.Height;
   mX := 0;
   mY := 0;

   Result := FALSE;
End;

Function MoveTo (HDc: HDC; X: Integer; Y: Integer): Boolean;
{ moves the sprite to a new position }
Var
   HBMHold: HBITMAP;
   RectNew: TRect;
   RectOld: TRect;
   RectUnion: TRect;

Begin
   { (1) create temporary hold bitmap: }

   { calculate coordinates of entire affected screen area: }
   RectOld := Rect(mX, mY, mX + mWidth, mY + mHeight);
   RectNew := Rect(X, Y, X + mWidth, Y + mHeight);

   UnionRect(RectUnion, RectOld, RectNew);
   RectUnion.left := RectUnion.left - RectUnion.left MOD 8;

   HBMHold := CreateCompatibleBitmap
      (HDc,
      RectUnion.right - RectUnion.left,
      RectUnion.bottom - RectUnion.top);
   if (HBMHold <> 0) then
      Result := FALSE;

   { (2) copy affected area of screen into hold bitmap: }
   
   HMemDCHold := CreateCompatibleDC (HDc);
   SelectObject (HMemDCHold, HBMHold);

   BitBlt
      (HMemDCHold,
      0,
      0,
      RectUnion.right - RectUnion.left,
      RectUnion.bottom - RectUnion.top,
      HDc,
      RectUnion.left,
      RectUnion.top,
      SRCCOPY);

   { (3) erase sprite in hold bitmap: }

   HMemDC := CreateCompatibleDC (HDc);
   SelectObject (HMemDC, mHBMSave);
   
   BitBlt
      (HMemDCHold,
      mX - RectUnion.left,
      mY - RectUnion.top,
      mWidth,
      mHeight,
      HMemDC,
      0,
      0,
      SRCCOPY);

   { (4) save screen graphics at new sprite position: }
   
   BitBlt
      (HMemDC,
      0,
      0,
      mWidth,
      mHeight,
      HMemDCHold,
      X - RectUnion.left,
      Y - RectUnion.top,
      SRCCOPY);

   { (5) transfer mask bitmap: }

   SelectObject (HMemDC, mHBMMask);
   BitBlt
      (HMemDCHold,
      X - RectUnion.left,
      Y - RectUnion.top,
      mWidth,
      mHeight,
      HMemDC,
      0,
      0,
      SRCAND);

   { (6) transfer image bitmap: }

   SelectObject (HMemDC, mHBMImage);
   BitBlt
      (HMemDCHold,
      X - RectUnion.left,
      Y - RectUnion.top,
      mWidth,
      mHeight,
      HMemDC,
      0,
      0,
      SRCINVERT);

   { (7) copy hold bitmap back to screen: }

   BitBlt
      (HDc,
      RectUnion.left,
      RectUnion.top,
      RectUnion.right - RectUnion.left,
      RectUnion.bottom - RectUnion.top,
      HMemDCHold,
      0,
      0,
      SRCCOPY);

   { delete the memory device contexts: }
   DeleteDC (HMemDCHold);
   DeleteDC (HMemDC);

   { (8) delete hold bitmap: }
   DeleteObject (HBMHold);

   { (9) save coordinates of new sprite position: }
   mX := X;
   mY := Y;

   Result := TRUE;
End;

end.
