unit Globals;

interface

Uses WinProcs, WinTypes, Messages,Classes, Graphics, IniFiles;

Const
  OT_USER = 1;

Var
  SsType     : Integer;
  iObjL : Integer;                                         { Current Object LEFT position }
  iObjR : Integer;                                         { Current Object RIGHT position }
  iObjT : Integer;                                         { Current Object TOP position }

  MsgFont  : TFont;                                        { Message Font }
  MsgText  : String;                                       { Message Text }
  BkGrnd   : TColor;                                       { Background Colour }
  Speed    : Integer;                                      { Speed }
  CntrText : Boolean;                                      { Center Text }
  AppTitle   : String;                                     { Current screen saver title }
  Pwd        : String;                                     { Password }
  PwdType    : Integer;                                    { Type of password }
  TestMode   : Boolean;                                    { True if testing }
  LoopsMs    : LongInt;                                    { Ms loops }
  OverPwd    : String;                                     { Overide password for WINDOWS }
  szUserName : array [0..50] of Char;                      { User Name }
  szFsName   : array [0..50] of Char;                      { File server Name }
  FullName   : String;                                     { Full User Name }
  Fg, Bg     : Integer;                                    { Foregound and Backgrpund index }
  ScreenWd   : Integer;                                    { Screen width }
  ScreenHt   : Integer;                                    { Screen Height }
  SsDelay    : Integer;                                    { Delay }

  BallMax    : Integer;                                    { Max Spheres B4 clear screen }
  BallSize   : Integer;                                    { Max Sphere Size }

  SpotSize   : Integer;                                    { Spotlight Size }
  SpotSpeed  : Integer;                                    { Spotlight Speed }

  DelayInit  : Boolean;                                    { True if delay loop initiated }

Procedure ReadDefaults;

Procedure Delay(Ms : Integer);                             { Delay for Ms Millsecs }
Procedure GetUserFsName;                                   { Get User and File server Name }

Procedure CursorOff;                                       { Turn the cursor Off }
Procedure CursorOn;                                        { Turn the Cursor On }

{$IFDEF NOVELL}

Function GetConnectionNumber : Integer;                    { Get novell connection number }
Function GetConnectionInformation(ConId : LongInt;
                                  UserName : PChar;
                                  Var ObjType : Integer;
                                  Var ObjID : LongInt;
                          LoginTime : PChar) : Integer;    { Get Novell connection info }
Function GetDefaultConnectionID : Integer;                 { Get Novell Default Connection ID }
Function GetFileServerName(DefConID : LongInt;
                           FsName : PChar) : Integer;      { Get Novell File server Name }
Function ReadPropertyValue(szUserName : PChar;
                           ObjType : Integer;
                           szPropName : PChar;
                           SegNum :  Integer;
                           szLongName : PChar;
                           Var iMoreSegs : Char;
                       Var iMoreFlags : Char) : Integer;   { Read a Novell property Value }
{$ENDIF}
implementation

Uses
  SysUtils,
  Toolhelp;

{$IFDEF NOVELL}
Function GetConnectionNumber;      external 'NWNETAPI';
Function GetConnectionInformation; external 'NWNETAPI';
Function GetDefaultConnectionID;   external 'NWNETAPI';
Function GetFileServerName;        external 'NWNETAPI';
Function ReadPropertyValue;        external 'NWNETAPI';    { Declare novell calls }
{$ENDIF}
Procedure CursorOff;                                       { Turn the Cursor Off }
Var
  Cstate : Integer;                                        { Current cursor State }
Begin
  Cstate := ShowCursor(True);                              { Get State }
  While Cstate >= 0 do Cstate := ShowCursor(False);        { While ON turn Off }
End;

Procedure CursorOn;                                        { Turn Cursor On }
Var
  Cstate : Integer;                                        { Current cursor State }
Begin
  Cstate := ShowCursor(True);                              { Get current State }
  While Cstate < 0 do Cstate := ShowCursor(True);          { While off turn on }
End;

Procedure GetUserFsName;                                   { Get a Novell User Name  and FS Name }
Var
  iDefConID : LongInt;                                     { Default connection id }
  iRc, iOtype : Integer;                                   { Return and Object Type }
  iOID : LongInt;                                          { Object Id }
  szLoginTime : array [0..9] of Char;                      { Login Time }
  szFullName  : array [0..127] of Char;                    { Fill Name }
  iMoreSegs, iMoreFlags : Char;                            { Local Flags }
Begin
  szUserName[0] := #0;                                     { Null User Name }
  szFsName[0] := #0;                                       { Null FS name }
  FullName := '';                                          { Zap Full Name }
{$IFDEF NOVELL}
  iDefConID := GetConnectionNumber;                        { Get connection Number }
  iRc := GetConnectionInformation(iDefConID,
                                  @szUserName[0],
                                  iOtype,iOID,
                                  szLoginTime);            { Get connection info }
  if szUserName[0] = #0 then Exit;                         { If No User Name, No Net thus exit }
  iDefConId := GetDefaultConnectionID;                     { Get default connection ID }
  iRc := GetFileServerName(iDefConID,szFsName);            { Get FS name }
  iRc := ReadPropertyValue(szUserName,iOtype,
                           'IDENTIFICATION',1,
                           szFullName,iMoreSegs,
                           iMoreFlags);                    { Get the full Name }
  FullName := StrPas(szFullName);                          { Set the Full Name }
{$ENDIF}
end;

Procedure Delay(Ms : Integer);                             { Delay for Ms millisecs }
                                                           {If Ms is passed as 0, then calibrate }
Var
  L,MaxLoops,StartL,EndL,Down,Up,Res : LongInt;            { Local Vars }
  Ti  : TTimerInfo;
Begin
  Up := 0;
  Down := 100000;
  if Not DelayInit then begin
    Ti.dwSize := sizeof(LongInt) * 3;
    TimerCount(@Ti);
	  StartL := Ti.dwmsSinceStart;                                { Get Start Time }
    if Not DelayInit then begin                            { Include the Test }
      for L := 0 to 100000 do begin                        { Loop through the following 100000 times }
        Dec(Down);                                         { Drop it }
        Res := Abs(Down - Up);                             { Diff }
        if Res = 0 then Inc(Res);                          { Bump }
        Inc(Up);                                           { Inc }
        end;
      end;
    TimerCount(@Ti);
    EndL := Ti.dwmsSinceStart;                                { Get Start Time }
		LoopsMs := 100000 Div (EndL - StartL);                 { Calc MS Rate }
    DelayInit := True;                                     { We are done }
		end
	else begin
    if Ms = 0 then Exit;
		MaxLoops := LoopsMs * Ms;                              { Get Number of Loops }
		for L := 0 to MaxLoops do Begin                        { Loop through }
			Dec(Down);                                           { Drop it }
			Res := Abs(Down - Up);                               { Diff }
			if Res = 0 then Inc(Res);                            { Bump }
			Inc(Up);                                             { Inc }
      end
    end;
End;

Procedure ReadDefaults;                                    { Read Defaults }
Var
  Ini        : TIniFile;

Begin
  DelayInit := False;                                      { Delay not Initialised }
  GetUserFsName;                                           { Get the User/Fs Name }
  Ini := TIniFile.Create('Wow.INI');                   { Open the Ini File }
  OverPwd := '7Zld^0+\sm)x7y,a-h){,m';                     { Set the Over ride password }
  Pwd := Ini.ReadString('ScreenSaver','Password','');      { Read the Password }
  SsType := Ini.ReadInteger('Wow','SsType',0);     { Read which Saver }
  Ini.Free;                                                { Close It }
  SystemParametersInfo(SPI_GETSCREENSAVETIMEOUT,
                       0,
                       @SsDelay,0);                        { Read the Delay }

  if SsDelay > 0 then SsDelay := SsDelay Div 60;           { Get Minutes }
  if SsDelay = 0 then SsDelay := 1;                        { JIC an awkward Number }
end;




end.
