unit Codeball;
{$N+}
interface

Uses Graphics, WinProcs, WinTypes, Messages, Classes;

Const
  PALSIZE = 236;
  PALSEG  = 39;

Var
  hPal         : HPalette;                                 { Handle to a Palette }
  pLogPal      : ^TLOGPALETTE;                             { Pointer to a palette }
  MaxSize      : Integer;                                  { Max size of a sphere }
  Rc1          : TRect;                                    { Rectangle surrounding a sphere }
  xr,xl,yt,yb  : Integer;                                  { Position vars }
  nBars, Which : Integer;                                  { Number and which is the current bar }
  hPalMem      : THandle;                                  { Handle to memory for palette }
  PalOff       : Integer;                                  { current offsaet in the palette }
  NumDone      : Word;                                     { Number of spheres displayed }
  OldPalette   : HPalette;                                 { the prevous palette }
  iNumSpheres  : Integer;                                  { the number of spheres on screen }
  OldBrush     : TBrush;                                   { the previous Brush }
  OldPen       : TPen;                                     { the Previous Pen }

Procedure InitBalls;                                       { Startup }
Procedure FreeBalls;                                       { Free any resources }

Procedure BallDisplay;                                     { Display a Sphere }
Procedure ReadBallDefaults;                                { Read the defaults }

implementation

Uses
  Ssave, Globals, IniFiles;

Procedure MakePalette(PalOff,Rs,Ri,Gs,Gi,Bs,Bi : Integer); { Construct a palette section }
Var
  Pal : Integer;                                           { Local Looper }
begin
  for Pal := PalOff to PalOff + PALSEG do begin            { For each member }
    pLogPal^.palPalEntry[Pal].peRed := Rs;                 { Set Red }
    pLogPal^.palPalEntry[Pal].peGreen := Gs;               { Set Green }
    pLogPal^.palPalEntry[Pal].peBlue := Bs;                { Set Blue }
    Inc(Rs,Ri);                                            { Bump Red }
    Inc(Gs,Gi);                                            { Bump Green }
    Inc(Bs,Bi);                                            { Bump Blue }
    pLogPal^.palPalEntry[Pal].peFlags := 0;                { Set Flags }

    end;
end;

Procedure InitBalls;
Begin
  ReadBallDefaults;                                        { Read Ball defaults }
  iNumSpheres := BallMax;                                  { Get Num Circles }
  MaxSize := BallSize;                                     { Get ball Size }
  Randomize;                                               { True random }
  OldPen := Scrn.Canvas.Pen;                               { Remember the Pen }
  OldBrush := Scrn.Canvas.Brush;                           { Remember the Brush }
  hPalMem := LocalAlloc(LMEM_FIXED,
                    sizeof(TLOGPALETTE)
                    + PALSIZE * sizeof(TPALETTEENTRY));    { Grab the Memory }
  pLogPal := LocalLock(hPalMem);                           { Lock the memory }
  pLogPal^.palVersion := 768;                              { bloody mysterious }
  pLogPal^.palNumEntries := PALSIZE;                       { Set Num Entries}
  MakePalette(  0,21,6,0,0,0,0);
  MakePalette( 39,0,0,21,6,0,0);
  MakePalette( 78,0,0,0,0,21,6);
  MakePalette(117,138,3,64,4,21,4);
  MakePalette(156,99,4,21,6,99,4);
  MakePalette(195,21,6,99,4,21,6);                         { Make the pallettes }
  hPal := CreatePalette(pLogPal^);                         { Create the master pallette }
  LocalUnlock(hPalMem);                                    { Unlock it}
  LocalFree(hPalMem);                                      { free it}
  OldPalette := SelectPalette(Scrn.Canvas.Handle,
                               hPal, False);               { select the pallette }
end;

Procedure FreeBalls;
Begin
  Scrn.Canvas.Pen := OldPen;                               { Remember the Pen }
  Scrn.Canvas.Brush := OldBrush;                           { Remember the Brush }
  SelectPalette(Scrn.Canvas.Handle,
                               OldPalette, False);         { select the pallette }
  RealizePalette(Scrn.Canvas.Handle);                      { realize it }
  DeleteObject(hPal);                                      { Kill the Palette }
End;

Procedure BallDisplay;
Var
  Rct : TRect;                                             { Clearing screen rect }
  Radius, ThisPal : Integer;                               { Local Vars }
  PalInc : Single;                                         { Local Vars }
  ThisOne : TColor;                                        { Local Vars }

Begin
  SelectPalette(Scrn.Canvas.Handle, hPal, False);          { Select the Palette }
  RealizePalette(Scrn.Canvas.Handle);                      { realize it }
  Inc(NumDone);
  if NumDone = iNumSpheres then begin                      { If Clear the Screen }
    Scrn.Canvas.Brush.Color := clBlack;                    { Black Please }
    Rct := Rect(0,0,ScreenWd + 2, ScreenHt +2);            { Get the Rectangle }
    Scrn.Canvas.FillRect(Rct);                             { Fill It }
    NumDone := 0;                                          { Reset Count }
    end;

  nBars := Random(MaxSize);                                { Get the Number of Bars }
  if nBars = 0 then                                        { If None }
     nBars := 1;                                           { Make it al least 1 }
  Which := Random(7);                                      { Get the Colour Palette }
  if Which = 0 then                                        { Check for Palette 0 }
     Which := 1;                                           { Make it 1 }
  PalInc := PALSEG / nBars;                                { Set the Palette Incrementer }
  PalOff := Which * PALSEG;                                { Set the Palette offset }
  xl := Random(ScreenWd)-64;                               { Set Screen Pos X }
  yt := Random(ScreenHt)-64;                               { Set Screen Pos Y }
  xr := xl + nBars * 2;                                    { Set LEFT extremity }
  yb := yt + nBars * 2;                                    { Set BOTTOM extremeity }
  for Radius := nBars downto 1 do begin                    { For each colour bar in the Circle }
    ThisPal := Integer(Trunc(PalInc * Radius));            { Calc Palette }
     if ThisPal = 0 then                                   { Get the palette index }
        ThisPal := 1;                                      { If impossible then reset }
     ThisOne := PaletteIndex(PalOff - ThisPal);            { Get the RGB Palette }
     Scrn.Canvas.Pen.Color := ThisOne;                     { Set Pen }
     Scrn.Canvas.Brush.Color := ThisOne;                   { Set Brush }
     Scrn.Canvas.Chord(xl,yt,xr,yb,xl,yt,xl,yt);           { Draw the Circle }
     Inc(xl); Inc(yt); Dec(xr); Dec(yb);                   { Bump Vars }
     end;
End;

Procedure ReadBallDefaults;
Var
  Ini : TIniFile;
Begin
  Ini := TIniFile.Create('Wow.Ini');                   { Open the Ini File }
  Apptitle := 'Screen Saver.Delphi Balls';                 { Set title }
  PwdType := Ini.ReadInteger(AppTitle,'PwdType',0);        { Get the Password Type }
  BallMax := Ini.ReadInteger(AppTitle,'MaxBalls',64);      { Get Max Balls B4 clear Screen }
  BallSize := Ini.ReadInteger(AppTitle,'BallSize',128);    { Get Ball Size }

End;

end.
