unit Bitmap;

interface
Uses
  SysUtils, StdCtrls, WinTypes, WinProcs, Graphics, Classes, IniFiles;
Var
  BitmapFile                : string;
  AnimatePic                : Boolean;
  ScreenWidth, ScreenHeight : Integer;      { screen Width and Height }
  xPicPos, yPicPos          : Integer;      { picture position }
  xDirection, yDirection    : Integer;      { directions to move bitmap }
  PicWidth, PicHeight       : Integer;      { width & height of picture }
  Pic, PicHold              : TBitmap;      { Bitmap that is being displayed }
  PicRect,
  PicHoldRect,
  ScrnRect,
  OldScrnRect,
  RectUnion,
  RectUnionSize             : TRect;        { Rectangular area picture and
                                              & new screen area displayed in. }
Procedure ReadPicDefaults;                  { Read any defaults }
Procedure InitPicture;                      { Startup }
Procedure MovePic;                          { Move the Message }
Procedure FreePic;                          { Free any resources }

implementation
Uses
  Globals,
  Ssave;

Procedure ReadPicDefaults;                  { Read Defaults }
Var
  Ini   : TiniFile;
Begin
  Ini := TIniFile.Create('WOW.INI');        { Open the Ini File }
  Apptitle := 'Bitmap';                     { Set title }
  BitmapFile := Ini.ReadString(Apptitle,
                            'Bitmap File Location',
                            #0);            { bitmap filename }
  Speed := Ini.ReadInteger(Apptitle,
                           'Speed',25);     { Get the Speed }
  AnimatePic  := Boolean(Ini.ReadInteger(Apptitle,
                           'MoveOrPlot',1));{ Get the Speed }
  Ini.Free;
end;

procedure InitPicture;
begin
  ReadPicDefaults;                          { Read the Default Settings }
  Pic     := TBitmap.Create;                { Create the Bitmap }
  PicHold := TBitmap.Create;                { Create the Temp Hold Bitmap }
  if FileExists(BitmapFile) then
    Pic.LoadFromFile(BitmapFile)
  else
    Pic.Assign(Scrn.Image.Picture.Bitmap);

  xPicPos := 0;                             { get starting x }
  yPicPos := 0;                             { get starting y }
  ScreenWidth  := ScreenWd;                 { get Width }
  ScreenHeight := ScreenHt;                 { Get Height }
  PicWidth     := Pic.Width;
  PicHeight    := Pic.Height;
  PicHold.Width := Pic.Width + 10;
  PicHold.Height := Pic.Height + 10;
  PicRect          := Rect(0, 0, PicWidth, PicHeight);
  PicHoldRect      := Rect(0, 0, PicHold.Width, PicHold.Height);
  PicHold.Canvas.Brush.Color := clBlack;
  PicHold.Canvas.FillRect(PicHoldRect);
  PicHold.Canvas.Draw(5, 5, Pic);

  ScrnRect     := Rect(xPicPos, yPicPos, xPicPos + PicWidth,
                                yPicPos + PicHeight);
  xDirection   := -2;                       { get speed: }
  yDirection   := -2;                       { xDirection, yDirection = 1 or -1 }
end;

Procedure FreePic;
Begin
  Pic.Free;                                 { Free the Bitmap }
  PicHold.Free;                             { Free the Hold Bitmap }
end;


Procedure MovePic;
Begin
  if AnimatePic then
  begin 
    if ((xPicPos <= 0) or (xPicPos + PicWidth >= ScreenWidth))
         then xDirection := -xDirection;    { bounce light at X edges }
    if ((yPicPos <= 0) or (yPicPos + PicHeight >= ScreenHeight))
         then yDirection := -yDirection;    { bounce light at Y edges }
    xPicPos := xPicPos + xDirection;        { calculate new X position }
    yPicPos := yPicPos + yDirection;        { calculate new Y position }

    Scrn.Canvas.Draw(xPicPos, yPicPos, PicHold);

    Delay(Speed);                           { Delay a Bit }
  end { if Move }
  else
  begin
    xPicPos := random (ScreenWidth)  + 1;   { get starting x }
    yPicPos := random (ScreenHeight) + 1;   { get starting y }
    ScrnRect := Rect(xPicPos, yPicPos, xPicPos + PicWidth, yPicPos + PicHeight);
    Scrn.Canvas.CopyMode := cmSrcCopy;
    Scrn.Canvas.CopyRect(ScrnRect, Pic.Canvas, PicRect);
    Delay(Speed);                           { Delay a Bit }
  end;
end;

end.
