unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, FileCtrl, Gauges, ExtCtrls, DB;

type
  TForm1 = class(TForm)
    Database1: TDatabase;
    Label3: TLabel;
    Panel1: TPanel;
    Gauge1: TGauge;
    Label1: TLabel;
    Label2: TLabel;
    DirectoryListBox1: TDirectoryListBox;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn1: TBitBtn;
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses MakeDB;

function ShowProgress(const iPosition,iMax: integer; const sTable: string): boolean; far;
begin
  with Form1 do begin
    if iPosition = 0 then begin
      Tag := 0;
      Gauge1.MaxValue := iMax
      end
    else begin
      Label1.Caption := 'File '+IntToStr(iPosition)+'/'+IntToStr(iMax);
      Label2.Caption := 'Table Name: '+sTable;
      Gauge1.Progress := iPosition;
    end;
    Application.ProcessMessages;
    result := Tag <> -1;
    if not result then begin
      Screen.Cursor := crDefault;
      ShowMessage('Operation canceled by the user');
    end;
  end;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  with Database1 do begin
    Connected := false;
    Params.Values['PATH'] := DirectoryListBox1.Directory;
    Connected := true;
  end;
  BitBtn2.Enabled := false;
  BitBtn3.Enabled := false;
  try
    MakeAllTables(Database1,ShowProgress);
  finally
    BitBtn2.Enabled := true;
    BitBtn3.Enabled := true;
  end;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  Tag := -1;
end;

end.
