unit Winpwd;

interface
Uses WinProcs;

Function  EncryptString(Var S : String) : Boolean;
Procedure EncryptCString(S : PChar);


implementation



procedure WinEncrypt(Strg: PChar);
  procedure Exor (x1: byte; var x2: byte);

  const NotAllowed = [0..$20, $7f..$90, $93..$9f, $3d, $5b, $5d];
                   { the last three are '[]=' - not allowed in profile string }
  begin
   if not ((x2 xor x1) in NotAllowed) then x2 := x2 xor x1;
  end; { Exor }

var
  StrgPt, Strglg : Integer;                                { Local Vars }
  TheByte : Byte;                                          { Working Char }

begin
  StrgLg := lstrlen(Strg);                                 { Get String Length }
  if (StrgLg = 0) then exit;                               { empty string => nothing to do }
  AnsiUpper (Strg);                                        { capitalize the string }


  {================================ First Pass ==================================}

  for StrgPt := 0 to StrgLg - 1 do begin                   { proceed from left to right }
    TheByte := byte (Strg [StrgPt]);                       { get character to encrypt }
    Exor (StrgLg, TheByte);                                { xor it using string length...}
    if (StrgPt = 0) then                                   { If EOS }
      Exor ($2a, TheByte)                                  {...a constant...}
    else begin
      Exor (StrgPt, TheByte);                              {...actual string pointer...}
      Exor (byte (Strg [StrgPt-1]), TheByte);              {...previous character }
      end;
    Strg [StrgPt] := char (TheByte);                       { store encrypted byte back }
    end; { for };


  {=============================== Second Pass ==================================}

  if (StrgLg > 1) then                                     { no second pass for one-byte-strings }
    for StrgPt := StrgLg-1 downto 0 do begin               { proceed from right to left }
      TheByte := byte (Strg [StrgPt]);                     {  encrypt similar as in first pass }
      Exor (StrgLg, TheByte);                              { xor it using string length...}
      if (StrgPt = StrgLg - 1) then                        { If BOS }
        Exor ($2a, TheByte)                                {...a constant...}
      else begin
        Exor (StrgPt, TheByte);                            {...actual string pointer...}
        Exor (byte (Strg [StrgPt+1]), TheByte);            {...Next character }
        end;
      Strg [StrgPt] := char (TheByte);                     { store encrypted byte back }
      end; { for };

end; { WinCrypt }


Procedure EncryptCString(S : PChar);
Begin
  WinEncrypt(S);
end;

Function EncryptString(Var S : String) : Boolean;
begin
  Result := False;
  if S[0] < #254 then begin
    S[Integer(S[0]) + 1] := Chr(0);
    WinEncrypt(@S[1]);
    Result := True;
    end;
end;

end.
