unit Selectss;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons, IniFiles, Messages, SysUtils, Spin;

type
  TSsSelect = class(TForm)
    SsList: TListBox;
    Test: TBitBtn;
    Cancel: TBitBtn;
    Setup: TBitBtn;
    Label1: TLabel;
    CurSave: TEdit;
    Label2: TLabel;
    Label4: TLabel;
    Delay: TSpinEdit;
    procedure TestClick(Sender: TObject);
    procedure SetupClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SsListClick(Sender: TObject);
  private
    Loading : Boolean;
  public
    { Public declarations }
  end;

var
  SsSelect: TSsSelect;

implementation

{$R *.DFM}

Uses
  Globals,
  SSave,
  MsgDefs,
  BallDefs,
  SpotDefs;


procedure TSsSelect.TestClick(Sender: TObject);
begin
  TestMode := True;                                        { We are Testing }
  Scrn := TScrn.Create(Application);
  Scrn.LoadingApp := True;                                    { Loading Flag }
  Scrn.Left := -1000;
  Scrn.Top := -100;
  Scrn.Width := 0;
  Scrn.Height := 0;                                        { Hide the Screen }
  Scrn.ShowModal;                                          { Show it }
  Scrn.Free;
  SetFocus;                                                { Reset focus }
  TestMode := False;                                       { reset Test Mode }
end;

procedure TSsSelect.SetupClick(Sender: TObject);           { Want to set a Screen saver up }
begin
  Case SsList.ItemIndex of                                 { Work on Choice }
    1 : Begin
        SetupMsg := TSetupMsg.Create(Application);
        SetUpMsg.ShowModal;
        SetUpMsg.Free;
        End;
    2 : Begin
        SetupBalls := TSetupBalls.Create(Application);
        SetUpBalls.ShowModal;
        SetUpBalls.Free;
        end;
    3 : Begin
        SetupSpot := TSetupSpot.Create(Application);
        SetupSpot.ShowModal;
        SetupSpot.Free;
        end;
    end;
end;

procedure TSsSelect.CancelClick(Sender: TObject);
Var
  Ini : TiniFile;
begin
  Ini := TIniFile.Create('CONTROL.INI');                   { Create the Ini file }
  Ini.WriteInteger('DelphiMulti','SsType',
                    SsList.ItemIndex);                     { Write the current saver }
  CurSave.Text := SsList.Items[SsType];                    { Get the Current saver }
  SystemParametersInfo(SPI_SETSCREENSAVETIMEOUT,
                       Delay.Value * 60,
                       nil,
                       SPIF_UPDATEINIFILE +
                       SPIF_SENDWININICHANGE);             { Update SS delay where ever it lives }
  if SsType = 0 then                                       { If NO screen saver }
    SystemParametersInfo(SPI_SETSCREENSAVEACTIVE,
                       0,
                       nil,
                       SPIF_UPDATEINIFILE +
                       SPIF_SENDWININICHANGE);            { Set in registry }

  Close;                                                  { Bye Bye }
end;

procedure TSsSelect.FormCreate(Sender: TObject);
begin
  Loading := True;                                         { Createing so set loading }
end;

procedure TSsSelect.FormActivate(Sender: TObject);
begin
  If Loading then Begin                                    { If we are loading }
    Loading := False;                                      { Reset the flag }
    ReadDefaults;                                          { Read system deafualts }
    Delay.Value := SsDelay;                                { Get the Delay }
    SsList.ItemIndex := SsType;                            { Set the List box up }
    CurSave.Text := SsList.Items[SsType];                  { Get the Current Saver }
    if SsType = 0 then begin                               { If None }
      Test.Enabled := False;
      Setup.Enabled := False;
      Delay.Enabled := False;                              { Disable the Test, setup and Delay controls }
      end;
    end;
end;

procedure TSsSelect.SsListClick(Sender: TObject);
begin
  SsType := SsList.ItemIndex;                              { Get the Type }
  if SsType = 0 then begin                                 { If NONE }
    Test.Enabled := False;
    Setup.Enabled := False;
    Delay.Enabled := False;                                { Disable the Test, setup and Delay controls }
    end
  else begin
    Test.Enabled := True;
    Setup.Enabled := True;
    Delay.Enabled := True;                                 { Enable the Test, setup and Delay controls }
    end;
  CurSave.Text := SsList.Items[SsList.ItemIndex];          { Set the Current Saver }
end;


end.
