unit Codemsg;

interface
Uses
  Graphics, StdCtrls;

Var
  BitMsg : TBitmap;                                        { Bitmap of the Message }
  Msg    : TLabel;                                         { Label ( created on the Fly }

Procedure MoveMsg;                                         { Move the Message }
Procedure InitMessage;                                     { Startup }
Procedure FreeMsg;                                         { Free any resources }
Procedure ReadMsgDefaults;                                 { Read any defaults }

implementation
Uses
  Globals,
  Ssave,
  IniFiles;

Procedure ReadMsgDefaults;                                 { Read Defaults }
Var
  Ini   : TiniFile;
  Fnt   : Integer;                                         { Font }
  Style : TFontStyles;                                     { Font Styles }
Begin
  Ini := TIniFile.Create('CONTROL.INI');                   { Open the Ini File }
  MsgFont := TFont.Create;                                 { Create Font }
  Apptitle := 'Screen Saver.Delphi Message';               { Set title }
  MsgFont.Name := Ini.ReadString(AppTitle,
                                 'FontName',               { Read Font Name }
                                 'Arial');
  MsgFont.Size := Ini.ReadInteger(AppTitle,
                                 'FontSize',
                                 8);                       { Read Font Size }
  MsgFont.Height := Ini.ReadInteger(AppTitle,
                                 'FontHeight',
                                 -13);                     { Read Font Height }
  MsgFont.Color := Ini.ReadInteger(AppTitle,
                                   'FontColour',
                                   Ord(clWhite));          { Read Colour }
  Fnt := Ini.ReadInteger(AppTitle,
                         'FontStyle',
                         0);                               { Read the Style }
  Style := [];
  if Fnt and 1 = 1 then Include(Style,fsBold);             { Check Bold }
  if Fnt and 2 = 2 then Include(Style,fsItalic);           { Check Italic }
  if Fnt and 4 = 4 then Include(Style,fsUnderline);        { Check Underline }
  if Fnt and 8 = 8 then Include(Style,fsStrikeOut);        { Check strikout }
  MsgFont.Style := Style;                                  { Set the Style }

  BkGrnd := Ini.ReadInteger(Apptitle,
                            'BkGrnd',
                            Ord(clBlack));                 { Get the background colour }
  MsgText := Ini.ReadString(Apptitle,
                            'Msg',
                            'Delphi rules, VB sux') + ' '; { Get the Text }
  Speed := Ini.ReadInteger(Apptitle,
                           'Speed',25);                    { Get the Speed }
  CntrText := Ini.ReadBool(AppTitle,
                           'Centered',
                           True);                          { Get Centered }
  Fg := Ini.ReadInteger(AppTitle,'Fg',15);                 { Read The Foreground Color }
  Bg := Ini.ReadInteger(AppTitle,'Bg',0);                  { Read The Background Color }
  PwdType := Ini.ReadInteger(AppTitle,
                             'PwdType',0);                 { Get Pwd Type }
  Pwd := Ini.ReadString('ScreenSaver',
                        'Password',
                        '');                               { Read the Password, if any }
end;

procedure InitMessage;
begin
  ReadMsgDefaults;                                         { Read the Default Settings }
  Msg := TLabel.Create(Scrn);                              { Create the Label }
  Msg.Parent := Scrn;                                      { Set Parent }
  Msg.Visible := False;                                    { Set Visible }
  Msg.Caption := MsgText;                                  { Get the Text }
  Msg.Font := MsgFont;                                     { Set the Font }
  iObjL := ScreenWd;                                       { Start with Message a Right edge }
  iObjR := ScreenWd + Msg.Width;                           { Grab the width }
  iObjT := (ScreenHt - Msg.Height) Div 2;                  { Set Message top to MID screen }
  BitMsg := TBitmap.Create;                                { Create the Bitmap }
  BitMsg.Width := Msg.Width;                               { Set width to Message Width }
  BitMsg.Height := Msg.Height;                             { Set Height to Message Height}
  with BitMsg.Canvas do begin                              { Now transfer the Message to the bitmap }
    Brush.Color := BkGrnd;                                 { Background to default }
    Font := Msg.Font;                                      { Grab the Message Font }
    TextOut(0,0,Msg.Caption);                              { Wack the Text in }
    end;
end;

Procedure FreeMsg;
Begin
  BitMsg.Free;                                             { Free the Bitmap }
  Msg.Free;                                                { Free the Bitmap }
end;

Procedure MoveMsg;
Begin
  Dec(iObjL,1);                                            { Move Left }
  Dec(iObjR,1);                                            { Adjust RIGHT }
  if iObjR < 0 then begin                                  { if OFF screen }
    if Not CntrText then begin                             { If not Centered }
      iObjT := Random(Scrn.Height);                        { Get new Random position }
      if iObjT + Msg.Height > ScreenHt then                { if we are off the Screen }
        iObjT := ScreenHt - Msg.Height;                    { Move back on again }
      end;
    iObjL := ScreenWd;                                     { Reset the RIGHT edge }
    iObjR := iObjL + Msg.Width;                            { Reset R margin }
    end;
  Scrn.Canvas.Draw(iObjL,iObjT,BitMsg);                    { Draw the Message }
  Delay(Speed);                                            { Delay a Bit }
end;

end.
