unit Sgt_u1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Grids, SASG, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    Button1: TButton;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    SpinEdit3: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Button2: TButton;
    Label6: TLabel;
    Label7: TLabel;
    Button3: TButton;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    SortAStringGrid1: TSortAStringGrid;
    Panel1: TPanel;
    Label8: TLabel;
    Column1: TSpeedButton;
    Column2: TSpeedButton;
    Column3: TSpeedButton;
    Column4: TSpeedButton;
    Row1: TSpeedButton;
    Row2: TSpeedButton;
    Row3: TSpeedButton;
    Row4: TSpeedButton;
    Column0: TSpeedButton;
    Row0: TSpeedButton;
    Label9: TLabel;
    Label10: TLabel;
    Image1: TImage;
    Row5: TSpeedButton;
    Row6: TSpeedButton;
    Row7: TSpeedButton;
    Row8: TSpeedButton;
    Column5: TSpeedButton;
    Column6: TSpeedButton;
    Column7: TSpeedButton;
    Column8: TSpeedButton;
    Label11: TLabel;
    CheckBox5: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure Column1Click(Sender: TObject);
    procedure Column2Click(Sender: TObject);
    procedure Column3Click(Sender: TObject);
    procedure Column4Click(Sender: TObject);
    procedure Row1Click(Sender: TObject);
    procedure Row2Click(Sender: TObject);
    procedure Row3Click(Sender: TObject);
    procedure Row4Click(Sender: TObject);
    procedure Column0Click(Sender: TObject);
    procedure Row0Click(Sender: TObject);
    procedure CheckBoxClick(Sender: TObject);
    procedure Column5Click(Sender: TObject);
    procedure Column6Click(Sender: TObject);
    procedure Column7Click(Sender: TObject);
    procedure Column8Click(Sender: TObject);
    procedure Row5Click(Sender: TObject);
    procedure Row6Click(Sender: TObject);
    procedure Row7Click(Sender: TObject);
    procedure Row8Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure StartTheSort(Sender: TObject);
    procedure Speedclick(Sender: TObject; SortIDX : Integer; SortOnRow : BOOLEAN);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
   SortAStringGrid1.SortIndex  := SpinEdit1.Value;
   SortAStringGrid1.StartIndex := SpinEdit2.Value;
   SortAStringGrid1.EndIndex   := SpinEdit3.Value;
   If CheckBox4.Checked Then
      SortAStringGrid1.HowToSort := Row
   Else
      SortAStringGrid1.HowToSort := Column;
   StartTheSort(Sender);
end;

Procedure TForm1.StartTheSort(Sender : TObject);

Begin
   With SortAStringGrid1 Do
   begin
      If CheckBox1.Checked Then
         SortDirection := Ascending
      Else
         SortDirection := Descending;
      If CheckBox2.Checked Then
         SortType := Character
      Else
         SortType := Numeric;
      CaseSensitiv := CheckBox5.Checked;
      ShowMessageOnError := CheckBox3.Checked;
      If Execute Then begin end;
      Label7.Caption := ErrorText;
      Label1.Caption := ' '+IntToStr(ErrorCode)
   end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   Button3Click(Sender)
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   Close
end;

procedure TForm1.Button3Click(Sender: TObject);
var
   FillCount1,FillCount2 : Integer;

Function Make4Chars : String;
var
   tel : byte;
   OutString : string;
   NewChar   : Char;
begin
   OutString := '';
   FOR tel := 1 TO 4 DO
   BEGIN
      IF Random(2) = 0 THEN
         NewChar := Chr(Ord('A')+Random(26))
      Else
         NewChar := Chr(Ord('a')+Random(26));
      OutString := OutString+NewChar
   END;
   Make4Chars := OutString;
end;

begin
   Randomize;
   For FillCount1 := 1 to 8 do
   begin
      StringGrid1.Rows[0].Strings[FillCount1] := 'Col '+IntToStr(FillCount1);
      StringGrid1.Cols[0].Strings[FillCount1] := 'Row '+IntToStr(FillCount1);
      For FillCount2 := 1 to 8 do
         if CheckBox4.Checked Then
         begin
            If FillCount2 < 5 Then
               StringGrid1.Rows[FillCount1].Strings[FillCount2] := Make4Chars
            Else
               StringGrid1.Rows[FillCount1].Strings[FillCount2] := IntToStr(Random(10000))
         end
         else
         begin
            If FillCount2 < 5 Then
               StringGrid1.Cols[FillCount1].Strings[FillCount2] := Make4Chars
            Else
               StringGrid1.Cols[FillCount1].Strings[FillCount2] := IntToStr(Random(10000))
         end
   end
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
   Button3Click(Sender);
   CheckBoxClick(Sender)
end;

procedure TForm1.Speedclick(Sender: TObject; SortIDX : Integer; SortOnRow : BOOLEAN);

begin
   With SortAStringGrid1 Do
   begin
      SortIndex := SortIDX;
      StartIndex := 1;
      EndIndex := 8;
      If SortOnRow Then
      begin
         HowToSort := Row;
         CheckBox4.Checked := True
      end
      else
      begin
         HowToSort := Column;
         CheckBox4.Checked := False
      end;
      SpinEdit1.Value := SortIDX;
      SpinEdit2.Value := 1;
      SpinEdit3.Value := 8;
   end;
   StartTheSort(Sender);
end;

procedure TForm1.Column0Click(Sender: TObject);
begin
   Speedclick(Sender,0,True);
end;

procedure TForm1.Column1Click(Sender: TObject);
begin
   Speedclick(Sender,1,True);
end;

procedure TForm1.Column2Click(Sender: TObject);
begin
   Speedclick(Sender,2,True);
end;

procedure TForm1.Column3Click(Sender: TObject);
begin
   Speedclick(Sender,3,True);
end;

procedure TForm1.Column4Click(Sender: TObject);
begin
   Speedclick(Sender,4,True);
end;

procedure TForm1.Column5Click(Sender: TObject);
begin
   Speedclick(Sender,5,True);
end;

procedure TForm1.Column6Click(Sender: TObject);
begin
   Speedclick(Sender,6,True);
end;

procedure TForm1.Column7Click(Sender: TObject);
begin
   Speedclick(Sender,7,True);
end;

procedure TForm1.Column8Click(Sender: TObject);
begin
   Speedclick(Sender,8,True);
end;

procedure TForm1.Row0Click(Sender: TObject);
begin
   Speedclick(Sender,0,False);
end;

procedure TForm1.Row1Click(Sender: TObject);
begin
   Speedclick(Sender,1,False);
end;

procedure TForm1.Row2Click(Sender: TObject);
begin
   Speedclick(Sender,2,False);
end;

procedure TForm1.Row3Click(Sender: TObject);
begin
   Speedclick(Sender,3,False);
end;

procedure TForm1.Row4Click(Sender: TObject);
begin
   Speedclick(Sender,4,False);
end;

procedure TForm1.Row5Click(Sender: TObject);
begin
   Speedclick(Sender,5,False);
end;

procedure TForm1.Row6Click(Sender: TObject);
begin
   Speedclick(Sender,6,False);
end;

procedure TForm1.Row7Click(Sender: TObject);
begin
   Speedclick(Sender,7,False);
end;

procedure TForm1.Row8Click(Sender: TObject);
begin
   Speedclick(Sender,8,False);
end;

procedure TForm1.CheckBoxClick(Sender: TObject);
begin
   If CheckBox1.Checked Then
      Label9.Caption := 'Ascending, '
   else
      Label9.Caption := 'Descending, ';
   If CheckBox2.Checked Then
      Label9.Caption := Label9.Caption+'Character, '
   else
      Label9.Caption := Label9.Caption+'Numeric, ';
   If CheckBox5.Checked Then
      Label9.Caption := Label9.Caption+'Case Sensitiv, '
   else
      Label9.Caption := Label9.Caption+'Not Case Sensitiv, ';
   If CheckBox3.Checked Then
      Label9.Caption := Label9.Caption+'Show Message, '
   else
      Label9.Caption := Label9.Caption+'No Message, ';
   If CheckBox4.Checked Then
      Label9.Caption := Label9.Caption+'Rows'
   else
      Label9.Caption := Label9.Caption+'Columns'
end;

end.
