{
Simple AntiCopy Component
version 2.00
Author : Oleg Subachev
45A - 11, Zavodskaya St., V-109
Ekaterinburg, 620109, Russia
e-mail: soi@urvb.e-burg.su
}

{$B-}

unit SACC;
{ Copyright (C) 1992-97 by Oleg Subachev, Ekaterinburg, Russia }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  SACCOption = (
                 START_DR,               { check for application's start drive }
                 FULL_PATH                 { check for application's full path }
               );
  SACCOptions = set of SACCOption;

  TSACC = class( TComponent )
  private
    FOptions : SACCOptions;
    FOnPROTECT : TNotifyEvent;
    procedure SetOptions( Value : SACCOptions );
    function VSE_OK : boolean;
  protected
    procedure DoOnPROTECT; dynamic;
  public
    constructor Create( AOwner : TComponent ); override;
    procedure GO_SACC;
  published
    property Options : SACCOptions read FOptions write SetOptions
      default [ FULL_PATH ];
    property OnPROTECT : TNotifyEvent read FOnPROTECT write FOnPROTECT;
  end;                                                                 { TSACC }

procedure Register;

implementation

uses
  FIND_ID;

procedure COPY_RIGHT;
{ because description directive ($D) is allowed only in program or DLL }
{ I use this routine for the same purpose }
var
  sCR : string;
begin
         { this text will appear in .DCU }
  sCR := ' Simple AntiCopy 2.00 is copyright (C) 1992-97 by Oleg Subachev,' +
         ' Ekaterinburg, Russia, soi@urvb.e-burg.su ';
end;                                                              { COPY_RIGHT }

constructor TSACC.Create( AOwner : TComponent );
begin
  inherited Create( AOwner );
  FOptions := [ FULL_PATH ];
end;                                                            { TSACC.Create }

procedure TSACC.DoOnPROTECT;
begin
  if Assigned( FOnPROTECT )
    then FOnPROTECT( Self );
end;                                                       { TSACC.DoOnPROTECT }

procedure TSACC.SetOptions( Value : SACCOptions );
begin
  if FOptions <> Value
    then FOptions := Value;
end;                                                        { TSACC.SetOptions }

procedure Register;
begin
  RegisterComponents( 'POSOl', [ TSACC ] );
end;                                                                { Register }

type
  TSACC_DATA =
    record
      case integer of
        1: ( SACC_ID : string[ 255 ]);           { 256 bytes will be allocated }
        2: (
          EXEC_1 : ByteBool;                         { flag of first execution }
          ac_STRTDR : byte;                { protected .EXE file's start drive }
          ac_FLLPTH : word;           { full start path of protected .EXE file }
           );
    end;                                                          { TSACC_DATA }

const
  SACC_DATA : TSACC_DATA = ( SACC_ID : 'SACC_ID' );

var
  f : integer;                            { file handle of protected .EXE file }
  PS0 : TFileName;                                           { = ParamStr( 0 ) }
  bySTRTDR : byte;
  wFLLPTH : word;

procedure DETERMINE;
{ determines information for checking }
var
  I : integer;
begin
  wFLLPTH := 0;
  for I := 1 to Length( PS0 )
    do Inc( wFLLPTH, Ord( PS0[ I ] ));
  { not is added for "encryption" }
  bySTRTDR := not ( Ord( PS0[ 1 ] ));
end;                                                               { DETERMINE }

procedure ZAPIS; { <- russian for "writing" }
{ writes information for checking in file f }

var
  lSIFO : longint;                                       { SACC_ID file offset }
  lDT : longint;                         { date and time for File(Get-Set)Date }

  procedure SACC_SEEK( const lOFFS : longint );
  { moves current position in f to lOFFS }
  begin
    FileSeek( f, lOFFS, 0 );
  end;                                                             { SACC_SEEK }

  function FASP( var TC ) : longint;
  { returns file offset of typed constant TC }
  begin
    with SACC_DATA do
      FASP := lSIFO + ( Ofs( TC ) - Ofs( SACC_ID[ 0 ]));
  end;                                                                  { FASP }

begin                                                                  { ZAPIS }
  with SACC_DATA do
    lSIFO := FIND_ID_FROM_END( PS0, SACC_ID[ 0 ], Length( SACC_ID ) + 1 );
  if lSIFO = 0
    then Halt;
  lDT := FileGetDate( f );     { save date and time of the protected .EXE file }

{ writing of new values of typed constants into protected .EXE file }
  with SACC_DATA do
    begin
      EXEC_1 := False;
      SACC_SEEK( FASP( EXEC_1 ));
      FileWrite( f, EXEC_1, SizeOf( EXEC_1 ));
      SACC_SEEK( FASP( ac_FLLPTH ));
      FileWrite( f, wFLLPTH, SizeOf( wFLLPTH ));
      SACC_SEEK( FASP( ac_STRTDR ));
      FileWrite( f, bySTRTDR, SizeOf( bySTRTDR ));
    end;

  FileSetDate( f, lDT );    { restore date and time of the protected .EXE file }
  Application.Terminate;
end;                                                                   { ZAPIS }

function TSACC.VSE_OK : boolean;
begin
  with SACC_DATA
    do Result := (not (FULL_PATH in FOptions) or (ac_FLLPTH = wFLLPTH))
             and (not (START_DR in FOptions) or (ac_STRTDR = bySTRTDR));
end;                                                            { TSACC.VSE_OK }

procedure NA_FIG; { <- the name of procedure is russian slang }
{ you can use this procedure to wipe out protected .EXE file }
var
  ff : file;
  L : longint;
begin
  AssignFile( ff, PS0 );
  Reset( ff, 1 );
  try
    Seek( ff, 0 );
    for L := 1 to FileSize( ff ) div SizeOf( L )
      do BlockWrite( ff, L, SizeOf( L ));
  finally
    CloseFile( ff );
    Erase( ff );
  end;
end;                                                                  { NA_FIG }

procedure TSACC.GO_SACC;
{ main routine that performs all work }
begin
  if not ( csDesigning in ComponentState ) then
    begin
      f := FileOpen( ParamStr( 0 ), fmOpenReadWrite );
      try
        if f < 0
          then Halt;
        PS0 := ParamStr( 0 );
        DETERMINE;
        if SACC_DATA.EXEC_1
          then ZAPIS
          else
            if not VSE_OK
              then DoOnPROTECT;
      finally
        FileClose( f );
      end;
    end;
end;                                                           { TSACC.GO_SACC }

end.

{
other information that may be checked:
- BIOS date
- IDE HDD controller information ( unique for each HDD )
- volume serial number
- boot sector of drive C:
- equipment word from BIOS data
- CMOS values
- file length
- control sum of file
- file name
- size of current drive
- current directory
- number of first cluster of file
- partition table
- OS version
- presence of some drivers
- MAC address of LAN card
}

