unit Rungle;

{
  Subset of Russkaja Latinica (c) 1995 by Alex Khrabrov & Serge Winitzky
  (http://kulichki.rambler.ru/centrolit/rl/)

  FREEWARE, Version 1.01b, Copyleft (c) 1998,2000 Alexander Ilyin alexil@aha.ru
}

interface

uses WinTypes, WinProcs, SysUtils, Classes, Controls;

type
  TConversionDirection = (cdLatinToRussian, cdRussianToLatin);
  TShchaConvMode = (scUseSj, scUseShch, scUseW, scUseQ, scUseSch);
  TXaConvMode = (xcUseX, xcUseKH);
  TWInterpMode = (wiAsV, wiAsSj);

  TRungler = class(TComponent)
  private
    FTransOn: Boolean;
    FDirection: TConversionDirection;
    FWasUp: Boolean;
    FIsUp: Boolean;
    FShchaMode: TShchaConvMode;
    FXaMode: TXaConvMode;
    FWMode: TWInterpMode;
    FOriginal: String;
    FConverted: String;
    FDummy: String;
    procedure SetOriginal(const S: String);
    procedure SetShcha(SM: TShchaConvMode);
    procedure SetXa(XM: TXaConvMode);
    procedure SetW(WI: TWInterpMode);
  protected
    function ConvertString(const S: String): String; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    procedure ConvertStrings(Strings: TStrings);
  published
    property TransOn: Boolean read FTransOn write FTransOn
      default True;
    property Direction: TConversionDirection read FDirection write FDirection
      default cdRussianToLatin; 
    property ShchaConvMode: TShchaConvMode read FShchaMode write SetShcha
      default scUseSj;
    property XaConvMode: TXaConvMode read FXaMode write SetXa
      default xcUseX;
    property WInterpMode: TWInterpMode read FWMode write SetW
      default wiAsV;
    property OriginalStr: String read FOriginal write SetOriginal;
    property ConvertedStr: String read FConverted write FDummy;
  end;

procedure Register;

implementation

const
  C2N	= '#';
  C2Y	: String[2] = 'yo';
  C2R	: array[''..''] of String[4] = (
    'a','b','v','g','d','e','zh','z','i','j','k','l','m','n','o','p','r','s',
    't','u','f','x','c','ch','sh','sj','~','y','''','e''','yu','ya');

  Switchars = ['a'..'z', 'A'..'Z', '''', '`', '~', '@', '\'];

  R2Cl	: String[31] = 'EOAITSRNVPMLKDU`''YJZBGFXC~@WQH';
  R2Cr	: String[31] = '';


function UpCaseCyr(c: Char): Char; assembler;
asm
{$ifndef WIN32}
	MOV	AL, [c]
{$endif}
	CMP	AL, 'a'
	JB	@@End
	MOV	DL, 32
	CMP	AL, 'z'
	JBE	@@Ok
	CMP	AL, ''
	JAE	@@Ok
	CMP	AL, ''
        JNE	@@End
        MOV	DL, 16
@@Ok:
	SUB	AL, DL
@@End:

end;

constructor TRungler.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTransOn := True;
  FDirection := cdRussianToLatin;
  FShchaMode := scUseSj;
  FXaMode := xcUseX;
  FWMode := wiAsV;
end;

procedure TRungler.SetW(WI: TWInterpMode);
var
  i: Integer;
  c: Char;
begin
  if FWMode <> WI then begin
    FWMode := WI;
    if WI = wiAsV then c := '' else c := '';
    i := Pos('W', R2Cl);
    if i > 0 then R2Cr[i] := c;
  end;
end;

procedure TRungler.SetShcha(SM: TShchaConvMode);
var
  s: String[4];
begin
  if FShchaMode <> SM then begin
    FShchaMode := SM;
    case SM of
      scUseShch:
	s := 'shch';
      scUseSj:
	s := 'sj';
      scUseQ:
	s := 'q';
      scUseW:
	s := 'w';
      scUseSch:
	s := 'sch';
    end;
    C2R[''] := s;
  end;
end;

procedure TRungler.SetXa(XM: TXaConvMode);
var
  s: String[4];
begin
  if FXaMode <> XM then begin
    FXaMode := XM;
    if XM = xcUseX then s := 'x' else s := 'kh';
    C2R[''] := s;
  end;
end;

function TRungler.ConvertString(const S: String): String;
var
  i, j, l: Integer;
  c, u: Char;
  x: String;
  c1, c2, c3: Char;
  bFU, bFL: Boolean;

  function ProperCase(c: Char): Char;
  var
    x: Char;
    bUp: Boolean;
  begin
    bUp := False;
    if bFU then begin
      bUp := True;
      FIsUp := True;
    end else begin
      if bFL then begin
        FIsUp := False;
      end else begin
	if FIsUp then begin
	  bUp := True;
	end else begin
          if i > l then x := #0 else x := S[i];
	  bUp := (FWasUp and (UpCase(x) = x));
          FIsUp := bUp;
	end;
      end;
    end;
    if bUp then Result := UpCaseCyr(c) else Result := c;
    bFU := False;
    bFL := False;
    FWasUp := FIsUp;
  end;

  function IsCaseModifier: Boolean;
  begin
    Result := (c1 = '^') or (c1 = '_');
    if Result then begin
      bFU := (c1 = '^');
      bFL := (c1 = '_');
    end;
  end;

begin
  Result := EmptyStr;
  l := Length(S);
  if FDirection = cdRussianToLatin then begin
    for i := 1 to l do begin
      c := S[i];
      u := UpCaseCyr(c);
      FIsUp := (c = u);
      if not (u in [''..'', '']) then begin
	AppendStr(Result, c);
	FWasUp := False;
      end else begin
	if u = '' then
	  x := C2Y
	else if u = '' then
	  x := C2N
	else
	  x := C2R[u];
	if FIsUp then begin
	  if i < l then c := S[i + 1] else c := #0;
	  if FWasUp and (c = UpCaseCyr(c)) then x := UpperCase(x);
	  x[1] := UpCase(x[1]);
	end;
	AppendStr(Result, x);
	FWasUp := FIsUp;
      end;
    end;
  end else begin
    bFU := False;
    bFL := False;
    i := 1;
    while i <= l do begin
      c := S[i];
      if not (c in Switchars) then begin
	AppendStr(Result, c);
	Inc(i);
	continue;
      end;
      if i < l then c1 := UpCase(S[i + 1]) else c1 := #0;
      if i < l - 1 then c2 := UpCase(S[i + 2]) else c2 := #0;
      if i < l - 2 then c3 := UpCase(S[i + 3]) else c3 := #0;
      u := UpCase(c);
      FIsUp := False;
      if u in ['A'..'Z'] then if c = u then FIsUp := True else bFL := True;
      if (u = '\') and (c1 = ' ') then begin
	FTransOn := not FTransOn;
	Inc(i, 2);
	continue;
      end;
      if FTransOn then begin
	case u of
	  '\':
	    begin
	      if c1 in ['~','''','`','@','\'] then begin
		Inc(i, 2);
		AppendStr(Result, ProperCase(c1));
	      end else begin
		Inc(i);
	      end;
	      continue;
	    end;
	  'Y':
	    case c1 of
	      'A':
		begin
		  Inc(i, 2);
		  AppendStr(Result, ProperCase(''));
		  continue;
		end;
	      'O':
		begin
		  Inc(i, 2);
		  AppendStr(Result, ProperCase(''));
		  continue;
		end;
	      'U':
		begin
		  Inc(i, 2);
		  AppendStr(Result, ProperCase(''));
		  continue;
		end;
	    end;
	  'S':
	    case c1 of
	      'H':
		if (c2 = 'C') and (c3 = 'H') then begin
		  Inc(i, 4);
		  AppendStr(Result, ProperCase(''));
		  continue;
		end else begin
		  Inc(i, 2);
		  AppendStr(Result, ProperCase(''));
		  continue;
		end;
	      'J':
		begin
		  Inc(i, 2);
		  AppendStr(Result, ProperCase(''));
		  continue;
		end;
	    end;
	  'C':
	    if c1 = 'H' then begin
	      Inc(i, 2);
	      AppendStr(Result, ProperCase(''));
	      continue;
	    end;
	  'Z':
	    if c1 = 'H' then begin
	      Inc(i, 2);
	      AppendStr(Result, ProperCase(''));
	      continue;
	    end;
	  'K':
	    if c1 = 'H' then begin
	      Inc(i, 2);
	      AppendStr(Result, ProperCase(''));
	      continue;
	    end;
	  'E':
	    if (c1 = '''') or (c1 = '`') then begin
	      Inc(i, 2);
	      AppendStr(Result, ProperCase(''));
	      continue;
	    end;
	  'J':
	    if (c1 = '''') or (c1 = '`') then begin
	      Inc(i, 2);
	      AppendStr(Result, ProperCase(''));
	      continue;
	    end;
	  '''','`':
	    if IsCaseModifier then begin
	      Inc(i, 2);
	      AppendStr(Result, ProperCase(''));
	      continue;
	    end;
	  '~':
	    if IsCaseModifier then begin
	      Inc(i, 2);
	      AppendStr(Result, ProperCase(''));
	      continue;
	    end;
	  '@':
	    if IsCaseModifier then begin
	      Inc(i, 2);
	      AppendStr(Result, ProperCase(''));
	      continue;
	    end;
	end;
	j := Pos(u, R2Cl);
	if j > 0 then c := R2Cr[j];
      end;
      Inc(i);
      AppendStr(Result, ProperCase(c));
    end;
  end;
end;

procedure TRungler.SetOriginal(const S: String);
begin
  if S <> FOriginal then begin
    FIsUp := False;
    FWasUp := False;
    FOriginal := S;
    FConverted := ConvertString(S);
  end;
end;

procedure TRungler.ConvertStrings(Strings: TStrings);
var
  i: Integer;
begin
  FIsUp := False;
  FWasUp := False;
  for i := 0 to Strings.Count - 1 do begin
    Strings[i] := ConvertString(Strings[i]);
  end;
end;

procedure Register;
begin
  RegisterComponents('Misc', [TRungler]);
end;

end.
