unit GuiMain;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Rungle;

type
  TfrmMain = class(TForm)
    rglTest: TRungler;
    Label1: TLabel;
    Label2: TLabel;
    btnConv: TButton;
    memSrc: TMemo;
    memRes: TMemo;
    btnLoad: TButton;
    dlgOpen: TOpenDialog;
    btnCpy: TButton;
    gbxOpt: TGroupBox;
    Label3: TLabel;
    cmbSj: TComboBox;
    Label4: TLabel;
    cmbKh: TComboBox;
    Label5: TLabel;
    cmbW: TComboBox;
    gbxDir: TGroupBox;
    rbtRusLat: TRadioButton;
    rbtLatRus: TRadioButton;
    procedure btnConvClick(Sender: TObject);
    procedure rbtRusLatClick(Sender: TObject);
    procedure rbtLatRusClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure btnCpyClick(Sender: TObject);
    procedure cmbSjChange(Sender: TObject);
    procedure cmbKhChange(Sender: TObject);
    procedure cmbWChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnConvClick(Sender: TObject);
begin
  memRes.Lines.Assign(memSrc.Lines);
  rglTest.ConvertStrings(memRes.Lines);
  btnCpy.Enabled := memRes.Lines.Count > 0;
end;

procedure TfrmMain.rbtRusLatClick(Sender: TObject);
begin
  rglTest.Direction := cdRussianToLatin;
end;

procedure TfrmMain.rbtLatRusClick(Sender: TObject);
begin
  rglTest.Direction := cdLatinToRussian;
end;

procedure TfrmMain.btnLoadClick(Sender: TObject);
begin
  if dlgOpen.Execute then memSrc.Lines.LoadFromFile(dlgOpen.FileName);
end;

procedure TfrmMain.btnCpyClick(Sender: TObject);
begin
  memSrc.Lines.Assign(memRes.Lines);
end;

procedure TfrmMain.cmbSjChange(Sender: TObject);
begin
  rglTest.ShchaConvMode := TShchaConvMode(cmbSj.ItemIndex);
end;

procedure TfrmMain.cmbKhChange(Sender: TObject);
begin
  rglTest.XaConvMode := TXaConvMode(cmbKh.ItemIndex);
end;

procedure TfrmMain.cmbWChange(Sender: TObject);
begin
  rglTest.WInterpMode := TWInterpMode(cmbW.ItemIndex);
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
  cmbSj.ItemIndex := 0;
  cmbKh.ItemIndex := 0;
  cmbW.ItemIndex := 0;
end;

end.
