uses SysUtils, Classes, Rungle;

{$ifdef WIN32}
{$apptype console}
{$endif}

var
  l: TStringList;
  r: TRungler;

begin
  if ParamCount = 0 then begin
    WriteLn('Usage: ConsTest filename'#13#10);
    WriteLn('NOTE: File must contain only ANSI-coded Russian text');
    Exit;
  end;
  if not FileExists(ParamStr(1)) then begin
    WriteLn('Input file does not exist');
    Halt(1);
  end;
  l := TStringList.Create;
  r := TRungler.Create(nil);
  try
    l.LoadFromFile(ParamStr(1));
    r.Direction := cdRussianToLatin;
    r.ConvertStrings(l);
    l.SaveToFile(ChangeFileExt(ParamStr(1), '.$L'));
    r.Direction := cdLatinToRussian;
    r.ConvertStrings(l);
    l.SaveToFile(ChangeFileExt(ParamStr(1), '.$R'));
  finally
    r.Free;
    l.Free;
  end;
end.
