unit Rulers;
{By Bill Murto, 73730,2505 No Copyright. Free. Enjoy.}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms;

type
  THRuler = class(TGraphicControl)
  private
    { Private declarations }
    fHRulerAlign: TAlign;
    procedure SetHRulerAlign(Value: TAlign);
  protected
    { Protected declarations }
    procedure Paint; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property AlignHRuler: TAlign read fHRulerAlign write SetHRulerAlign default alNone;
    property Color default clYellow;
    property Height default 33;
    property Width default 768;
    property Visible;
  end;

  type
  TVRuler = class(TGraphicControl)
  private
    { Private declarations }
    fVRulerAlign: TAlign;
    procedure SetVRulerAlign(Value: TAlign);
  protected
    { Protected declarations }
    procedure Paint; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property AlignVRuler: TAlign read fVRulerAlign write SetVRulerAlign default alNone;
    property Color default clYellow;
    property Height default 1008;
    property Width default 33;
    property Visible;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [THRuler, TVRuler]);
end;

procedure THRuler.SetHRulerAlign(Value: TAlign);
begin
  if Value in [alTop, alBottom, alNone] then
  begin
    fHRulerAlign := Value;
    Align := Value;
  end;
end;

constructor THRuler.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  AlignHRuler := alNone;
  Color := clYellow;
  Height := 33;
  Width := 768;
end;

procedure THRuler.Paint;
var a12th, N, X : word;
begin
  a12th := Screen.PixelsPerInch div 12;
  N := 0; X := 0;
  with Canvas do
  begin
    Brush.Color := Color;
    FillRect(ClientRect);
    with ClientRect do
      Rectangle(Left, Top, Right, Bottom);
    while X < Width do
    begin
      MoveTo(X, 1);
      LineTo(X, 6*(1 + byte(N mod 3 = 0) +
        byte(N mod 6 = 0) +
        byte(N mod 12 = 0)));
      if (N > 0) and (N mod 12 = 0) then
        TextOut(PenPos.X+3, 9, IntToStr(N div 12));
      N := N + 1;
      X := X + a12th;
    end;
  end;
end;
{*********************************************}
procedure TVRuler.SetVRulerAlign(Value: TAlign);
begin
  if Value in [alLeft, alRight, alNone] then
  begin
    fVRulerAlign := Value;
    Align := Value;
  end;
end;

constructor TVRuler.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  AlignVRuler := alNone;
  Color := clYellow;
  Height := 1008;
  Width := 33;
end;

procedure TVRuler.Paint;
var a6th, N, Y : word;
begin
  a6th := Screen.PixelsPerInch div 6;
  N := 0; Y := 0;
  with Canvas do
  begin
    Brush.Color := Color;
    FillRect(ClientRect);
    with ClientRect do
      Rectangle(Left, Top, Right, Bottom);
    while Y < Height do
    begin
      MoveTo(1, Y);
      LineTo(6*(2 + byte(N mod 3 = 0) +
        byte(N mod 6 = 0)),Y);
      if (N > 0) and (N mod 6 = 0) then
        TextOut(12, PenPos.Y-16, IntToStr(N div 6));
      N := N + 1;
      Y := Y + a6th;
    end;
  end;
end;

end.
