{ ========================================================================
  Unit:    RTCs
  VCL:     TRtcTimer
  Version: 0.5
  Copyright (C) 1996, Immo Wache
  ========================================================================}
{$C FIXED, PRELOAD, PERMANENT}

unit RTCs;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, MMSystem;

type
  TRtcTimer = class(TComponent)
  private
    FEnabled: Boolean;
    FOldResolution: Word;
    FResolution: Word;
    FInterval: Word;
    FTimerHandle: THandle;
    procedure UpdateTimer;
    procedure SetEnabled(Value: Boolean);
    procedure SetInterval(Value: Word);
    procedure SetResolution(Value: Word);
    function  GetOnTimer: TNotifyEvent;
    procedure SetOnTimer(Value: TNotifyEvent);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Enabled: Boolean read FEnabled write SetEnabled default False;
    property Interval: Word read FInterval write SetInterval default 1000;
    property Resolution: Word read FResolution write SetResolution default 10;
    property OnTimer: TNotifyEvent read GetOnTimer write SetOnTimer;
  end;

procedure Register;

implementation

{ TRtcTimer }

var
  FOnTimer: TNotifyEvent;
{  This function pointer is here,
   not inside TRtcTimer to get same DSeg like the owner}
  FTimers: Byte;
{  Counter to limit numbers of instance (only one instance)}

constructor TRtcTimer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEnabled := False;
  FInterval := 1000;
  FResolution :=10;
  FTimerHandle :=0;
  {test for first instance}
  Inc(FTimers);
  if FTimers >1 then
    raise EOutOfResources.Create('No more RTC ressources.')
end;

destructor TRtcTimer.Destroy;
begin
  FEnabled := False;
  UpdateTimer;
  inherited Destroy;
  {decrement number of instances}
  Dec(FTimers);
end;

procedure TimeCallBack(uTimerID, uMessage: Word; dwUser, dw1, dw2: LongInt); far;
begin
  {set DSeg to DSeg of this unit}
  asm
    push DS;
    mov DS, Word(dwUser);
  end;
  FOnTimer(nil);
  asm
    pop DS;
  end;
end;

procedure TRtcTimer.UpdateTimer;
begin
  if FTimerHandle<>0 then
  begin
    {stop old timer events}
    timeKillEvent(FTimerHandle);
    timeEndPeriod(FOldResolution);
    FTimerHandle :=0;
  end;
  {check for new timer event}
  if (FInterval <> 0) and (FResolution <>0)
    and FEnabled and Assigned(FOnTimer) then
  begin
    {start new timer events}
    timeBeginPeriod(FResolution);
    FOldResolution :=FResolution;

    FTimerHandle :=timeSetEvent(FInterval, FResolution, TimeCallBack,
      LongInt(DSeg), TIME_PERIODIC);
{             ^^^^ send DSeg of this unit to callback-function}
    if FTimerHandle =0 then
    begin
      {Create timer event failed}
      timeEndPeriod(FOldResolution);
      raise EOutOfResources.Create('Timer event was not created');
    end;
  end;
end;

procedure TRtcTimer.SetEnabled(Value: Boolean);
begin
  if Value <> FEnabled then
  begin
    FEnabled := Value;
    UpdateTimer;
  end;
end;

procedure TRtcTimer.SetInterval(Value: Word);
begin
  if Value <> FInterval then
  begin
    FInterval := Value;
    UpdateTimer;
  end;
end;

procedure TRtcTimer.SetResolution(Value: Word);
begin
  if Value <> FResolution then
  begin
    FResolution := Value;
    UpdateTimer;
  end;
end;

procedure TRtcTimer.SetOnTimer(Value: TNotifyEvent);
begin
  FOnTimer := Value;
  UpdateTimer;
end;

function TRtcTimer.GetOnTimer;
begin
  Result :=FOnTimer;
end;

procedure Register;
begin
  RegisterComponents('MyStuff', [TRtcTimer]);
end;

begin
  {Init instance counter}
  FTimers :=0;
end.
