{ Delphi Object for R&R V6.5 SQL Edition }

{ Author Chris Brooksbank (cbrooksbank@msn.com) }
{ Written : October 1995 }

unit RRSQL65;

interface

uses
  SysUtils,WinTypes,WinProcs,Messages,Classes,Graphics,Controls,Forms,
  Dialogs,rrsqlint;

type
  TrrFilterUsage = (rrfuSaved,rrfuNone,rrfuComponent,rrfuInteractive);
  TrrDest = (rrdDisplay,rrdTextFile,rrdPrinter,rrdWorksheet,rrdXBase,
             rrdInteractive,rrdCSV,rrdMSWord,rrdRTF);
  TrrExportDest = (rredDisplay,rredFile,rredPrinter);
  TrrwsBorderStyle = (rrwsNone,rrwsFixedSingle,rrwsSizable,rrwsFixedDouble);

  TRRSQL65 = class(TComponent)
  private
    { Private declarations }

     { SQL Specfic Fields Follow }
     fAskDataSource:Boolean;
     fAskTable:Boolean;
     fDataSource: String;
     fJoinTablenames: TStrings;
     fJoinAliasNames: TStrings;
     fPassword: String;
     fReplaces: TStrings;
     fUserName: String;
     fWhere:String;

     { Generic Fields Follow }
     fActive:Boolean;
     fAskPrinter:Boolean;
     fAskReport:Boolean;
     fAuthor:String;
     fAppName:String;
     fBeginPage: Longint;
     fCopies: Longint;
     fDatabasename: String;
     fDataDir    : String;
     fDisplayErrors: Boolean;
     fDisplayStatus: Boolean;
     fEndPage: LongInt;
     fErrorCode: String;
     fErrorMessage: String;
     fExportDest: TrrExportDest;
     fFields: TStrings;
     fFilter: String;
     fFilterUsage: TrrFilterUsage;
     fGroupFields: TStrings;
     fImageDir   : String;
     fLastErrorPage: Longint;
     fLibName: String;
     fMasterTableName: String;
     fMemoName: String;
     fOutputDest: TRRDest;
     fOutputFile: String;
     fPreventEscape: Boolean;
     fPrinterName: String;
     fPrinterPort: String;
     fRepName:String;
     fReportPick: Boolean;
     fSortFields: TStrings;
     fStatusEveryPage: Boolean;
     fSuppressTitle: Boolean;
     fTestPattern: Boolean;
     fUserParamsNames: TStrings;
     fUserParamsValues: TStrings;
     fVersion: String;
     fWait: Boolean;
     fWinBorderStyle: TrrwsBorderStyle;
     fWinControlBox: Boolean;
     fWinHeight: Integer;
     fWinLeft:Integer;
     fWinMaxButton: Boolean;
     fWinMinButton: Boolean;
     fWinParentHandle: Integer;
     fWinTitle: String;
     fWinTop: Integer;
     fWinWidth:Integer;


     { SQL Specific private functions follow }

     procedure LoadJoins(hReport:Integer);
     procedure setfJoinTableNames(Value:Tstrings);
     procedure setfJoinAliasNames(Value:Tstrings);
     procedure setfReplaces(Value:Tstrings);
     procedure savereplaces(hReport:Integer);
     procedure loadreplaces(hReport:Integer);
     procedure loaddatasource(hReport:Integer);
     procedure LoadFromReportH(hMyReport:Integer);

     { Generic functions follow }

     procedure setfActive(Value:Boolean);
     procedure setfAuthor(Value:String);
     procedure LoadFields(hReport:Integer);
     procedure LoadGroupFields(hReport:Integer);
     procedure LoadSortFields(hReport:Integer);
     procedure LoadUserParams(hReport:Integer);
     procedure LoadTitle(hReport:Integer);
     procedure LoadPages(hReport:Integer);
     procedure LoadTable(hReport:Integer);
     procedure LoadFilter(hReport:Integer);
     procedure LoadDests(hReport:Integer);
     procedure LoadPrinter(hReport:Integer);

     procedure setfFields(Value:Tstrings);
     procedure setfGroupFields(Value:Tstrings);
     procedure setfSortFields(Value:Tstrings);
     procedure setfUserParamsNames(Value:Tstrings);
     procedure setfUserParamsValues(Value:Tstrings);
     procedure SetLibName(NewLibName:String);
     procedure SetRepName(NewRepName: String);
     procedure SaveToReportH(hReport:Integer);

  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(Aowner:TComponent); override;
    destructor Free;
    function execute:Boolean;
    function run:Boolean;
    procedure LoadFromReport;
    function SaveToFile(MyFile:String):Boolean;
    function LoadFromFile(MyFile:String):Boolean;

  published
    { Published declarations }

    { SQL Specific Properties Follow }

    property AskDataSource:Boolean read fAskDataSource write fAskDataSource;
    property AskTable:Boolean read fAskTable write fAskTable;
    property DataSource: String read fDataSource write fDataSource;
    property JoinTableNames: TStrings read fJoinTableNames
                                      write setfJoinTableNames;
    property JoinAliasNames: TStrings read fJoinAliasNames
                                      write setfJoinAliasNames;
    property Password: String read fPassword write fPassword;
    property Replaces:Tstrings read fReplaces write SetfReplaces;
    property UserName: String read fUserName write fUserName;
    property Where: String read fWhere write fWhere;

    { Generic Properties follow }

    property Active: Boolean read fActive write SetfActive;
    property AppName: String read fAppName write fAppName;
    property AskPrinter:Boolean read fAskPrinter write fAskPrinter;
    property AskReport:Boolean read fAskReport write fAskReport;
    property Author: String read fAuthor write setfAuthor;
    property BeginPage: Longint read fBeginPage write fBeginPage;
    property Copies: Longint read fCopies write fCopies;
    property Databasename:String read fDatabasename write fDatabasename;
    property DataDirectory:String read fDataDir write fDataDir;
    property DisplayErrors: Boolean read fDisplayErrors write fDisplayErrors;
    property DisplayStatus: Boolean read fDisplayStatus write fDisplayStatus;
    property EndPage: Longint read fEndPage write fEndPage;
    property ErrorCode: String read fErrorcode write fErrorcode;
    property ErrorMessage: String read fErrorMessage write fErrorMessage;
    property ExportDest: TrrExportDest read fExportDest write fExportDest;
    property Fields: TStrings read fFields write setfFields;
    property Filter: String read fFilter write fFilter;
    property FilterUsage: TrrFilterUsage read fFilterUsage write fFilterUsage;
    property GroupFields: TStrings read fGroupFields write setfGroupFields;
    property ImageDir: String read fImageDir write fImageDir;
    property LastErrorPage:Longint read fLastErrorPage write fLastErrorPage;
    property MasterTableName: String read fMasterTableName write fMasterTableName;
    property MemoName: String read fMemoName write fMemoName;
    property OutputDest: TrrDest read fOutputDest write fOutputDest;
    property OutputFile: String read fOutputFile write fOutputFile;
    property PreventEscape: Boolean read fPreventEscape write fPreventEscape;
    property PrinterName: String read fPrinterName write fPrinterName;
    property PrinterPort: String read fPrinterPort write fPrinterPort;
    property ReportLibrary:String read fLibName write setLibName;
    property ReportName: String read fRepName write setRepName;
    property SortFields: TStrings read fSortFields write setfSortFields;
    property StatusEveryPage: Boolean read fStatusEveryPage
                                      write fStatusEveryPage;
    property SuppressTitle: Boolean read fSuppressTitle write fSuppressTitle;
    property TestPattern: Boolean read fTestPattern write fTestPattern;
    property UserParamsNames: TStrings read fUserParamsNames
                                       write setfUserParamsNames;
    property UserParamsValues: TStrings read fUserParamsValues
                                       write setfUserParamsValues;
    property Version:String read fVersion write fversion;
    property Wait: Boolean read fWait write fWait;
    property WinBorderStyle:TrrwsBorderStyle read fWinBorderStyle
             write fWinBorderStyle;
    property WinControlBox: Boolean read fWinControlBox write fWinControlBox;
    property WinHeight: Integer read fWinHeight write fWinHeight;
    property WinLeft: Integer read fWinLeft write fWinLeft;
    property WinMaxButton: Boolean read fWinMaxButton write fWinMaxButton;
    property WinMinButton: Boolean read fWinMinButton write fWinMinButton;
    property WinParentHandle: Integer read fWinParentHandle write fWinParentHandle;
    property WinTitle: String read fWinTitle write fWinTitle;
    property WinTop:Integer read fWinTop write fWinTop;
    property WinWidth:Integer read fWinWidth write fWinWidth;

end;

procedure Register;

implementation

{ ************************************************************************** }
constructor TRRSQL65.create(AOwner:Tcomponent);
{ ************************************************************************** }
begin
  inherited create(AOwner);

  initruntimeinstance;

  { SQl Specific TSTRING fields }
  fJoinTableNames:=TStringList.Create;
  fJoinAliasNames:=TStringList.Create;
  fReplaces:=TStringList.Create;

  { Generic TSTRING fields }
  fFields:=TStringList.Create;
  fGroupFields:=TStringList.Create;
  fSortFields:=TstringList.Create;
  fUserParamsNames:=TStringList.Create;
  fUserParamsValues:=TStringList.Create;
  fAppName:=Application.exename;
  fAuthor:='cbrooksbank@msn.com';
  fAskPrinter:=true;

  fWait:=true;

end;

{ ************************************************************************** }
destructor TRRSQL65.Free;
{ ************************************************************************** }
begin

  { SQL Specific TSTRING fields }
  fJoinTableNames.Free;
  fJoinAliasNames.Free;
  fReplaces.free;

  { Generic TSTRING Fields }
  fFields.free;
  fGroupFields.free;
  fSortFields.free;
  fUserParamsNames.free;
  fUserParamsValues.free;

  endruntimeinstance;

  inherited Free;
end;


{ ************************************************************************** }
procedure Register;
{ ************************************************************************** }
begin
  RegisterComponents('Data Access', [TRRSQL65]);
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadFromReport;
{ ************************************************************************** }
{ Using the fRepname and fLibname load object info from report defaults }
var
  hMyReport:Integer;
  MyApp_,MyLib_,MyRep_: Pchar;
begin
  MyApp_:=StrAlloc(256);
  MyLib_:=StrAlloc(256);
  MyRep_:=StrAlloc(256);
  try

    if ((flibname<>'') and (frepname<>'')) then
    begin
      StrPCopy(MyApp_,fAppName);
      StrPCopy(MyLib_,fLibName);
      StrPCopy(MyRep_,fRepName);

      hMyReport:=ChooseReport(MyApp_,MyLib_,MyRep_,StrBufSize(MyRep_));
      if hMyReport>0 then
      begin
        try
          LoadFromReportH(hMyReport);
        finally
          EndReport(hMyReport);
        end;
      end;

      if hMyReport<1 then MessageDlg('Cant load info on R&&R report '+ReportName,
                                     mtError,[mbAbort],0);
    end;
  finally
    StrDispose(MyApp_);
    StrDispose(MyLib_);
    StrDispose(MyRep_);
  end;
end;


{ ************************************************************************** }
procedure TRRSQL65.LoadFromReportH(hMyReport:Integer);
{ ************************************************************************** }

{ Using passed report handle load object info from report defaults }

begin

  { Clear SQL Specific TSTRING Fields }
  fJoinTableNames.Clear;
  fJoinAliasNames.Clear;
  fReplaces.Clear;

  { Clear Generic TSTRING Fields }
  fFields.Clear;
  fGroupFields.Clear;
  fSortFields.Clear;
  fUserParamsNames.Clear;
  fUserParamsValues.Clear;

  { Load SQL Specific Properties }
  LoadJoins(hMyReport);
  LoadReplaces(hMyReport);
  LoadDataSource(hMyReport);

  { Load Generic Properties }
  LoadFields(hMyReport);
  LoadGroupFields(hMyReport);
  LoadSortFields(hMyReport);
  LoadUserParams(hMyReport);
  LoadTitle(hMyReport);
  LoadPages(hMyReport);
  LoadTable(hMyReport);
  LoadFilter(hMyReport);
  LoadDests(hMyReport);
  LoadPrinter(hMyReport);

end;

{ ************************************************************************** }
procedure TRRSQL65.setlibname(NewLibName:String);
{ ************************************************************************** }
var
  Designing:Boolean;
begin
  flibname:=NewLibName;
  Designing:=(csDesigning in ComponentState);
  if ((csReading in ComponentState) or (csLoading in ComponentState)) then
    Designing:=false;

  if (Designing and (fLibName<>'') and (fRepName<>'') ) then
  begin
    if MessageDlg('Load Properties From Report ?',mtconfirmation,
                  [mbNo,mbYes],0)=mrYes then loadfromreport;
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadJoins(hReport:Integer);
{ ************************************************************************** }
var
  JoinTableName,JoinAliasName:Pchar;
begin
  JoinTableName:=StrAlloc(51);
  JoinAliasName:=StrAlloc(51);
  try
    if GetFirstJoinInfo(hReport,JoinTableName,StrBufSize(JoinTableName),
                     JoinAliasName,StrBufSize(JoinAliasName)) then
    begin
      fJoinTableNames.Add(StrPas(JoinTableName));
      fJoinAliasNames.Add(StrPas(JoinAliasName));
    end;

    while GetNextJoinInfo(hReport,JoinTableName,StrBufSize(JoinTableName),
                          JoinAliasName,StrBufSize(JoinAliasName)) do begin
      fJoinTableNames.Add(StrPas(JoinTableName));
      fJoinAliasNames.Add(StrPas(JoinAliasName));
    end;
  finally
    StrDispose(JoinTableName);
    StrDispose(JoinAliasName);
  end;
end;

{ ************************************************************************** }
function TRRSQL65.Run:Boolean;
{ ************************************************************************** }
begin
  Result:=Execute;
end;


{ ************************************************************************** }
function TRRSQL65.Execute:Boolean;
{ ************************************************************************** }
var
  { Handle of report }
  hReport: Integer;

  { Flags returned after report was run }
  ECode:Integer;
  cmdshow: Integer;
  PageCount:LongInt;
  EMsg:Pchar;
  ErrorMess: String;

  AppName_,LibName_,RepName_:PChar;
begin
  EMsg:=StrAlloc(256);
  AppName_:=StrAlloc(256);
  LibName_:=StrAlloc(256);
  RepName_:=StrAlloc(256);
  try

    {Run the report }
    Result:=false;

    { Convert Pascal type strings to C++ strings as expected by DLL }
    StrPCopy(Appname_,fAppname);
    StrPCopy(Libname_,fLibName);
    StrPCopy(RepName_,fRepName);

    { If object specifys ask for report then blank out the report name }
    { to make sure user is prompted for report name }
    if fAskReport then  begin
      fRepname:='';
      StrPCopy(RepName_,fRepName);
    end;

    hReport:=ChooseReport(Appname_,LibName_,RepName_,StrBufSize(RepName_));

    if hReport>0 then begin
      try
        { Pass all the propertys to RSREPORT.DLL }
        SaveToReportH(hReport);

        { Run the report and then clean up }
        cmdshow:=SW_SHOWNORMAL;
        fErrorCode:='';
        fErrorMessage:='';
        ResetErrorInfo;
        if ExecRunTime(hReport,fWait,cmdshow,@ECode,@PageCount,EMsg,StrBufSize(EMsg))
        then Result:=True else begin
          geterrorinfo(Emsg,StrBufSize(EMsg),@Ecode);
          fErrorMessage:=StrPas(EMsg);

          case Ecode of
            Ord('C'):fErrorCode:='Cancelled';
            Ord('D'):fErrorCode:='Diagnostic';
            Ord('I'):fErrorCode:='Iteration';
            Ord('J'):fErrorCode:='Job Control';
            Ord('L'):fErrorCode:='Library';
            Ord('S'):fErrorCode:='Syntax';
            Ord('V'):fErrorCode:='Value';
            else
              fErrorCode:=Chr(Ecode);
          end;

          MessageDlg('R&&R Error : '+StrPas(EMsg),mtError,[mbAbort],0);
        end;
      finally
        EndReport(hReport);
      end;
    end;
    fLastErrorPage:=PageCount;
    if hReport<1 then MessageDlg('Cant allocate handle for report '+fRepname,
                                 mtError,[mbAbort],0)
  finally
    StrDispose(EMsg);
    StrDispose(AppName_);
    StrDispose(LibName_);
    StrDispose(RepName_);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfJoinTableNames(Value:Tstrings);
{ ************************************************************************** }
begin
  fJoinTableNames.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfJoinAliasNames(Value:Tstrings);
{ ************************************************************************** }
begin
  fJoinAliasNames.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfReplaces(Value:Tstrings);
{ ************************************************************************** }
begin
  fReplaces.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL65.SaveReplaces(hReport:Integer);
{ ************************************************************************** }
var
  i:Integer;
  ThisReplace,ReplaceList:String;
  Replaces_:Pchar;
begin
  Replaces_:=StrAlloc(256);
  try
    ReplaceList:='';
    for i:=0 to (fReplaces.count-1) do begin
      ThisReplace:=fReplaces[i];
      if ThisReplace<>'' then ReplaceList:=ReplaceList+','+ThisReplace;
    end;

    if ReplaceList<>'' then begin
      ReplaceList:=Copy(ReplaceList,1,length(replacelist)-1);
      StrPCopy(Replaces_,ReplaceList);
      SetReplace(hReport,Replaces_);
    end;
  finally
    StrDispose(Replaces_);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadReplaces(hReport:Integer);
{ ************************************************************************** }
var
  Replace:Pchar;
begin
  Replace:=StrAlloc(31);
  try
    if GetFirstReplace(hReport,Replace,StrBufSize(Replace)) then
      fReplaces.Add(StrPas(Replace));
    while GetNextReplace(hReport,Replace,StrBufSize(Replace)) do
      fReplaces.Add(StrPas(Replace));
  finally
   StrDispose(Replace);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadDataSource(hReport:Integer);
{ ************************************************************************** }
var
  Source_:Pchar;
begin
  Source_:=StrAlloc(256);
  try
    if GetDataSource(hReport,source_,StrBufSize(source_)) then
      fDataSource:=StrPas(Source_);
  finally
    StrDispose(Source_);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadUserParams(hReport:Integer);
{ ************************************************************************** }
var
  ParamName,ParamValue:Pchar;
begin
  ParamName:=StrAlloc(31);
  ParamValue:=StrAlloc(31);
  try
    if GetFirstUserParam(hReport,ParamName,StrBufSize(ParamName),
                      paramValue,StrBufSize(ParamValue)) then begin
      fUserParamsNames.Add(StrPas(ParamName));
      fUserParamsValues.Add(StrPas(ParamValue));
    end;
    while GetNextUserParam(hReport,ParamName,StrBufSize(ParamName),
                           ParamValue,StrBufSize(ParamValue)) do begin
      fUserParamsNames.Add(StrPas(ParamName));
      fUSerParamsValues.Add(StrPas(ParamValue));
    end;
  finally
    StrDispose(Paramname);
    StrDispose(Paramvalue);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadFields(hReport:Integer);
{ ************************************************************************** }
var
  FieldName:Pchar;
begin
  FieldName:=StrAlloc(31);
  try
    if GetFirstFieldName(hReport,FieldName,StrBufSize(FieldName)) then
      fFields.Add(StrPas(FieldName));
    while GetNextFieldName(hReport,FieldName,StrBufSize(FieldName)) do
      fFields.Add(StrPas(FieldName));
  finally
    StrDispose(FieldName);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadGroupFields(hReport:Integer);
{ ************************************************************************** }
var
  GroupField:Pchar;
begin
  GroupField:=StrAlloc(31);
  try
    if GetFirstGroupField(hReport,GroupField,StrBufSize(GroupField)) then
      fGroupFields.Add(StrPas(GroupField));
    while GetNextGroupField(hReport,GroupField,StrBufSize(GroupField)) do
      fGroupFields.Add(StrPas(GroupField));
  finally
    StrDispose(GroupField);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadSortFields(hReport:Integer);
{ ************************************************************************** }
var
  SortField:Pchar;
begin
  SortField:=StrAlloc(31);
  try
    if GetFirstSortField(hReport,SortField,StrBufSize(SortField)) then
      fSortFields.Add(StrPas(SortField));
    while GetNextSortField(hReport,SortField,StrBufSize(SortField)) do
      fSortFields.Add(StrPas(SortField));
  finally
    StrDispose(SortField);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.SetRepName(NewRepName: String);
{ ************************************************************************** }
var
  Designing:Boolean;
begin
  fRepName:=NewRepName;
  Designing:=(csDesigning in ComponentState);
  if ((csReading in ComponentState) or (csLoading in ComponentState)) then
    Designing:=false;

  if (Designing and (fLibName<>'') and (fRepName<>'') ) then
  begin
    if MessageDlg('Load Properties From Report ?',mtconfirmation,
                  [mbYes,mbNo],0)=mrYes then loadfromreport;
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfGroupFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fGroupFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfSortFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fSortFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfUserParamsNames(Value:Tstrings);
{ ************************************************************************** }
begin
  fUserParamsNames.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfUserParamsValues(Value:Tstrings);
{ ************************************************************************** }
begin
  fUserParamsValues.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfActive(Value:Boolean);
{ ************************************************************************** }
begin
  if (csDesigning in ComponentState) and (Value=True) then execute;
end;

{ ************************************************************************** }
procedure TRRSQL65.SetfAuthor(Value:String);
{ ************************************************************************** }
begin
  if Value<>'cbrooksbank@msn.com' then
  messagedlg('Please send bugs/comments/enhancements to cbrooksbank@msn.com',mtInformation,
              [mbOk],0);
  fAuthor:='cbrooksbank@msn.com';
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadTitle(hReport:Integer);
{ ************************************************************************** }
var
  title_:Pchar;
begin
  title_:=StrAlloc(256);
  try
    if GetWinTitle(hReport,title_,StrBufSize(title_)) then
      fWinTitle:=StrPas(title_);
  finally
    StrDispose(title_);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadPages(hReport:Integer);
{ ************************************************************************** }
begin
  GetBeginPage(hReport,@fBeginPage);
  GetEndPage(hReport,@fEndPage);
  GetCopies(hReport,@fCopies);
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadTable(hReport:Integer);
{ ************************************************************************** }
var
  table_:Pchar;
begin
  Table_:=StrAlloc(256);
  try
    if GetMasterTableName(hReport,table_,StrBufSize(table_)) then
      fMasterTableName:=StrPas(table_);
  finally
    StrDispose(Table_);
  end;
end;


{ ************************************************************************** }
procedure TRRSQL65.LoadFilter(hReport:Integer);
{ ************************************************************************** }
var
  filter_:Pchar;
begin
  filter_:=StrAlloc(256);
  try
    if getFilter(hReport,filter_,StrBufSize(filter_)) then
      fFilter:=StrPas(filter_);
  finally
    StrDispose(filter_);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.LoadDests(hReport:Integer);
{ ************************************************************************** }
var
  Dest_:Pchar;
  DestStr:String;
begin
  Dest_:=StrAlloc(256);
  try

    { Load fExportDest}
    if getExportDest(hReport,Dest_) then
    begin
      DestStr:=StrPas(Dest_);
      if DestStr[1]='D' then
        fExportDest:=rredDisplay;
      if DestStr[1]='F' then
        fExportDest:=rredFile;
      if DestStr[1]='P' then
        fExportDest:=rredPrinter;
    end;

    { Load fOutPutDest }
    if getOutputDest(hReport,Dest_) then
    begin
      DestStr:=StrPas(Dest_);
      if DestStr[1]='D' then
        fOutPutDest:=rrdDisplay;
      if DestStr[1]='A' then
        fOutPutDest:=rrdTextFile;
      if DestStr[1]='T' then
        fOutPutDest:=rrdTextFile;
      if DestStr[1]='P' then
        fOutPutDest:=rrdPrinter;
      if DestStr[1]='W' then
        fOutPutDest:=rrdWorksheet;
      if DestStr[1]='X' then
        fOutPutDest:=rrdXBase;
      if DestStr[1]='?' then
        fOutPutDest:=rrdInteractive;
    end;

    { Load fOutputFile }
    if getOutputDest(hReport,Dest_) then
      fOutPutFile:=StrPas(Dest_);
  finally
    StrDispose(Dest_);
  end;

end;

{ ************************************************************************** }
procedure TRRSQL65.LoadPrinter(hReport:Integer);
{ ************************************************************************** }
var
  Printer_,Port_:Pchar;
begin
  Printer_:=StrAlloc(256);
  Port_:=StrAlloc(256);
  try
    if getPrinter(hReport,Printer_,StrBufSize(Printer_)) then
      fPrinterName:=StrPas(Printer_);
    if getPrinterPort(hReport,Port_,StrBufSize(Port_)) then
      fPrinterPort:=StrPas(Port_);
  finally
    StrDispose(Printer_);
    StrDispose(Port_);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL65.SaveToReportH(hReport:Integer);
{ ************************************************************************** }

{ Given a report handle save object properties to the report }
{ Pass all the propertys to RSREPORT.DLL }

var
  { Temp vars to hold Pchar versions of String properties }
  DataSource_,PrinterName_:PChar;
  PrinterPort_,PassWord_,UserName_:PChar;
  filter_: Pchar;
  MasterTableName_,MemoName_,OutputFile_,WinTitle_: Pchar;
  Tablename_,Databasename_,Where_:Pchar;

  CharString:String;
  SiField,SiField2:Pchar;
  datadir_,imagedir_:Pchar;

  i,maxi:Integer;

begin
  DataSource_:=StrAlloc(256);
  PrinterName_:=StrAlloc(256);
  PrinterPort_:=StrAlloc(31);
  PassWord_:=StrAlloc(31);
  UserName_:=StrAlloc(31);
  filter_:=StrAlloc(256);
  MasterTableName_:=StrAlloc(256);
  MemoName_:=StrAlloc(256);
  OutputFile_:=StrAlloc(256);
  WinTitle_:=StrAlloc(256);
  TableName_:=StrAlloc(256);
  DatabaseName_:=StrAlloc(256);
  Where_:=StrAlloc(256);
  SiField:=StrAlloc(256);
  SiField2:=StrAlloc(256);
  datadir_:=StrAlloc(256);
  imagedir_:=StrAlloc(256);
  try

    if AskPrinter then fPrinterName:='?';

    { Convert Pascal type strings to C++ strings as expected by DLL }
    StrPCopy(DataSource_,fDataSource);
    StrPCopy(Filter_,fFilter);
    StrPCopy(MasterTableName_,fMasterTableName);
    StrPCopy(MemoName_,fMemoName);
    StrPCopy(OutputFile_,fOutputFile);
    StrPCopy(Password_,fPassword);
    StrPCopy(Printername_,fPrinterName);
    StrPCopy(PrinterPort_,fPrinterPort);
    StrPCopy(UserName_,fUserName);
    StrPCopy(WinTitle_,fWinTitle);
    StrPCopy(Databasename_,fDatabasename);
    StrPCopy(Where_,fwhere);
    StrPCopy(ImageDir_,fimagedir);
    StrPCopy(DataDir_,fdatadir);

    SetBeginPage(hReport,fBeginPage);
    SetCopies(hReport,fCopies);
    SetDisplayErrors(hReport,fDisplayErrors);
    SetDisplayStatus(hReport,FDisplayStatus);
    SetEndPage(hReport,fEndPage);

    CharString:=Copy('DFP',Ord(fExportDest)+1,1);
    SetExportDest(hReport,CharString[1]);

    SetFilter(hReport,Filter_);

    CharString:=Copy('SEO?',Ord(fFilterUsage)+1,1);
    SetFilterUsage(hReport,CharString[1]);

    if fMasterTableName<>''then
      SetMasterTableName(hReport,MasterTableName_);

    if fMemoName<>'' then
      SetMemoName(hReport,MemoName_);

    CharString:=Copy('DAPWX?CMR',Ord(fOutputDest)+1,1);
    SetOutputDest(hReport,CharString[1]);

    SetOutPutFile(hReport,OutputFile_);
    SetPassword(hReport,Password_);
    SetPreventEscape(hReport,fPreventEscape);
    SetStatusEveryPage(hReport,fStatusEveryPage);
    SetTestPattern(hReport,fTestPattern);
    SetUserName(hReport,Username_);

    CharString:=Copy('0123',Ord(fWinBorderStyle)+1,1);
    SetWinBorderStyle(hReport,Ord(CharString[1])-Ord('0'));

    SetWinControlBox(hReport,fWinControlBox);
    SetWinHeight(hReport,fWinHeight);
    SetWinLeft(hReport,fWinLeft);
    SetWinMaxButton(hReport,fWinMaxButton);
    SetWinMinButton(hReport,fWinMinButton);
    SetWinParentHandle(hReport,fWinParentHandle);
    SetWinTitle(hReport,WinTitle_);
    SetWinTop(hReport,fWinTop);
    SetWinWidth(hReport,fWinWidth);

    { Set sort fields }
    for i:=0 to (fSortFields.Count-1) do begin
      if ((fSortFields[i]<>'') and
         (Pos('RECNO',UpperCase(fSortFields[i]))=0)) then begin
        StrPCopy(SiField,fSortFields[i]);
        SetSortField(hReport,SiField,i+1);
      end;
    end;

    { Set Group Fields }
    for i:=0 to (fGroupFields.Count-1) do begin
      if fGroupFields[i]<>'' then begin
        StrPCopy(SiField,fGroupFields[i]);
        SetGroupField(hReport,SiField,i+1);
      end;
    end;

    { Set join information }
    maxi:=fJoinTableNames.count;
    if fJoinAliasNames.Count<maxi then maxi:=fJoinAliasNames.Count;
    dec(maxi);
    for i:=0 to maxi do begin
      if fJoinTableNames[i]<>'' then begin
        StrPCopy(SiField,fJoinTableNames[i]);
        StrPCopy(SiField2,fJoinAliasNames[i]);
        SetJoinInfo(hReport,SiField,Sifield2,i+1);
      end;
    end;

    { Set user paramaters }
    for i:=0 to (fUserParamsNames.Count-1) do begin
      if fUserParamsNames[i]<>'' then begin
        StrPCopy(SiField,fUserParamsNames[i]);
        StrPCopy(SiField2,fUserParamsValues[i]);
        SetUserParam(hreport,SiField,SiField2);
      end;
    end;

    if ((fPrinterName<>'') or AskPrinter) then
    begin
      SetPrinter(hReport,PrinterName_);
      SetPrinterPort(hReport,PrinterPort_);
    end;

    if AskDataSource then
      ChooseDataSource(hReport,Datasource_,StrBufSize(Datasource_));


    if AskTable then ChooseTable(hReport,Tablename_,StrBufSize(TableName_),
                                 DataSource_,StrBufSize(DataSource_),
                                 Databasename_,StrBufSize(Databasename_));

    if fDataSource<>'' then SetDataSource(hReport,DataSource_);

    if fwhere<>'' then SetWhere(hReport,where_);

    if fimagedir<>'' then SetImageDir(hreport,imagedir_);
    if fdatadir<>'' then SetDataDir(hreport,datadir_);

    SaveReplaces(hReport);
  finally
    StrDispose(DataSource_);
    StrDispose(PrinterName_);
    StrDispose(PrinterPort_);
    StrDispose(PassWord_);
    StrDispose(UserName_);
    StrDispose(filter_);
    StrDispose(MasterTableName_);
    StrDispose(MemoName_);
    StrDispose(Outputfile_);
    StrDispose(WinTitle_);
    StrDispose(TableName_);
    StrDispose(DatabaseName_);
    StrDispose(Where_);
    StrDispose(SiField);
    StrDispose(SiField2);
    StrDispose(datadir_);
    StrDispose(imagedir_);
 end;

end;


{ ************************************************************************** }
function TRRSQL65.SaveToFile(MyFile:String):Boolean;
{ ************************************************************************** }
var
  hReport:Integer;
  MyFile_,MyApp_,MyLib_,MyRep_:PChar;
begin
  MyFile_:=StrAlloc(256);
  MyApp_:=StrAlloc(256);
  MyLib_:=StrAlloc(256);
  MyRep_:=StrAlloc(256);
  try

    Result:=false;
    StrPCopy(MyApp_,fAppName);
    StrPCopy(MyLib_,fLibName);
    StrPCopy(MyRep_,fRepName);

    hReport:=ChooseReport(MyApp_,MyLib_,MyRep_,StrBufSize(MyRep_));
    try
      if hReport>0 then
      begin
        StrPCopy(MyFile_,MyFile);
        savetoreportH(hReport);
        if writeRunTimeRecord(hReport,MyFile_) then result:=true;
      end;
    finally
      EndReport(hReport);
    end;
  finally
    StrDispose(MyFile_);
    StrDispose(MyApp_);
    StrDispose(MyLib_);
    StrDispose(MyRep_);
  end;
end;

{ ************************************************************************** }
function TRRSQL65.LoadFromFile(MyFile:String):Boolean;
{ ************************************************************************** }
var
  hReport:Integer;
  MyFile_,MyApp_,MyLib_,MyRep_:PChar;
begin
  MyFile_:=StrAlloc(256);
  MyApp_:=StrAlloc(256);
  MyLib_:=StrAlloc(256);
  MyRep_:=StrAlloc(256);
  try

    Result:=false;
    StrPCopy(MyApp_,fAppName);
    StrPCopy(MyLib_,fLibName);
    StrPCopy(MyRep_,fRepName);

    StrPCopy(MyFile_,MyFile);
    hReport:=getRunTimeRecord(MyApp_,MyFile_);
    if hReport>0 then
    begin
      try
        { Load report information into this object }
        Result:=true;
        loadfromreporth(hReport);
      finally
        EndReport(hReport);
      end;
    end;
  finally
    StrDispose(MyFile_);
    StrDispose(MyApp_);
    StrDispose(MyLib_);
    StrDispose(MyRep_);
  end;
end;


end.
