unit Rpe_main;

interface

uses DsgnIntf, Forms, WinTypes, WinProcs, Graphics;

type
  TRafesPictureEditor=class(TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes:TPropertyAttributes; override;
  end;

procedure Register;

implementation

uses RPE_Edit;

procedure TRafesPictureEditor.Edit;
var
  Editor : TRPE_EditForm;
begin
  Editor:=TRPE_EditForm.Create(Application);
  try
    Editor.iImage.Picture.Bitmap.Assign(TBitmap(GetOrdValue));
    if Editor.ShowModal=idOK then
      SetOrdValue(longint(Editor.iImage.Picture.Bitmap));
  finally
    Editor.Free;
  end;
end;

function TRafesPictureEditor.GetAttributes:TPropertyAttributes;
begin
  GetAttributes:=[paMultiSelect,paDialog,paReadOnly];
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TBitmap),nil,'',TRafesPictureEditor);
end;

end.
