unit RPE_EDIT;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls,
  FileCtrl, StdCtrls, ExtCtrls, Buttons, Spin, Dialogs;

type
  TRPE_EditForm = class(TForm)
    dlDirs: TDirectoryListBox;
    dcDrives: TDriveComboBox;
    eFileEdit: TEdit;
    UpDownGroup: TGroupBox;
    sTest1: TSpeedButton;
    bTest1: TBitBtn;
    DisabledGrp: TGroupBox;
    sTest2: TSpeedButton;
    bTest2: TBitBtn;
    Panel1: TPanel;
    iImage: TImage;
    flFiles: TFileListBox;
    lName: TLabel;
    seNoOfGlyphs: TSpinEdit;
    Label2: TLabel;
    bView: TBitBtn;
    Bevel1: TBevel;
    cbViewGlyph: TCheckBox;
    cbDirs: TComboBox;
    Bevel2: TBevel;
    bStretch: TBitBtn;
    bClear: TBitBtn;
    bSave: TBitBtn;
    bCancel: TBitBtn;
    bOK: TBitBtn;
    bAbout: TBitBtn;
    bAdd: TSpeedButton;
    bDelete: TSpeedButton;
    sdSave: TSaveDialog;
    procedure flFilesClick(Sender: TObject);
    procedure seNoOfGlyphsChange(Sender: TObject);
    procedure bViewClick(Sender: TObject);
    procedure cbViewGlyphClick(Sender: TObject);
    procedure StretchCheckClick(Sender: TObject);
    procedure eFileEditKeyPress(Sender: TObject; var Key: Char);
    procedure bClearClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bAddClick(Sender: TObject);
    procedure bDeleteClick(Sender: TObject);
    procedure cbDirsChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure bSaveClick(Sender: TObject);
    procedure bAboutClick(Sender: TObject);
    private
      Stretched : Boolean;
      Dirs : TStringList;
      procedure AddDirectory(s : string);
      procedure ViewAsGlyph;
  end;

var
  RPE_EditForm: TRPE_EditForm;

implementation

uses RPE_Add, RPE_View,
     SysUtils, INIfiles;

{$R *.DFM}

procedure TRPE_EditForm.flFilesClick(Sender: TObject);
begin
  iImage.Picture.LoadFromFile(flFiles.Filename);
  lName.Caption :=  ExtractFilename(flFiles.Filename) +
                    Format(' (%d x %d)', [iImage.Picture.Width, iImage.Picture.Height]);
  ViewAsGlyph;
end;

procedure TRPE_EditForm.cbViewGlyphClick(Sender: TObject);
begin
  ViewAsGlyph;
end;

procedure TRPE_EditForm.ViewAsGlyph;
begin
  if cbViewGlyph.Checked then
  begin
    sTest1.Glyph := iImage.Picture.Bitmap;
    sTest2.Glyph := iImage.Picture.Bitmap;
    seNoOfGlyphs.Value := sTest1.NumGlyphs;
    bTest1.Glyph := iImage.Picture.Bitmap;
    bTest2.Glyph := iImage.Picture.Bitmap;
  end;
end;

procedure TRPE_EditForm.bViewClick(Sender: TObject);
begin
  RPE_ViewForm:=TRPE_ViewForm.Create (Application);
  try
    RPE_ViewForm.Image.Picture := iImage.Picture;
    RPE_ViewForm.HorzScrollBar.Range := iImage.Picture.Width;
    RPE_ViewForm.VertScrollBar.Range := iImage.Picture.Height;
    RPE_ViewForm.Caption := lName.Caption;
    RPE_ViewForm.ShowModal;
  finally
    RPE_ViewForm.Free;
  end;
end;

procedure TRPE_EditForm.seNoOfGlyphsChange(Sender: TObject);
begin
  sTest1.NumGlyphs := seNoOfGlyphs.Value;
  sTest2.NumGlyphs := seNoOfGlyphs.Value;
end;

procedure TRPE_EditForm.StretchCheckClick(Sender: TObject);
begin
  Stretched:=not Stretched;
  iImage.Stretch := Stretched;
end;

procedure TRPE_EditForm.eFileEditKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
  begin
    flFiles.ApplyFilePath(eFileEdit.Text);
    Key := #0;
  end;
end;

procedure TRPE_EditForm.bClearClick(Sender: TObject);
var
  Temp : TBitmap;
begin
  if iImage.Picture.Bitmap<>nil then
  begin
    Temp:=TBitmap.Create;
    iImage.Picture.Bitmap.Assign(Temp);
    Temp.Free;
    bClear.enabled:=FALSE;
  end;
end;

procedure TRPE_EditForm.AddDirectory(s : string);
begin
  cbDirs.items.add(copy(s,1,pos('=',s)-1));
end;

procedure TRPE_EditForm.FormCreate(Sender: TObject);
var
  DelphiIni : TIniFile;
begin
  Dirs:=TStringList.Create;
  DelphiIni := TIniFile.Create('delphi.ini');
  DelphiIni.ReadSectionValues('RPE', Dirs);
  DelphiIni.Free;
end;

procedure TRPE_EditForm.bAddClick(Sender: TObject);
begin
  RPE_AddForm:=TRPE_AddForm.Create(Application);
  try
    RPE_AddForm.Dir.Text:=dlDirs.Directory;
    RPE_AddForm.DirName.Clear;
    if RPE_AddForm.ShowModal=mrOK then
      begin
        Dirs.Values[RPE_AddForm.DirName.Text]:=RPE_AddForm.Dir.Text;
        AddDirectory(Dirs.Strings[Dirs.Count-1]);
        cbDirs.ItemIndex:=Dirs.Count-1;
      end;
  finally
    RPE_AddForm.Free;
  end;
end;

procedure TRPE_EditForm.bDeleteClick(Sender: TObject);
begin
  if MessageDlg ('Delete this directory from list?', mtConfirmation, [mbYes, mbNo], 0)=mrYes then
    cbDirs.Items.Delete(cbDirs.ItemIndex);
end;

procedure TRPE_EditForm.cbDirsChange(Sender: TObject);
begin
  if cbDirs.Text<>'' then
    dlDirs.Directory:=Dirs.Values[cbDirs.Text];
end;

procedure TRPE_EditForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  DelphiIni : TIniFile;
  i         : integer;
begin
  DelphiIni := TIniFile.Create('delphi.ini');
  DelphiIni.EraseSection('RPE');
  for i:=0 to Dirs.count-1 do
    DelphiIni.WriteString('RPE',
                          cbDirs.Items.Strings[i],
                          Dirs.Values[cbDirs.Items.Strings[i]]);
  DelphiIni.Free;
end;

procedure TRPE_EditForm.FormDestroy(Sender: TObject);
begin
 Dirs.Free;
end;

procedure TRPE_EditForm.FormShow(Sender: TObject);
var
  i : integer;
begin
  cbDirs.Clear;
  for i:=0 to Dirs.Count-1 do
    AddDirectory(Dirs.Strings[i]);
  if Dirs.Count<>0 then
    begin
      cbDirs.ItemIndex:=0;
      if cbDirs.Text<>'' then
        dlDirs.Directory:=Dirs.Values[cbDirs.Text];
    end;
  if iImage.Picture.Bitmap<>nil then
    if iImage.Picture.Bitmap.Empty then
      bClear.Enabled:=FALSE
    else
      bClear.Enabled:=TRUE;
end;

procedure TRPE_EditForm.bSaveClick(Sender: TObject);
begin
  if sdSave.Execute then
    iImage.Picture.SaveToFile (sdSave.FileName);
end;

procedure TRPE_EditForm.bAboutClick(Sender: TObject);
begin
  MessageDlg ('Rafe''s Picture Editor v1.0'+#13+#13+
              '1995 Rafe Aldridge and Daniel Parnell'+#13+#13+
              'E-Mail: rafe@rcai.demon.co.uk'+#13+
              'WWW: http:/www.demon.co.uk/temati/rafe', mtInformation, [mbOK], 0);
end;

end.
