unit About;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, DsgnIntf;

const
	{AboutBox information}
	CREDITNAME = 'TRoundLed Component';
	CREDITVERSION = 'v1.1';
	CREDITCOPYRIGHT = 'Copyright  1995 - Martyn Dowsett';
	CREDITNOTES = 'CompuServe ID 100676,1560';


type
	TAboutBoxObject = class(TObject)
	end;


	TAboutBoxEditor = class(TPropertyEditor)
		function GetAttributes: TPropertyAttributes; override;
		function GetValue: string; override;
		procedure Edit; override;

	end;

  TAboutBox = class(TForm)
	 lblName: TLabel;
	 lblversion: TLabel;
	 lblCopyright: TLabel;
	 lblNotes: TLabel;
	 BitBtn1: TBitBtn;
	 procedure FormCreate(Sender: TObject);
  private
	 { Private declarations }
  public
	 { Public declarations }

  end;

implementation

{$R *.DFM}
{---------------------------------------------------------------}
function TAboutBoxEditor.GetAttributes;
begin
	Result := inherited GetAttributes +
				[paDialog]+[paReadOnly];
end;
{---------------------------------------------------------------}
function TAboutBoxEditor.GetValue: string;
begin
	{This is the caption displayed in the Object Inspector}
	Result := 'Click on...for About box';
end;
{----------------------------------------------------------------}
Procedure TAboutBoxEditor.Edit;
var
	AboutBox: TAboutBox;
Begin
	try
		AboutBox := TAboutBox.Create(Application);
		MessageBeep(0);
		AboutBox.ShowModal;
	finally
		AboutBox.Free;
	end;
End;
{---------------------------------------------------------------}
procedure TAboutBox.FormCreate(Sender: TObject);
begin
	{Place caption in labels}
	lblName.Caption := CREDITNAME;
	lblVersion.Caption := CREDITVERSION;
	lblCopyright.Caption := CREDITCOPYRIGHT;
	lblNotes.Caption := CREDITNOTES;

	{Center labels on form}
	lblName.Left := (Self.Width-lblName.Width) div 2;
	lblVersion.Left := (Self.Width-lblVersion.Width) div 2;
	lblCopyright.Left := (Self.Width-lblCopyright.Width) div 2;
	lblNotes.Left := (Self.Width-lblNotes.Width) div 2;
end;
{----------------------------------------------------------------}
end.
