{*******************************************************
                ThgResourceGauge [resgauge unit]

This unit contains the code for the ThgResourceGauge component.
ThgResourceGauge is a TGauge decendant which shows available
system resources. It implements a TTimer and checks system
resources periodically based on the selected interval.



I hope you find this code useful. If you make improvements
please e-mail me a copy. Enjoy.

                Paul Warren
       HomeGrown Software Development
     (c) 1995 Langley British Columbia.
              (604) 530-9097
       e-mail:  hg_soft@uniserve.com
  Home page: http://haven.uniserve.com/~hg_soft

********************************************************}
unit Resgauge;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Gauges;

type
  TMonitorType = (mtGDI, mtSystem, mtUser);

  ThgResourceGauge = class(TGauge)
  private
    { Private declarations }
    FMonitor: TMonitorType;
    FInterval: word;
    Timer: TTimer;
    procedure SetInterval(New: word);
    procedure GetResource(Sender: TObject);
  protected
    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); Override;
    destructor Destroy; override;
    { Public declarations }
  published
    { Published declarations }
    property Interval: word read FInterval write SetInterval default 1000;
    property Monitor: TMonitorType read FMonitor write FMonitor default mtGDI;
  end;

procedure Register;

implementation

{Set default values}
constructor ThgResourceGauge.Create (AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 100;
  Height := 25;
  BackColor := clBtnFace;
  ForeColor := clBlue;
  Font.Color := clYellow;
  Timer := TTimer.Create(Self);
  Timer.Interval := 1000;
  Timer.OnTimer := GetResource;
end;

destructor ThgResourceGauge.Destroy;
begin
  Timer.Free;
  inherited Destroy;
end;

procedure ThgResourceGauge.SetInterval(New: word);
begin
  if FInterval <> New then
  begin
    FInterval := New;
    Timer.Interval := FInterval;
  end;
end;

procedure ThgResourceGauge.GetResource;
begin
  case Monitor of
    mtGDI: Progress := GetFreeSystemResources(GFSR_GDIResources);
    mtSystem: Progress := GetFreeSystemResources(GFSR_SystemResources);
    mtUser: Progress := GetFreeSystemResources(GFSR_UserResources);
  end;
end;

procedure Register;
begin
  RegisterComponents('Misc', [ThgResourceGauge]);
end;

end.
