// ****************************************************************************
// Author  : Andr Scholten
// Date    : 24/08/1999
// Version : 1.0
// Program : Repeating buttons for Delphi 1, 2, 3, 4, 5
// ****************************************************************************
//
// This is a freeware component !
//
// You can use this component to place a repeating Button on your Form.
// for example: as a database navigator
//
// Available are the normal button, the BitButton and the SpeedButton.
//
// The objectproperties are the same as the original Buttons except for 2 more values:
//  - InitRepeatPause -> Wait xx ms before repeating.
//  - repeatPause     -> wait xx ms between repeating.
//
// How to use in delphi:
// Place this unit in your "LIB" directory.
// Go to "Component" -> "Install Component", browse for this unit,
// rebuild package and save it.
//
// If you have any suggestions or modifications,
// please send me an email: surfsup@dds.nl
//

unit RepeatBtn;

interface

uses
  Classes, Controls, Buttons, ExtCtrls, StdCtrls;

Const
   InitRepeatP = 250; // if you don't get the repeatingeffect,
   RepeatP     = 75;  // try a lower value or buy a faster PC.

type
  TRepeatBitBtn = class(TBitBtn)
  private
    { Private declarations }
    fInitRepeatPause : Cardinal;
    fRepeatPause     : Cardinal;
    FRepeatTimer     : TTimer;
    procedure TimerExpired(Sender: TObject);
  protected
    { Protected declarations }
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property RepeatPause     : Cardinal read fRepeatPause write fRepeatPause;
    property InitRepeatPause : Cardinal read fInitRepeatPause write fInitRepeatPause;
  end;

  TRepeatSpeedBtn = class(TSpeedButton)
  private
    { Private declarations }
    fInitRepeatPause : Cardinal;
    fRepeatPause     : Cardinal;
    FRepeatTimer     : TTimer;
    procedure TimerExpired(Sender: TObject);
  protected
    { Protected declarations }
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property RepeatPause     : Cardinal read fRepeatPause write fRepeatPause;
    property InitRepeatPause : Cardinal read fInitRepeatPause write fInitRepeatPause;
  end;

  TRepeatButton = class(TButton)
  private
    { Private declarations }
    fInitRepeatPause : Cardinal;
    fRepeatPause     : Cardinal;
    FRepeatTimer     : TTimer;
    procedure TimerExpired(Sender: TObject);
  protected
    { Protected declarations }
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property RepeatPause     : Cardinal read fRepeatPause write fRepeatPause;
    property InitRepeatPause : Cardinal read fInitRepeatPause write fInitRepeatPause;
  end;

procedure Register;

implementation

// ************************* Button ******************************************

constructor TRepeatButton.Create(AOwner : TComponent);
Begin
   inherited Create(AOwner);
   fRepeatPause     := RepeatP;
   fInitRepeatPause := InitRepeatP;
end;

procedure TRepeatButton.MouseDown(Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseDown(Button, Shift, X, Y);
  if FRepeatTimer = nil then FRepeatTimer := TTimer.Create(Self);
  FRepeatTimer.OnTimer  := TimerExpired;
  FRepeatTimer.Interval := fInitRepeatPause;
  FRepeatTimer.Enabled  := True;
end;

procedure TRepeatButton.MouseUp(Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
   inherited MouseUp(Button, Shift, X, Y);
   if FRepeatTimer <> nil then FRepeatTimer.Enabled := False;
end;

procedure TRepeatButton.TimerExpired(Sender: TObject);
begin
  FRepeatTimer.Interval := fRepeatPause;
  Click;
end;

destructor TRepeatButton.Destroy;
begin
  if FRepeatTimer <> nil then FRepeatTimer.Free;
  inherited Destroy;
end;

// ************************* BitBtn ******************************************

constructor TRepeatBitBtn.Create(AOwner : TComponent);
Begin
   inherited Create(AOwner);
   fRepeatPause     := RepeatP;
   fInitRepeatPause := InitRepeatP;
end;

procedure TRepeatBitBtn.MouseDown(Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseDown(Button, Shift, X, Y);
  if FRepeatTimer = nil then FRepeatTimer := TTimer.Create(Self);
  FRepeatTimer.OnTimer  := TimerExpired;
  FRepeatTimer.Interval := fInitRepeatPause;
  FRepeatTimer.Enabled  := True;
end;

procedure TRepeatBitBtn.MouseUp(Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
   inherited MouseUp(Button, Shift, X, Y);
   if FRepeatTimer <> nil then FRepeatTimer.Enabled := False;
end;

procedure TRepeatBitBtn.TimerExpired(Sender: TObject);
begin
  FRepeatTimer.Interval := fRepeatPause;
  Click;
end;

destructor TRepeatBitBtn.Destroy;
begin
  if FRepeatTimer <> nil then FRepeatTimer.Free;
  inherited Destroy;
end;

// ************************* SpeedBtn *****************************************

constructor TRepeatSpeedBtn.Create(AOwner : TComponent);
Begin
   inherited Create(AOwner);
   fRepeatPause     := RepeatP;
   fInitRepeatPause := InitRepeatP;
end;

procedure TRepeatSpeedBtn.MouseDown(Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseDown(Button, Shift, X, Y);
  if FRepeatTimer = nil then FRepeatTimer := TTimer.Create(Self);
  FRepeatTimer.OnTimer  := TimerExpired;
  FRepeatTimer.Interval := fInitRepeatPause;
  FRepeatTimer.Enabled  := True;
end;

procedure TRepeatSpeedBtn.MouseUp(Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
   inherited MouseUp(Button, Shift, X, Y);
   if FRepeatTimer <> nil then FRepeatTimer.Enabled := False;
end;

procedure TRepeatSpeedBtn.TimerExpired(Sender: TObject);
begin
  FRepeatTimer.Interval := fRepeatPause;
  Click;
end;

destructor TRepeatSpeedBtn.Destroy;
begin
  if FRepeatTimer <> nil then FRepeatTimer.Free;
  inherited Destroy;
end;

// ************************ Register the components ******************************

procedure Register;
begin
   RegisterComponents('Repeating buttons', [TRepeatButton, TRepeatBitBtn, TRepeatSpeedBtn]);
end;

end.
