unit Repair1;

{Tsatsoulas Apostolos (1997)
 Greece
 This is a small app based on the tutility.dll by borland and on the unit
 trepair by dave for delphi 1. Use at your own risk but please let me know of
 any problems that you may encounter. The source is freeware}


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,tutility,db,dbitypes, StdCtrls, Buttons, ExtCtrls,
  FileCtrl;

type
  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
var tbname:string;
  iFldCount,iIdxCount,isecrecCount,   {local variables used to stuff crDesc record}
  iValChkCount,iRintCount,
  iOptParams, iOptDataLen:word;
  Rslt:DBIResult;                     {0 if Tutility function executed properly}
  needtoFree:Boolean;                 {flag used in cleanup of memory}
  htuSession:THandle;                 {DB session handle used by Tutility}
  ioptions:Integer;
  piErrorLevel:Word;                  {TUVerifyTable results}
  CrDesc:CRTblDesc;                   {table description record for rebuild}
  CrErrorTable,RepErrorTable,VErrorTable,KeyErrorTable,BUTable,
  szTableName:Array[0..80] of Char;   {zero length strings required by Tutility}
  Table2Check,BUDir:String;
  i:integer;
  Label QuitUnit;                     {exit code label}

begin

   for i:=0 to filelistbox1.items.count-1
   do begin
   if filelistbox1.selected[i]=false then continue;
   tbname:=filelistbox1.items[i];
   edit1.text:='Opening Table:'+tbname;
   table2check:=copy(tbname,1,length(tbname)-3);
   budir:='c:';

   needtoFree:=False;                             {initialize the flag}
   Fillchar(crDesc,sizeof(crDesc),0);             {initialize the record used for rebuiliding}

   {set verify error table name}
   StrPCopy(VErrorTable,BuDir+'\TRVerr');

   {set repair table names}
   StrPCopy(BUTable,BUDir+'\TRrepair');           {backup table name}
   StrPCopy(KeyErrorTable,BUDir+'\TRkeyvio');     {keyviolation table name}
   StrPCopy(RepErrorTable,BUDir+'\TRprob');       {problem table name}

   StrPCopy(CrErrorTable,BUDir+'\TRCprobs');      {problem table name for crdesc function}

   {set name of table to verify and repair if necessary}
   StrPCopy(szTableName,Table2Check);

  ioptions:=0;
  pierrorlevel:=0;
  Screen.Cursor:= crHourGlass;
  Rslt:=TUInit(@htusession); {initalize Tutility.Dll}

  If Rslt>0 then begin
   Screen.Cursor:= crDefault;
   MessageDlg('TUInit Error',mtinformation,[MBOK],0);
   Goto QuitUnit;
  end;



  Rslt:= TUVerifyTable(htuSession,       {verify the table, a Rslt of 0}
                szTableName,             {for all checks means the function}
                szPARADOX,               {completed properly}
                VErrorTable,
                '',
                ioptions,
                pierrorlevel);

If Rslt>0 then begin
      Screen.Cursor:= crDefault;
      MessageDlg('File Verify Error',mtinformation,[MBOK],0);
      Goto QuitUnit;
end;


{If verify reported pierrorlevel between 1 and 2, try and rebuild}

Case piErrorlevel of
      0: begin
          Screen.Cursor:= crDefault;
          MessageDlg('Verify Complete - No Errors',mtinformation,[MBOK],0);
         end;
    1,2:begin
        screen.cursor:=crdefault;
        If MessageDlg('Verify Failed - Press OK to Rebuild File..',mtinformation,[MBOK,MBCANCEL],0)<>1 then Goto QuitUnit;
        Screen.Cursor:= crHourGlass;
        {find file parameters needed for rebuilding}

        Rslt:=TUGetCrtblDescCount(htuSession,
                             szTableName,
                             iFldCount,
                             iIdxCount,
                             isecrecCount,
                             iValChkCount,
                             iRintCount,
                             iOptParams,
                             iOptDataLen);


     If Rslt>0 then begin
     Screen.Cursor:= crDefault;
     MessageDlg('Table Description Error',mtinformation,[MBOK],0);
     Goto QuitUnit;
     end;

      {set table Information into the crDesc record used for rebuilding}

      StrCopy(crDesc.szTblName,szTableName);
      StrCopy(crDesc.szTblType,szPARADOX);
      StrCopy(crDesc.szErrTblName,CRErrorTable);
      crDesc.iFldCount:=iFldCount;
      Getmem(crdesc.pflddesc,ifldCount*Sizeof(FldDesc));

      crDesc.iIdxCount:=iIdxCount;
      GetMem(crDesc.PIdxDesc,iIdxCount*Sizeof(IDXDesc));

      crDesc.iSecRecCount:=iSecRecCount;
      GetMem(crDesc.pSecDesc,IsecrecCount*Sizeof(SecDesc));


      crDesc.iValChkCount:=iValChkCount;
      GetMem(crDesc.pVchkDesc,iValChkCount*Sizeof(VchkDesc));

      crDesc.iRintCount:=iRintCount;
      GetMem(crDesc.pRintDesc,iRintCount*Sizeof(RintDesc));

      crDesc.iOptParams:=iOptParams;
      GetMem(crDesc.pfldOptParams,iOptParams*Sizeof(FldDesc));

      crDesc.pOptData:=pByte(AllocMem(iOptDataLen*DBIMAXSCFLDLEN));

      needtofree:=True; {set flag for quitunit cleanup}


      {give Tutility rebuild parameters}
      Screen.Cursor:= crHourGlass;
      rslt:=TUFillCRTblDesc(htuSession,
                            @crDesc,
                            szTableName,
                            '');


If Rslt>0 then begin
 Screen.Cursor:= crDefault;
 MessageDlg('Table fill Error',mtinformation,[MBOK],0);
 Goto QuitUnit;
end;



 {If everything is ok to here, tell Tutility to rebuild the table}

   Rslt:=TURebuildTable(htuSession,
                       szTableName,
                        szPARADOX,
                        BUTable,
                        KeyErrorTable,
                        RepErrorTable,
                       @CrDesc);

    Screen.Cursor:= crDefault;
    If Rslt>0 then MessageDlg('Table Repair Error',mtinformation,[MBOK],0);


    If Rslt=0 then MessageDlg('Table Verify and Rebuild Successfully Completed',mtinformation,[MBOK],0);

  end;
3:begin
   Screen.Cursor:= crDefault;
   MessageDlg('Corruption Detected-Restore from Backup',mtinformation,[MBOK],0);
  end;
end;



QuitUnit:  {cleanup and exit here}

Rslt:=TUExit(htuSession); {exit & close Tutility}
Screen.Cursor:= crDefault;
If Rslt>0 then MessageDlg('Exit Error',mtinformation,[MBOK],0);

   If needtoFree then begin  {flag to see if getmem was used}
                             {free previouly used heap space}

     Freemem(crdesc.pflddesc,ifldCount*Sizeof(FldDesc));
     FreeMem(crDesc.PIdxDesc,iIdxCount*Sizeof(IDXDesc));
     FreeMem(crDesc.pSecDesc,IsecrecCount*Sizeof(SecDesc));
     FreeMem(crDesc.pVchkDesc,iValChkCount*Sizeof(VchkDesc));
     FreeMem(crDesc.pRintDesc,iRintCount*Sizeof(RintDesc));
     FreeMem(crDesc.pfldOptParams,iOptParams*Sizeof(FldDesc));
     FreeMem(crDesc.pOptData,iOptDataLen*DBIMAXSCFLDLEN);

   end;

 end;

end;

procedure TForm1.Button1Click(Sender: TObject);
begin
application.terminate;
end;

end.
