unit RegPlace;

(*
================================================================================
TRegPlacement for Windows95 version 1.2 by marc hoffman of elite!developments
largely based upon:

  TPlacement Component version 1.0 by Barry L. Harkness - Public Domain

           Feel free to use this component in any application, in
           any context, without any warranty.  This component is
           donated to the public domain to help fellow Delphi
           programmers dominate windows software development.

this advanced version of TPlacement works practically the same as TPlacement, ecxept
the placement of the window will not be saved in an .INI file, but in the system
registry. for this component to run, you will also need TRegistry, also written by me,
which is available as .DCU file, freeware.
(and should be in the same package as this file. if this is NOT the case please inform
 me, and you will get a copy of the complete package per email.)

if you have any suggestions, cannot find Registry.DCU, or whatever, please contact me at
marc@arb-phys.uni-dortmund.de (marc hoffman)

one again thanx to Barry for supplying the original TPlacement component.




you must include a TRegistry component on your Form and select it in the "Registry" property
of TRegPlacement.
the Style property states, whether the window placement is stored differently for each user logged
onto th network, or in general for all users (psByUser vs. psByMachine)
see the docu to TRegistry for in depth information about this.

in order to use TRegPlacement, you should, as you did with TPlacement, call the Read method when
your form is created (i.e. in the OnFormCreate event) and the Write method when the form is closed
or destroyed.

and remember : the Registry component works only for Win95, and so does this one, since it
strongly depends on on TRegistry. (WinNT sould do the job as well, but haven't checked this.)


public domain
*)

{-------------------------------------------------------------------------------------------}
interface
{-------------------------------------------------------------------------------------------}

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Forms, Dialogs,
     Registry;

type TStyle = (psByUser,psByMachine);

     TRegPlacement = class(TComponent)
     private
       fRegistry:TRegistry;
       fStyle:TStyle;
       fKey:string;
       procedure SetKey(s:string);
     public
       constructor Create(AOwner : TComponent); override;
       procedure Write; virtual;
       procedure Read; virtual;
     published
       { Published declarations }
       property Regsitry:TRegistry read fRegistry write fRegistry;
       property Key:string read fKey write SetKey;
       property Style:TStyle read fStyle write fStyle;
     end;

procedure Register;

{-------------------------------------------------------------------------------------------}
implementation
{-------------------------------------------------------------------------------------------}

const
  pcFlags    = '\flags';
  pcShowCmd  = '\ShowCmd';
  pcMinPosX  = '\MinPosX';
  pcMinPosY  = '\MinPosY';
  pcMaxPosX  = '\MaxPosX';
  pcMaxPosY  = '\MaxPosY';
  pcNormPosL = '\NormPosLeft';
  pcNormPosT = '\NormPosTop';
  pcNormPosR = '\NormPosRight';
  pcNormPosB = '\NormPosBottom';

function IntVal(s:string):integer;
var i,c : integer;
begin
	Val(s,i,c);
  result := i;
end;

function IntStr(i:integer):string;
var s: string;
begin
  Str(i,s);
  result := s;
end;

{-------------------------------------------------------------------------------------------}
constructor TRegPlacement.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  Key := 'MyWindowPlacement';
end;

{-------------------------------------------------------------------------------------------}
procedure TRegPlacement.Read;
var Placement : TWindowPlacement;
begin
  if Regsitry = nil then exit;
  try
    Placement.length :=SizeOf(TWindowPlacement);
    with Placement do begin
      case Style of
        psByUser:begin
                   Flags := IntVal(fRegistry.ReadStringUser(Key+pcFlags));
                   ShowCmd := IntVal(fRegistry.ReadStringUser(Key+pcShowCmd));
                   ptMinPosition.X := IntVal(fRegistry.ReadStringUser(Key+pcMinPosX));
                   ptMinPosition.Y := IntVal(fRegistry.ReadStringUser(Key+pcMinPosY));
                   ptMaxPosition.X := IntVal(fRegistry.ReadStringUser(Key+pcMaxPosX));
                   ptMaxPosition.Y := IntVal(fRegistry.ReadStringUser(Key+pcMaxPosY));
                   rcNormalPosition.Left :=   IntVal(fRegistry.ReadStringUser(Key+pcNormPosL));
                   rcNormalPosition.Top :=    IntVal(fRegistry.ReadStringUser(Key+pcNormPosT));
                   rcNormalPosition.Right :=  IntVal(fRegistry.ReadStringUser(Key+pcNormPosR));
                   rcNormalPosition.Bottom := IntVal(fRegistry.ReadStringUser(Key+pcNormPosB));
                 end;
        else begin
          Flags := IntVal(fRegistry.ReadString(Key+pcFlags));
          ShowCmd := IntVal(fRegistry.ReadString(Key+pcShowCmd));
          ptMinPosition.X := IntVal(fRegistry.ReadString(Key+pcMinPosX));
          ptMinPosition.Y := IntVal(fRegistry.ReadString(Key+pcMinPosY));
          ptMaxPosition.X := IntVal(fRegistry.ReadString(Key+pcMaxPosX));
          ptMaxPosition.Y := IntVal(fRegistry.ReadString(Key+pcMaxPosY));
          rcNormalPosition.Left :=   IntVal(fRegistry.ReadString(Key+pcNormPosL));
          rcNormalPosition.Top :=    IntVal(fRegistry.ReadString(Key+pcNormPosT));
          rcNormalPosition.Right :=  IntVal(fRegistry.ReadString(Key+pcNormPosR));
          rcNormalPosition.Bottom := IntVal(fRegistry.ReadString(Key+pcNormPosB));
        end;
      end;
      if rcNormalPosition.Right > rcNormalPosition.Left then
        SetWindowPlacement(TForm(Owner).Handle, @Placement)
    end;
  except
    on ERegistryError do;
    else raise
  end;
end;

{-------------------------------------------------------------------------------------------}
procedure TRegPlacement.Write;
var Placement : TWindowPlacement;
begin
  if Regsitry = nil then exit;
  Placement.length :=SizeOf(TWindowPlacement);
  if not GetWindowPlacement(TForm(Owner).Handle, @Placement) then
  begin
    raise EAbort.Create('Unable to retrieve window placement');
    Exit;
  end;

  with Placement do begin
    case Style of
      psByUser:begin
                 fRegistry.WriteStringUser(Key+pcFlags, IntStr(Flags));
                 fRegistry.WriteStringUser(Key+pcShowCmd, IntStr(ShowCmd));
                 fRegistry.WriteStringUser(Key+pcMinPosX, IntStr(ptMinPosition.X));
                 fRegistry.WriteStringUser(Key+pcMinPosY, IntStr(ptMinPosition.Y));
                 fRegistry.WriteStringUser(Key+pcMaxPosX, IntStr(ptMaxPosition.X));
                 fRegistry.WriteStringUser(Key+pcMaxPosY, IntStr(ptMaxPosition.Y));
                 fRegistry.WriteStringUser(Key+pcNormPosL, IntStr(rcNormalPosition.Left));
                 fRegistry.WriteStringUser(Key+pcNormPosT, IntStr(rcNormalPosition.Top));
                 fRegistry.WriteStringUser(Key+pcNormPosR, IntStr(rcNormalPosition.Right));
                 fRegistry.WriteStringUser(Key+pcNormPosB, IntStr(rcNormalPosition.Bottom));
               end;
      else begin
        fRegistry.WriteString(Key+pcFlags, IntStr(Flags));
        fRegistry.WriteString(Key+pcShowCmd, IntStr(ShowCmd));
        fRegistry.WriteString(Key+pcMinPosX, IntStr(ptMinPosition.X));
        fRegistry.WriteString(Key+pcMinPosY, IntStr(ptMinPosition.Y));
        fRegistry.WriteString(Key+pcMaxPosX, IntStr(ptMaxPosition.X));
        fRegistry.WriteString(Key+pcMaxPosY, IntStr(ptMaxPosition.Y));
        fRegistry.WriteString(Key+pcNormPosL, IntStr(rcNormalPosition.Left));
        fRegistry.WriteString(Key+pcNormPosT, IntStr(rcNormalPosition.Top));
        fRegistry.WriteString(Key+pcNormPosR, IntStr(rcNormalPosition.Right));
        fRegistry.WriteString(Key+pcNormPosB, IntStr(rcNormalPosition.Bottom));
      end;
    end;
  end;
end;

{-------------------------------------------------------------------------------------------}
procedure TRegPlacement.SetKey;
begin
  if s = '' then exit;
  fKey := s;
end;

{-------------------------------------------------------------------------------------------}
{-------------------------------------------------------------------------------------------}
procedure Register;
begin
  RegisterComponents('System', [TRegPlacement]);
end;

end.
