{ Registerforms component 
  registers all form sizes and positions 
  automatically when dropped on the mainform.

  All rights reserved.
  (C) By Troels S Eriksen, 1996 - 1997
  EMail TSEriksen@cyberdude.com

  32bit version note:
  If TProject is installed, TRegisterforms will retrieve
  the company name stored in the registry.
}
unit RegForms;
{$D-}

interface

uses
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF WIN32}
  Windows,
  Registry;
  {$ELSE}
  IniFiles;
  {$ENDIF}

type
  {$IFDEF WIN32}
  TRegisterEvent = procedure (Sender: TObject; RegIni:TRegIniFile) of object;
  THKEY = (LocalMachine,CurrentUser);
  {$ELSE}
  TRegisterEvent = procedure (Sender: TObject; Ini:TIniFile) of object;
  {$ENDIF}

type
  TRegisterForms = class(TComponent)
  private
    FEnabled : Boolean;
    {$IFDEF WIN32}
    FTitle   : string;
    FCompany : string;
    FRootKey : THKEY;
    {$ENDIF}
    { Private declarations }
    FMainFormOnShow   : TNotifyEvent;
    FMainFormOnClose  : TCloseEvent;
    FOnRead           : TRegisterEvent;
    FOnWrite          : TRegisterEvent;
    procedure SetEnabled(Value:Boolean);
    function GetEnabled:Boolean;
  protected
    { Protected declarations }
    procedure   SaveFormInformation(Sender:TObject;var Action:TCloseAction);
    procedure   LoadFormInformation(Sender:TObject);
    procedure   Loaded; override;
  public
    { Public declarations }
    constructor Create(AComponent:TComponent); override;
    procedure   Free;
  published
    { Published declarations }
    {$IFDEF WIN32}
    property Company : String  read FCompany   write FCompany;
    property RootKey : THKEY   read FRootKey   write FRootKey;
    {$ENDIF}
    property Enabled : boolean read GetEnabled write SetEnabled;
    property OnRead  : TRegisterEvent read FOnRead write FOnRead;
    property OnWrite : TRegisterEvent read FOnWrite write FOnWrite;
  end;

procedure Register;

implementation

procedure TRegisterForms.Loaded;
var
  a : Integer;
begin
  inherited Loaded;
  if (not (csDesigning in Componentstate)) then begin
    { This stores any procedures linked to the mainforms
      OnShow / OnCLose event in a internal var.
      Then RegisterForms own OnRead/OnWrite proc's is inserted.
      Since Application.MainForm isn't set at this time, we'll
      have to loop through all components until first form (the
      comming mainform) is found.
    }
    a:=0;
    While not (application.components[a] is TForm) do Inc(a);
    FMainFormOnShow:=TForm(Application.components[a]).OnShow;
    FMainFormOnClose:=TForm(Application.components[a]).OnClose;
    TForm(Application.components[a]).OnShow  :=LoadFormInformation;
    TForm(Application.components[a]).OnClose :=SaveFormInformation;
    {$IFDEF WIN32}
    { Set application title without version information }
    FTitle:=Application.Title;
    if Pos('ver.',lowercase(FTitle))>0 then
      system.delete(FTitle,Pos('ver.',lowercase(FTitle)),length(FTitle));
    While FTitle[1]=' ' do system.delete(FTitle,1,1);
    While FTitle[length(FTitle)]=' ' do system.delete(FTitle,Length(FTitle),1);
    {$ENDIF}
  end;
end;

procedure TRegisterForms.SetEnabled(Value:Boolean);
begin
  FEnabled:=Value;
end;

function TRegisterForms.GetEnabled:Boolean;
begin
  GetEnabled:=FEnabled;
end;


constructor TRegisterForms.Create(AComponent:TComponent);
  {$IFDEF WIN32}
  function CompanyName:string;
  { Search for TProjects registry information - insert company name
    if found else the string 'My Company name' }
  var
    RegIni : TRegIniFile;
  begin
    RegIni:=TRegIniFile.Create('SOFTWARE\BORLAND\DELPHI\2.0');
    With RegIni do try
      CompanyName:=ReadString('Project Version','Company','My company name');
    finally
      RegIni.Free;
    end;
  end;
  {$ENDIF}
begin
  Inherited Create(AComponent);
  FMainFormOnClose:=NIL;
  FMainFormOnShow :=NIL;
  FOnRead :=NIL;
  FOnWrite:=NIL;
  Enabled :=FALSE;
  {$IFDEF WIN32}
  RootKey :=CurrentUser;
  Company :=CompanyName;
  FTitle  :=Application.Title; { Set Title to title in title property }
  {$ENDIF}
end;

procedure TRegisterForms.Free;
begin
  Inherited Free;
end;

procedure TRegisterForms.SaveFormInformation;
var
  a,b : integer;
  Key,
  SubKey : string;
  {$IFDEF WIN32}
  RegIni : TRegIniFile;
  {$ELSE}
  RegIni : TIniFile;
  {$ENDIF}
begin
  if not (csDesigning in ComponentState) then try
    {$IFDEF WIN32}
    Key:='SOFTWARE\'+Company+'\'+FTitle;
    RegIni:=TRegIniFile.Create('');
    Case FRootKey of
      LocalMachine : RegIni.RootKey:=HKEY_LOCAL_MACHINE;
      CurrentUser  : RegIni.RootKey:=HKEY_CURRENT_USER;
    end;
    RegIni.OpenKey(KEY,TRUE);
    {$ELSE}
    Key:=ChangeFileExt(Application.ExeName,'.ini');
    RegIni:=TIniFile.Create(key);
    {$ENDIF}
    Try
      if assigned(FOnWrite) then FOnWrite(SELF,RegIni);
    finally
      If Enabled then begin
        a:=0;
        b:=application.componentcount;
        While a<b do begin
          If application.components[a] is tform then with RegIni do begin
            { only save state if the components ancestor is a form }
            {$IFDEF WIN32}
            SubKey:='Forms\'+TForm(Application.Components[a]).Name;
            {$ELSE}
            SubKey:=TForm(Application.Components[a]).Caption;
            {$ENDIF}
            With TForm(application.components[a]) do begin
              WriteInteger(SubKey,'Tag',   Tag);
              If WindowState=wsNormal then begin
                { only write new size if form is not
                  max or min - thus we'er saving an
                  "old" - resize value
                  NB: Delphi Ignorres a state of wsMinimized
                      when creating a form.
                  }
                WriteInteger(SubKey,'Top',   Top);
                WriteInteger(SubKey,'Left',  Left);
                if (borderstyle=bsSizeable) {$IFDEF WIN32} or
                   (borderstyle=bsSizeToolWin) {$ENDIF} then begin
                  { Only write size if border is sizeable }
                  WriteInteger(SubKey,'Height',Height);
                  WriteInteger(SubKey,'Width', Width);
                  WriteInteger(SubKey,'State', Integer(WindowState));
                end; { border }
              end; { WindowState }
            end; { With Form }
          end; { if form }
          Inc(a);
        end;
      end; { enabled }
    end; { finally }
  finally
    RegIni.Free;
    if assigned(FMainFormOnClose) then FMainFormOnClose(SELF,Action);
  end;
end;

procedure TRegisterForms.LoadFormInformation;
var
  a,b : integer;
  Key,
  SubKey : string;
  {$IFDEF WIN32}
  RegIni : TRegIniFile;
  {$ELSE}
  RegIni : TIniFile;
  {$ENDIF}
begin
  if not (csDesigning in ComponentState) then try
    {$IFDEF WIN32}
    Key:='SOFTWARE\'+Company+'\'+FTitle;
    RegIni:=TRegIniFile.Create('');
    Case FRootKey of
      LocalMachine : RegIni.RootKey:=HKEY_LOCAL_MACHINE;
      CurrentUser  : RegIni.RootKey:=HKEY_CURRENT_USER;
    end;
    RegIni.OpenKey(KEY,TRUE);
    {$ELSE}
    Key:=ChangeFileExt(Application.ExeName,'.ini');
    RegIni:=TIniFile.Create(key);
    {$ENDIF}
    try
      if assigned(FOnRead) then FOnRead(SELF,RegIni);
    finally
      If Enabled then begin
        a:=0;
        b:=application.componentcount;
        While a<b do begin
          If (application.components[a] is tform) then with RegIni do begin
            { only read state if the components ancestor is a form }
            {$IFDEF WIN32}
            SubKey:='Forms\'+TForm(Application.Components[a]).Name;
            {$ELSE}
            SubKey:=TForm(Application.Components[a]).caption;
            {$ENDIF}
            With TForm(application.components[a]) do begin
              Tag   :=ReadInteger(SubKey,'Tag',   Tag);
              Top   :=ReadInteger(SubKey,'Top',   Top);
              Left  :=ReadInteger(SubKey,'Left',  Left);
              if (borderstyle=bsSizeable) {$IFDEF WIN32} or
                 (borderstyle=bsSizeToolWin) {$ENDIF} then begin
                { Only read size if border is sizeable }
                Height:=ReadInteger(SubKey,'Height',Height);
                Width :=ReadInteger(SubKey,'Width', Width);
                WindowState:=TWindowState(ReadInteger(SubKey,'State',
                                          integer(WindowState)));
              end; { if border }
            end; { with Form }
          end; { if form }
          Inc(a);
        end;
      end; { enabled }
    end; { finally }
  finally
    RegIni.Free;
    if assigned(FMainFormOnShow) then FMainFormOnShow(SELF);
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TRegisterForms]);
end;

end.

