unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, Rebar, StdCtrls, TransBtn;

type
  TForm1 = class(TForm)
    ListView1: TListView;
    Panel1: TPanel;
    Rebar1: TRebar;
    ComboBox1: TComboBox;
    Rebar2: TRebar;
    procedure FormShow(Sender: TObject);
    procedure Rebar2GripperMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Rebar2GripperMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Rebar2GripperMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure Rebar2Collapse(Sender: TObject; var Collapse: Boolean;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Rebar1Collapse(Sender: TObject; var Collapse: Boolean;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
    IsDown:boolean;
    PosX:integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
     Rebar2.Caption := 'Links';
end;

procedure TForm1.Rebar2GripperMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     IsDown := True;
     PosX := X;
end;

procedure TForm1.Rebar2GripperMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     IsDown := False;
end;

procedure TForm1.Rebar2GripperMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     if IsDown then
     begin
        Rebar1.Align := alClient;
        Rebar2.Align := alNone;
        Rebar2.Left := Rebar2.Left + PosX + X;
        Rebar2.Width := ClientWidth;
     end;
end;

procedure TForm1.Rebar2Collapse(Sender: TObject; var Collapse: Boolean;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     Collapse := True;
     Rebar1.Align := alClient;
     Rebar2.Align := alRight;
end;

procedure TForm1.Rebar1Collapse(Sender: TObject; var Collapse: Boolean;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     Collapse := True;
     Rebar1.Align := alLeft;
     Rebar2.Align := alClient;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
     Rebar2.Width := ClientWidth;
end;

end.
