unit Rband;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus;

type
  TBandStyle = (rbRect,rbEllipse,rbControl);
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Type1: TMenuItem;
    Rectangle1: TMenuItem;
    Ellipse1: TMenuItem;
    Lines: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Rectangle1Click(Sender: TObject);
    procedure Ellipse1Click(Sender: TObject);
    procedure LinesClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    GotMouse : boolean;
    Anchor,
    Rover    : TPoint;
    BandStyle : TBandStyle;
    procedure MakeARubber(OnWhat : TCanvas; X, Y : integer);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  SetCapture(Handle);  { WIN API function, grabs all mouse actions to this window }
  GotMouse := TRUE;    { need to keep track of who has teh mouse }
  Anchor.X := X; Anchor.Y := Y;  { where we started from }
  Rover := Anchor;               { where we are now}
  Canvas.MoveTo(X,Y);
end;

procedure TForm1.MakeARubber(OnWhat : TCanvas; X, Y : integer);

begin
  with OnWhat do
  begin
    SetROP2(Handle,R2_NOTXORPEN);  { use to Raster Op codes to make the rubberband }
    Pen.Style := psDot;
    Brush.Style := bsClear;        { don't fill the interior of the shape, please }
    case BandStyle of
      rbRect : begin               { make dull old boxes ... }
                 Rectangle(Anchor.X,Anchor.Y,Rover.X,Rover.Y);
                 Rover.X := X; Rover.Y := Y;
                 Rectangle(Anchor.X,Anchor.Y,Rover.X,Rover.Y);
               end;
   rbEllipse : begin               { make pretty circles...}
                 Ellipse(Anchor.X,Anchor.Y,Rover.X,Rover.Y);
                 Rover.X := X; Rover.Y := Y;
                 Ellipse(Anchor.X,Anchor.Y,Rover.X,Rover.Y);
               end;
   rbControl : begin               { Connect the dots }
                 MoveTo(Anchor.X,Anchor.Y);
                 LineTo(Rover.X,Rover.Y);
                 Rover.X := X; Rover.Y := Y;
                 MoveTo(Anchor.X,Anchor.Y);
                 LineTo(Rover.X,Rover.Y);
               end;
     end;  { CASE }
  end;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if GotMouse then MakeARubber(Canvas,X,Y);
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if GotMouse then
  begin
    MakeARubber(Canvas,X,Y);  { this deletes old shape, makes current one }
    ReleaseCapture; GotMouse := FALSE;
    with Canvas do
    begin
      SetROP2(Handle,R2_COPYPEN);
      Pen.Style := psSolid;
      case BandStyle of
           rbRect : Rectangle(Anchor.X,Anchor.Y,Rover.X,Rover.Y);
        rbEllipse : Ellipse(Anchor.X,Anchor.Y,Rover.X,Rover.Y);
        rbControl : begin MoveTo(Anchor.X,Anchor.Y); LineTo(Rover.X,Rover.Y); end;
      end;  { CASE }
    end;
  end;
end;

procedure TForm1.Rectangle1Click(Sender: TObject);
begin
  BandStyle := rbRect;
  Rectangle1.Checked := TRUE;
  Ellipse1.Checked := FALSE;
  Lines.Checked := FALSE;
end;

procedure TForm1.Ellipse1Click(Sender: TObject);
begin
  BandStyle := rbEllipse;
  Rectangle1.Checked := FALSE;
  Ellipse1.Checked := TRUE;
  Lines.Checked := FALSE;
end;

procedure TForm1.LinesClick(Sender: TObject);
begin
  BandStyle := rbControl;
  Rectangle1.Checked := FALSE;
  Ellipse1.Checked := FALSE;
  Lines.Checked := TRUE;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Rectangle1Click(Sender);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  if GotMouse then ReleaseCapture;  { be polite, make sure }
  Close;
end;

end.
