unit Rasform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, RASComp, RAS_API;

type
  TRASConnect = class(TForm)
    ConnectBtn: TBitBtn;
    Memo1: TMemo;
    StatusBtn: TBitBtn;
    DisconnectBtn: TBitBtn;
    PhoneBox: TComboBox;
    ConnectionBox: TComboBox;
    RAS1: TRAS;
    procedure ConnectBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StatusBtnClick(Sender: TObject);
    procedure DisconnectBtnClick(Sender: TObject);
    procedure PhoneBoxExit(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure RAS1Connect(Sender: TObject);
    procedure RAS1Disconnect(Sender: TObject);
  private
    { Private declarations }
    function Connect: LongInt;
    function GetErrorString(ErrorCode: LongInt): String;
    function Disconnect: LongInt;
    function GetConnectStatus: LongInt;
    function GetConnections: LongInt;
    function GetPhoneBookEntries: LongInt;
    function CurrentStatus: String;
  public
    { Public declarations }
  end;

var
  RASConnect: TRASConnect;

implementation

{$R *.DFM}

procedure TRASConnect.ConnectBtnClick(Sender: TObject);
begin
  RAS1.EntryName := PhoneBox.Text;
  Connect;
end;

function TRASConnect.Connect: LongInt;
begin
  RAS1.Connect;
  If RAS1.LastError = 0 THEN
     Memo1.Lines.Add('RAS Handle:  ' + IntToStr(RAS1.RASConn));
end;

function TRASConnect.GetErrorString(ErrorCode: LongInt): String;
begin
  Result := RAS1.GetErrorString(ErrorCode);
end;

function TRASConnect.Disconnect: LongInt;
begin
  Screen.Cursor := crHourglass;
  Result := RAS1.Disconnect;
  Memo1.Lines.Add('Disconnected:  ' + IntToStr(Result));
  Screen.Cursor := crDefault;
end;

function TRASConnect.GetConnectStatus: LongInt;
begin
  Result := RAS1.GetConnectStatus;
end;

function TRASConnect.GetConnections: LongInt;
var
  I: Integer;
begin
  ConnectionBox.Items.Clear;
  ConnectionBox.Text := '';
  Result := RAS1.GetConnections;
  If Result = Success THEN
     If RAS1.Connections.Count > 0 THEN
        For I := 0 To RAS1.Connections.Count - 1 DO
            ConnectionBox.Items.Add(RAS1.Connections.EntryName(I));
end;

function TRASConnect.GetPhoneBookEntries;
var
  I: Integer;
begin
  Result := RAS1.GetPhoneBookEntries;
  PhoneBox.Items.Clear;
  PhoneBox.Text := '';
  If Result = 0 THEN
     If RAS1.PhoneBookEntries.Count > 0 THEN
        For I := 0 To RAS1.PhoneBookEntries.Count - 1 DO
            PhoneBox.Items.Add(RAS1.PhoneBookEntries.Strings[I]);
end;

function TRASConnect.CurrentStatus: String;
begin
  Result := RAS1.CurrentStatus;
  If Result <> '' THEN
     Memo1.Lines.Add(Result);
end;

procedure TRASConnect.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  RAS1.Disconnect;
end;

procedure TRASConnect.StatusBtnClick(Sender: TObject);
begin
  RAS1.CurrentStatus;
  RAS1.GetConnections;
end;

procedure TRASConnect.DisconnectBtnClick(Sender: TObject);
begin
  Disconnect;
end;


procedure TRASConnect.PhoneBoxExit(Sender: TObject);
begin
  RAS1.EntryName := '';
  RAS1.PhoneNumber := '';
  If PhoneBox.Text[1] In ['0'..'9'] THEN
     RAS1.PhoneNumber := PhoneBox.Text
  ELSE
     RAS1.EntryName := PhoneBox.Text;
end;

procedure TRASConnect.FormActivate(Sender: TObject);
begin
  GetConnections;
  GetPhoneBookEntries;
end;

procedure TRASConnect.RAS1Connect(Sender: TObject);
begin
  ShowMessage('Connected!');
end;

procedure TRASConnect.RAS1Disconnect(Sender: TObject);
begin
  ShowMessage('Disconnected');
end;

end.

