{                  *** Program : RANDOM.DPR                                  }
{                   *** Author : Chris Haidinyak                             }
{                    *** Email : chrish@alpha.techspecs.com                  }
{                     *** Date : 03-DEC-1995                                 }
{                                                                            }
{ *** Comments : This program was dervied from code written by the following }
{                people :                                                    }
{                                                                            }
{                George Marsaglia,                                           }
{                Arif Zaman       : Florida State University                 }
{                                   Random Number Generator "origin"?        }
{                                   FSU-SCRI-87-50 (1987)                    }
{                                                                            }
{                F. James         : ???                                      }
{                                   Later Modifications.                     }
{                                   "A review of Pseudo-Random Number        }
{                                    Generators"                             }
{                                                                            }
{                David LaSalle    : Florida State University                 }
{                                   Original FORTRAN code.                   }
{                                                                            }
{                Jim Butler       : Translation to C code.                   }
{                                                                            }
{                Chris Haidinyak  : Translation to Delphi code.              }
{                                                                            }
{                                                                            }
{                For additional comments, refer to the above documents.      }
{                                                                            }
program Random;

uses
  SysUtils,
  WinProcs,
  WinTypes,
  WinCRT,

  MyRandom;

Var
  I              : Word;
  J              : LongInt;
  AValue         : LongInt;
  BValue         : LongInt;
  CValue         : Extended;
  MyRandomNumber : TRandom;
  TheBigArray    : Array [0..4000] of LongInt;
  F              : TextFile;

Begin
  InitWinCRT;
  AssignFile(F, 'test1.csv');
  ReWrite(F);

  For I := 0 to 4000 do
    TheBigArray[I] := 0;

  BValue := 4000;
  MyRandomNumber := TRandom.Create(1802,9373); {1802,9373 are test-case seeds}

  With MyRandomNumber do
  Begin
    For J := 1 to 20000 do     {For a larger sample-size, change to 100000000}
    Begin
      If ((J mod 10000) = 0) Then
        Writeln(J);

      AValue := GetRandomValue(BValue);
      If ((AValue <= 4000) and (AValue >= 0)) Then
        TheBigArray[AValue] := TheBigArray[AValue] + 1
      Else
        Writeln('Problem with program...');
    End;
  End;
  For I := 0 to 4000 do
    Writeln(F, I, ',', TheBigArray[I]);

  CloseFile(F);

  With MyRandomNumber do
  Begin
    For I := 1 to 2 do
    Begin
      For J := 1 to 3 do
      Begin
      { *** Values should be : 6533892.0, 14220222.0, 7275067.0              }
      {                        6172232.0, 8354498.0,  10633180.0             }

        CValue := GetBaseRandomValue * 4096.0 * 4096.0;
        Write(CValue:1:1, ', ');
      End;
      Writeln;
    End;
  End;
End.
