{                     *** Unit : MYRANDOM.PAS                                }
{                   *** Author : Chris Haidinyak                             }
{                    *** Email : chrish@alpha.techspecs.com                  }
{                     *** Date : 03-DEC-1995                                 }
{                                                                            }
{ *** Comments : This unit was dervied from code written by the following    }
{                people :                                                    }
{                                                                            }
{                George Marsaglia,                                           }
{                Arif Zaman       : Florida State University                 }
{                                   Random Number Generator "origin"?        }
{                                   FSU-SCRI-87-50 (1987)                    }
{                                                                            }
{                F. James         : ???                                      }
{                                   Later Modifications.                     }
{                                   "A review of Pseudo-Random Number        }
{                                    Generators"                             }
{                                                                            }
{                David LaSalle    : Florida State University                 }
{                                   Original FORTRAN code.                   }
{                                                                            }
{                Jim Butler       : Translation to C code.                   }
{                                                                            }
{                Chris Haidinyak  : Translation to Delphi code.              }
{                                                                            }
{                                                                            }
{                For additional comments, refer to the above documents.      }
{                                                                            }
Unit MyRandom;


Interface
Type
  TRandom = Class
    Private
      AnArray : Array [1..97] of Extended;

      C,
      CD,
      CM : Extended;

      Ptr1,
      Ptr2 : Byte;
    Public
      Constructor Create (FirstSeed, SecondSeed : Word);
      Function GetBaseRandomValue : Extended;
      Function GetRandomValue(AValue : LongInt): LongInt;
  End;




Implementation

{ Comments : FirstSeed and SecondSeed must be a Word from 0 to 31328 or      }
{            0 to 30081 respectively                                         }
Constructor TRandom.Create (FirstSeed, SecondSeed : Word);
Var
  I, J, K, L, M, Loop1, Loop2 : Word;
  S, T : Extended;
Begin
  If (FirstSeed > 31328) Then
    FirstSeed := 31328;
  If (SecondSeed > 30081) Then
    SecondSeed := 30081;

  I := ((FirstSeed div 177) mod 177) + 2;
  J := (FirstSeed mod 177) + 2;
  K := ((SecondSeed div 169) mod 178) + 1;
  L := SecondSeed mod 169;

  For Loop1 := 1 to 97 do
  Begin
    S := 0.0;
    T := 0.5;
    For Loop2 := 1 to 24 do
    Begin
      M := (((I * J) mod 179) * K) mod 179;
      I := J;
      J := K;
      K := M;
      L := ((53 * L) + 1) mod 169;
      If (((L * M) mod 64) >= 32) Then
        S := S + T;
      T := T * 0.5;
    End;
    AnArray[Loop1] := S;
  End;
  C  :=   362436.0 / 16777216.0;
  CD :=  7654321.0 / 16777216.0;
  CM := 16777213.0 / 16777216.0;

  Ptr1 := 97;
  Ptr2 := 33;
End;


{ Comments : Outputs an extended number between 0 and 1 }
Function TRandom.GetBaseRandomValue : Extended;
Var
  Uni : Extended;
Begin
  Uni := AnArray[Ptr1] - AnArray[Ptr2];
  If (Uni < 0.0) Then
    Uni := Uni + 1.0;

  AnArray[Ptr1] := Uni;

  Ptr1 := Ptr1 - 1;
  If (Ptr1 = 0) Then
    Ptr1 := 97;

  Ptr2 := Ptr2 - 1;
  If (Ptr2 = 0) Then
    Ptr2 := 97;

  C := C - CD;
  If (C < 0.0) Then
    C := C + CM;

  Uni := Uni - C;
  If (Uni < 0.0) Then
    Uni := Uni + 1.0;

  Result := Uni;
End;


{ Comments : Outputs a LongInt between 0 and AValue }
Function TRandom.GetRandomValue(AValue : LongInt) : LongInt;
Var
  Temp1 : Extended;
Begin
  Temp1 := GetBaseRandomValue;
  Temp1 := Temp1 * AValue;

  Result := Trunc(Temp1);
End;


End.
