{ Copyright (C) by Artem A. Berman   }

{$D-,L-,Y-,I-,S-}

unit ralarm;

interface

uses Classes, Controls, Forms, SysUtils, StdCtrls, ExtCtrls;

type
  EAlarmException = class(Exception);  

  TRealAlarm = class(TComponent)
  private
    FHour,
    FMin,
    FSec,
    FMlSec: Word;

    FAlarmTime: string;
    FShowObject: TControl;
    FTimer: TTimer;
    FOnAlarm: TNotifyEvent;
    FActive: Boolean;

    procedure SetActive(State: Boolean);
    procedure SetAlarmTime(Tm: string);
    procedure RunAlarm(Sender: TObject);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property AlarmTime: string read FAlarmTime write SetAlarmTime;
    property ShowObject: TControl read FShowObject write FShowObject;
    property Active: Boolean read FActive write SetActive default false;
    property OnAlarm: TNotifyEvent read FOnAlarm write FOnAlarm;
  end;

procedure Register;

implementation

constructor TRealAlarm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTimer := TTimer.Create(Self);
  FTimer.Enabled := False;
  FTimer.Interval := 1000;
  FTimer.OnTimer := RunAlarm;
  Active := False;
end;

destructor TRealAlarm.Destroy;
begin
  FTimer.Free;
  inherited Destroy;
end;


procedure TRealAlarm.SetActive(State: Boolean);
var
  falmTime,
  falmToGo,
  ftmpTime: TDateTime;
  Kind: Boolean;
  ss: string;
begin
  if FActive <> State then FActive := State;
  if FActive then
  begin
    falmTime := StrToTime(FAlarmTime);
    if Time < falmTime then
    begin
      falmToGo :=  falmTime - Time;
      Kind := True;
    end else
    begin
      ftmpTime := StrToTime('11:59:59 PM');
      falmToGo := ftmpTime - Time + falmTime;
      Kind := False;
    end;
    DecodeTime(falmToGo, FHour, FMin, FSec, FMlsec);
    if not Kind then inc(FSec);

    FTimer.Enabled := True;
  end else
    FTimer.Enabled := False;
end;

procedure TRealAlarm.SetAlarmTime(Tm: string);
begin
  if Length(Tm) = 2 then Tm := Tm + ':00:00' else
  if Length(Tm) = 5 then Tm := Tm + ':00';
  FAlarmTime := FormatDateTime('hh:mm:ss AM/PM', StrToTime(Tm));
end;

procedure TRealAlarm.RunAlarm(Sender: TObject);
var
  strHour, strMin, strSec, strInfo: string; 
begin
  if FSec > 0 then FSec := FSec-1
  else begin
    FSec := 59;
    if FMin > 0 then FMin := FMin-1
    else begin
      FMin := 59;
      if FHour > 0 then FHour := FHour-1;
    end;
  end;

  strHour := IntToStr(FHour);
  if FHour < 10 then strHour := '0' + strHour;
  strMin := IntToStr(FMin);
  if FMin < 10 then strMin := '0' + strMin;
  strSec := IntToStr(FSec);
  if FSec < 10 then strSec := '0' + strSec;

  strInfo := strHour + ':' + strMin + ':' + strSec;

  if Assigned(FShowObject) then
  begin
    if (FShowObject is TLabel) then (FShowObject as TLabel).Caption := strInfo
    else 
    if (FShowObject is TPanel) then (FShowObject as TPanel).Caption := strInfo
    else
    if (FShowObject is TButton) then (FShowObject as TButton).Caption := strInfo
    else
    if (FShowObject is TEdit) then (FShowObject as TEdit).Text := strInfo
    else  begin
            raise EAlarmException.Create('Unlisted ShowObject');
            Exit;
    end;
  end;
  if (FHour = 0) and (FMin = 0) and (FSec = 0) then
  begin
    if Assigned(FOnAlarm) then FOnAlarm(Self);
    Active := False;
  end;
end;

procedure Register;
begin
  RegisterComponents('Custom', [TRealAlarm]);
end;


end.