unit Udemo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,pxtable, StdCtrls, DB, DBTables, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    Table1: TTable;
    Label1: TLabel;
    Label3: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    LLevel: TLabel;
    LRecordSize: TLabel;
    LCodePage: TLabel;
    LLanguage: TLabel;
    BlockSizeRadio: TRadioGroup;
    Edit1: TEdit;
    Label5: TLabel;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    PXTableInfo1: TPXTableInfo;
    Label6: TLabel;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure Refresh;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Procedure TForm1.Refresh;
Begin
  Table1.TableName:=Edit1.Text;
  With PXTableInfo1 do
  Begin
    Screen.Cursor:=crHourGlass;
    try
      PXTable:=Table1;
    finally
      Screen.Cursor:=crDefault;
    end;
    LLevel.Caption     :=IntToStr(Level);
    LRecordSize.Caption:=IntToStr(RecordSize);
    LCodePage.Caption  :=IntToStr(CodePage);
    LLanguage.Caption  :=Language;
    Case BlockSize of
      1: BlockSizeRadio.ItemIndex:=0;
      2: BlockSizeRadio.ItemIndex:=1;
      3: BlockSizeRadio.ItemIndex:=2;
      4: BlockSizeRadio.ItemIndex:=3;
      8: BlockSizeRadio.ItemIndex:=4;
     16: BlockSizeRadio.ItemIndex:=5;
    end;
  end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  With OpenDialog1 do
  Begin
    InitialDir:=ExtractFilePath(Edit1.Text);
    FileName:=Edit1.Text;
    if Execute then
    Begin
      Edit1.Text:=FileName;
      Refresh;
    end;
  end;
end;

procedure TForm1.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_RETURN then Refresh;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Refresh;
end;

end.

