unit Upuzz;

{This is a minimax implementation of vertical drop down tic tac toe}
{It is not very clever due to search in only 4 layers, but obviously, - it's playing the game}
{The alpha beta search algorithm has been tried without luck}

{It really doesn't have the true killer spirit, but have fun anyway}

{Any comments are welcome}

{I've made a similar chess program you can get for free, if you want, - email to:}

{Thomas Riedel, Copenhagen, riedel@dk-online.dk}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;
  const maxi = 7;
        maxj = 6;

        maxlevel = 4;
  var board : array [1..7, 1..6] of tcolor;

type
  TForm1 = class(TForm)
    Image1: TImage;
    BitBtn1: TBitBtn;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    current : tcolor;
    dx, dy : longint;
    rememberi, rememberj : longint;
    stop : boolean;
    searchlevel : longint;
    procedure Draw;
    procedure NewGame;
    function score:longint;
    function Makedraws(color: tcolor): longint;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

procedure wait;
begin
  screen.cursor := crhourglass;
end;
procedure ready;
begin
  screen.cursor := crdefault;
end;

procedure info(txt : string);
begin
  messagedlg(txt, mtinformation, [mbok], 0);
end;

{$R *.DFM}
procedure tform1.draw;
var i,j : longint;
begin
  with image1.canvas do
  begin
    dx := image1.width div (maxi);
    dy := image1.height div (maxj+1);
    brush.color := clwhite;
    rectangle(0,0, image1.width, image1.height);
    for i := 1 to Maxi do
    for j := 1 to MaxJ do
    begin
      brush.color := clgreen;
      rectangle((i-1)*dx, (j-1)*dy+dy, i*dx, j*dy+dy);
      brush.color := board[i, maxj-j+1];
      ellipse((i-1)*dx, (j-1)*dy+dy, i*dx, j*dy+dy);
    end;
  end;
end;

procedure tform1.NewGame;
var i,j : longint;
begin
    for i := 1 to Maxi do
    for j := 1 to MaxJ do
    board[i,j] := clwhite;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var i,j : integer;
begin
  newgame;
  wait;
  stop := false;
  board[4,1] := clgreen;
  draw;
  randomize;
  i := random(maxi)+1;
  if i=4 then j := 2 else j := 1;
  board[i,j] := clyellow;
  draw;
  ready;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  NewGame;
  draw;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: integer);
var i,j : longint;
begin
  wait;
  current := clgreen;
  stop := false;
  i := x div dx+1;
  j := maxj;
  {$R+}
  while board[i,j]=clwhite do
  begin
    dec(j);
    if j=0 then break;
  end;
  if j=maxj then raise exception.create('optaget') else

  board[i, j+1] := current;
  draw; update;
  if makedraws(clyellow)=0 then;
  board[rememberi, rememberj] := clyellow;
  ready;
  form1.draw;
  update;
  if abs(score) >= 100000 then info('You win') else if
  score > 90000 then info('I win ');
end;

function Tform1.score : longint;

function count(color : longint; i,j,di,dj : longint) : longint;
var c : longint;
begin
  c := 0;
  while (i<=maxi) and (j<=maxj)and  (i>0) and (j>0) and (board[i,j]=color) and (c < 4) do
  begin
    i := i+di;
    j := j+dj;
    inc(c);
  end;
  if c = 4 then count := 100000 else
  count := c;
end;

function Sum(color : tcolor):longint;
var i,j : longint;
    total : longint;
label exit;
begin
  total := 0;
  for i := 1 to maxi do
  for j := 1 to maxj do
  if board[i,j] = color then
  begin
    total := total +   {Check 4 directions:}
         count(color, i,j,0,1) +
         count(color, i,j,1,0) +
         count(color, i,j,1,1) +
         count(color, i,j,1,-1);
    if total > 100000 then goto exit; {win or los}
  end;
  exit:
  sum := total;
end;
var s : longint;

begin
  s := sum(clgreen);
  if s  >= 100000 then
  score := -100000 else
  score := sum(clyellow)-sum(clgreen);
end;

function tform1.Makedraws(color: tcolor):longint;
var n  : longint;
    col : tcolor;
    PosDraw : array [1..maxi] of longint;
    tscore : array [1..maxi] of longint;
    ms,s  : longint;
    j : longint;
    adraw : boolean;
begin
  if searchlevel < maxlevel then
  begin
    inc(searchlevel);
    adraw := true;
    for n := 1 to maxi do
    begin
      tscore[n] := 0;
      adraw := false;
      j := maxj;
      while (J>0) and (board[n,j] = clwhite) do DEC(J);
      PosDraw[n] := j+1;
    end;
    ms := -1000000;
    if adraw then makedraws := 0 else
    for n := 1 to maxi do
    if (PosDraw[n] <= maxj) and not stop then
    begin
      {make the draw}
      board[n,PosDraw[n]] := color;
      if color = clgreen then
      col := clyellow else
      col := clgreen;
      {trap stop messages:}
      application.processmessages;
      {Minimax changes sign at each incarnation}
      s := - makedraws(col);
      if s > ms then
      begin
        ms := s;
        if searchlevel=1 then {Capture actual best move:}
        begin
          rememberi := n;
          rememberj := PosDraw[n];
          label1.caption :=
          inttostr(rememberi)+'-'+
          inttostr(rememberj);
        end;
      end;
      {regret the draw:}
      board[n,PosDraw[n]] := clwhite;
    end;
    makedraws := ms;
    dec(searchlevel);
  end else makedraws := score;
end;



procedure TForm1.Button1Click(Sender: TObject);
begin
   stop := true;
   newgame;
   draw;
end;

end.


