unit Prttst;
{******************************************************************************}
{*                                                                            *}
{*                                PRTTST                                      *}
{*                                                                            *}
{* Diese Unit liest alle Daten aus, die ber fnf verschiedene Verfahren ber *}
{* den Drucker zu bekommen sind. Diese Daten gehen weit ber die Angaben von  *}
{* TPrinter hinaus. Routinen zum Setzen von Daten sind nicht implementiert.   *}
{* Wenn hier jemand Erfahrung gesammelt hat, wre ich fr Hinweise, Demos o..*}
{* sehr dankbar (eine Hand wscht die andere...<g>).                          *}
{*                                                                            *}
{* Fr die Funktion des Codes in allen "Lebenslagen" wird keine Garantie ber-*}
{* nommen. Auch hier bin ich fr Hinweise dankbar!                            *}
{*                                                                            *}
{* Viel Spa! - Michael [100120,2601]                                         *}
{*                                                                            *}
{* P.S.: Leider hatte ich nicht die Zeit aus diesem Code eine Funktions-Bib-  *}
{*       liothek zu machen...                                                 *}
{*                                                                            *}
{******************************************************************************}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, Dialogs,
  Printers, Print, TabNotBk, About;

type
  TForm1 = class(TForm)
	 LBPrinter: TListBox;
	 Bevel1: TBevel;
    TabbedNotebook1: TTabbedNotebook;
    GroupBox5: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
	 Label6: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    Label4: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label1: TLabel;
    LDevice: TLabel;
    LName: TLabel;
    LPort: TLabel;
    ListBox2: TListBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    GroupBox2: TGroupBox;
    LVersion: TLabel;
    LTech: TLabel;
	 LHorzSize: TLabel;
    LVertSize: TLabel;
    LHorzRes: TLabel;
    LVertRes: TLabel;
    LLogPixelsX: TLabel;
    LLogPixelsY: TLabel;
    LPlanes: TLabel;
    LBitsPixel: TLabel;
    LNumBrushes: TLabel;
    LNumPens: TLabel;
    LNumMarkers: TLabel;
    LNumFonts: TLabel;
    LNumColors: TLabel;
    LAspectX: TLabel;
    LAspectY: TLabel;
    LAspectXY: TLabel;
    LPDeviceSize: TLabel;
	 LClipping: TLabel;
	 GroupBox1: TGroupBox;
    LDeviceName: TLabel;
    LSpecVersion: TLabel;
    LDriverVersion: TLabel;
    LSize: TLabel;
    LDriverExtra: TLabel;
    LFields: TLabel;
    LDVOrientation: TLabel;
    LPaperSize: TLabel;
    LPaperLength: TLabel;
    LPaperWidth: TLabel;
    LScale: TLabel;
    LCopies: TLabel;
    LDefaultSource: TLabel;
    LPrintQuality: TLabel;
    LColor: TLabel;
    LDuplex: TLabel;
	 LTTOption: TLabel;
	 LYResolution: TLabel;
    CBPaperSize: TComboBox;
    CBSource: TComboBox;
    Label2: TLabel;
	 Label3: TLabel;
    GroupBox3: TGroupBox;
	 LBBins: TListBox;
	 LBins: TLabel;
    LDCCopies: TLabel;
    LDCDriver: TLabel;
    LResolutions: TLabel;
    LBRes: TListBox;
    LDCEXTRA: TLabel;
    LDCFIELDS: TLabel;
    LDCEnumFiles: TLabel;
    LBFiles: TListBox;
    LDCMAXEXTENT: TLabel;
    LDCMinExtent: TLabel;
    LDCDuplex: TLabel;
    LDCORIENTATION: TLabel;
	 LBPapers: TListBox;
    LDCPaperNames: TLabel;
    LDCSize: TLabel;
    LDCTrueType: TLabel;
	 LDCVERSION: TLabel;
    LSizePalette: TLabel;
    LNumReserved: TLabel;
    LColorRes: TLabel;
    Label8: TLabel;
    LBRaster: TListBox;
    Label13: TLabel;
    LBCurve: TListBox;
    Label14: TLabel;
    LBLine: TListBox;
    Label15: TLabel;
    LBPoly: TListBox;
    Label16: TLabel;
    LBText: TListBox;
    GroupBox6: TGroupBox;
    LGetFaceName: TLabel;
    LPhysPageSize: TLabel;
    LGetPrintingOffset: TLabel;
    LGetScalingFactor: TLabel;
    LGetTechnology: TLabel;
    LGetVectorBrushSize: TLabel;
    LGetVectorPenSize: TLabel;
    LGetSetScreenParams: TLabel;
    LOrientation: TLabel;
	 LCopyright: TLabel;
	 procedure FormCreate(Sender: TObject);
	 procedure LBPrinterClick(Sender: TObject);
	 procedure LCopyrightClick(Sender: TObject);
  private
	 procedure RefreshGetDeviceCaps;
	 procedure RefreshDeviceCapabilities;
	 procedure RefreshDevMode;
	 procedure RefreshEscape;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
	LBPrinter.Items := Printer.Printers;
	MessageDlg('Dieser Dialog gibt eine bersicht ber all die Daten, die ber fnf verschiedene Verfahren'+
				  ' ber den Drucker zu bekommen sind.'#13#10'Viel Spa - Michael [100120,2601]', mtInformation, [mbOK], 0);
end;

procedure TForm1.RefreshGetDeviceCaps;
Var	Ergebnis	: Integer;
begin
	{ GetDeviceCaps-Infos }
	LVersion.Caption := 'Version : '+IntToStr(GetDeviceCaps(Printer.Handle, DRIVERVERSION));
	case GetDeviceCaps(Printer.Handle, TECHNOLOGY) of
		DT_PLOTTER		: LTech.Caption := 'Technologie : Plotter';
		DT_RASDISPLAY	: LTech.Caption := 'Technologie : RasterDisplay';
		DT_RASPRINTER	: LTech.Caption := 'Technologie : RasterPrinter';
		DT_RASCAMERA	: LTech.Caption := 'Technologie : RasterCamera';
		DT_CHARSTREAM	: LTech.Caption := 'Technologie : ZeichenStrom';
		DT_METAFILE		: LTech.Caption := 'Technologie : Metafile';
		DT_DISPFILE		: LTech.Caption := 'Technologie : Bildschirm-Datei';
	end;
	LHorzSize.Caption := 'HorzSize : '+IntToStr(GetDeviceCaps(Printer.Handle, HORZSIZE));
	LVertSize.Caption := 'VertSize : '+IntToStr(GetDeviceCaps(Printer.Handle, VERTSIZE));
	LHorzRes.Caption := 'HorzRes : '+IntToStr(GetDeviceCaps(Printer.Handle, HORZRES));
	LVertRes.Caption := 'VertRes : '+IntToStr(GetDeviceCaps(Printer.Handle, VERTRES));
	LLogPixelsX.Caption := 'LogPixelsX : '+IntToStr(GetDeviceCaps(Printer.Handle, LogPixelsX));
	LLogPixelsY.Caption := 'LogPixelsY : '+IntToStr(GetDeviceCaps(Printer.Handle, LogPixelsY));
	LBitsPixel.Caption := 'BitsPixel : '+IntToStr(GetDeviceCaps(Printer.Handle, BITSPIXEL));
	LPlanes.Caption := 'Planes : '+IntToStr(GetDeviceCaps(Printer.Handle, Planes));
	LNumBrushes.Caption := 'NumBrushes : '+IntToStr(GetDeviceCaps(Printer.Handle, NumBrushes));
	LNumPens.Caption := 'NumPens : '+IntToStr(GetDeviceCaps(Printer.Handle, NumPens));
	LNumMarkers.Caption := 'NumMarkers : '+IntToStr(GetDeviceCaps(Printer.Handle, NumMarkers));
	LNumFonts.Caption := 'NumFonts : '+IntToStr(GetDeviceCaps(Printer.Handle, NumFonts));
	LNumColors.Caption := 'NumColors : '+IntToStr(GetDeviceCaps(Printer.Handle, NumColors));
	LAspectX.Caption := 'AspectX : '+IntToStr(GetDeviceCaps(Printer.Handle, AspectX));
	LAspectY.Caption := 'AspectY : '+IntToStr(GetDeviceCaps(Printer.Handle, AspectY));
	LAspectXY.Caption := 'AspectXY : '+IntToStr(GetDeviceCaps(Printer.Handle, AspectXY));
	LPDeviceSize.Caption := 'PDeviceSize : '+IntToStr(GetDeviceCaps(Printer.Handle, PDeviceSize));
	case GetDeviceCaps(Printer.Handle, CLIPCAPS) of
		CP_NONE			: LClipping.Caption := 'Clipping : Keine';
		CP_RECTANGLE	: LClipping.Caption := 'Clipping : Rectangle';
		CP_REGION		: LClipping.Caption := 'Clipping : Region';
	end;
	LSizePalette.Caption := 'SizePalette : '+IntToStr(GetDeviceCaps(Printer.Handle, SizePalette));
	LNumReserved.Caption := 'NumReserved : '+IntToStr(GetDeviceCaps(Printer.Handle, NumReserved));
	LColorRes.Caption := 'ColorRes : '+IntToStr(GetDeviceCaps(Printer.Handle, ColorRes));
	Ergebnis := GetDeviceCaps(Printer.Handle, RASTERCAPS);
	LBRaster.Items.Clear;
	if (Ergebnis and RC_BANDING)<>0 then
		LBRaster.Items.Add('RC_BANDING');
	if (Ergebnis and RC_BIGFONT)<>0 then
		LBRaster.Items.Add('RC_BIGFONT');
	if (Ergebnis and RC_BITBLT)<>0 then
		LBRaster.Items.Add('RC_BITBLT');
	if (Ergebnis and RC_BITMAP64)<>0 then
		LBRaster.Items.Add('RC_BITMAP64');
	if (Ergebnis and RC_DEVBITS)<>0 then
		LBRaster.Items.Add('RC_DEVBITS');
	if (Ergebnis and RC_DI_BITMAP)<>0 then
		LBRaster.Items.Add('RC_DI_BITMAP');
	if (Ergebnis and RC_DIBTODEV)<>0 then
		LBRaster.Items.Add('RC_DIBTODEV');
	if (Ergebnis and RC_FLOODFILL)<>0 then
		LBRaster.Items.Add('RC_FLOODFILL');
	if (Ergebnis and RC_GDI20_OUTPUT)<>0 then
		LBRaster.Items.Add('RC_GDI20_OUTPUT');
	if (Ergebnis and RC_GDI20_STATE)<>0 then
		LBRaster.Items.Add('RC_GDI20_STATE');
	if (Ergebnis and RC_OP_DX_OUTPUT)<>0 then
		LBRaster.Items.Add('RC_OP_DX_OUTPUT');
	if (Ergebnis and RC_PALETTE)<>0 then
		LBRaster.Items.Add('RC_PALETTE');
	if (Ergebnis and RC_SAVEBITMAP)<>0 then
		LBRaster.Items.Add('RC_SAVEBITMAP');
	if (Ergebnis and RC_SCALING)<>0 then
		LBRaster.Items.Add('RC_SCALING');
	if (Ergebnis and RC_STRETCHBLT)<>0 then
		LBRaster.Items.Add('RC_STRETCHBLT');
	if (Ergebnis and RC_STRETCHDIB)<>0 then
		LBRaster.Items.Add('RC_STRETCHDIB');
	Ergebnis := GetDeviceCaps(Printer.Handle, CURVECAPS);
	LBCurve.Items.Clear;
	if (Ergebnis and CC_NONE)<>0 then
		LBCurve.Items.Add('CC_NONE');
	if (Ergebnis and CC_CIRCLES)<>0 then
		LBCurve.Items.Add('CCC_CIRCLES');
	if (Ergebnis and CC_PIE)<>0 then
		LBCurve.Items.Add('CCC_PIE');
	if (Ergebnis and CC_CHORD)<>0 then
		LBCurve.Items.Add('CCC_CHORD');
	if (Ergebnis and CC_ELLIPSES)<>0 then
		LBCurve.Items.Add('CCC_ELLIPSES');
	if (Ergebnis and CC_WIDE)<>0 then
		LBCurve.Items.Add('CCC_WIDE');
	if (Ergebnis and CC_STYLED)<>0 then
		LBCurve.Items.Add('CCC_STYLED');
	if (Ergebnis and CC_WIDESTYLED)<>0 then
		LBCurve.Items.Add('CCC_WIDESTYLED');
	if (Ergebnis and CC_INTERIORS)<>0 then
		LBCurve.Items.Add('CCC_INTERIORS');
	if (Ergebnis and CC_ROUNDRECT)<>0 then
		LBCurve.Items.Add('CCC_ROUNDRECT');
	Ergebnis := GetDeviceCaps(Printer.Handle, LINECAPS);
	LBLine.Items.Clear;
	if (Ergebnis and LC_NONE)<>0 then
		LBLine.Items.Add('LC_NONE');
	if (Ergebnis and LC_POLYLINE)<>0 then
		LBLine.Items.Add('LC_POLYLINE');
	if (Ergebnis and LC_MARKER)<>0 then
		LBLine.Items.Add('LC_MARKER');
	if (Ergebnis and LC_POLYMARKER)<>0 then
		LBLine.Items.Add('LC_POLYMARKER');
	if (Ergebnis and LC_WIDE)<>0 then
		LBLine.Items.Add('LC_WIDE');
	if (Ergebnis and LC_STYLED)<>0 then
		LBLine.Items.Add('LC_STYLED');
	if (Ergebnis and LC_WIDESTYLED)<>0 then
		LBLine.Items.Add('LC_WIDESTYLED');
	if (Ergebnis and LC_INTERIORS)<>0 then
		LBLine.Items.Add('LC_INTERIORS');
	Ergebnis := GetDeviceCaps(Printer.Handle, POLYGONALCAPS);
	LBPoly.Items.Clear;
	if (Ergebnis and PC_POLYGON)<>0 then
		LBPoly.Items.Add('LPC_POLYGON');
	if (Ergebnis and PC_RECTANGLE)<>0 then
		LBPoly.Items.Add('LPC_RECTANGLE');
	if (Ergebnis and PC_WINDPOLYGON)<>0 then
		LBPoly.Items.Add('LPC_WINDPOLYGON');
	if (Ergebnis and PC_SCANLINE)<>0 then
		LBPoly.Items.Add('LPC_SCANLINE');
	if (Ergebnis and PC_WIDE)<>0 then
		LBPoly.Items.Add('LPC_WIDE');
	if (Ergebnis and PC_STYLED)<>0 then
		LBPoly.Items.Add('LPC_STYLED');
	if (Ergebnis and PC_WIDESTYLED)<>0 then
		LBPoly.Items.Add('LPC_WIDESTYLED');
	if (Ergebnis and PC_INTERIORS)<>0 then
		LBPoly.Items.Add('LPC_INTERIORS');
	Ergebnis := GetDeviceCaps(Printer.Handle, TEXTCAPS);
	LBText.Items.Clear;
	if (Ergebnis and TC_OP_CHARACTER)<>0 then
		LBText.Items.Add('TC_OP_CHARACTER');
	if (Ergebnis and TC_OP_STROKE)<>0 then
		LBText.Items.Add('TC_OP_STROKE');
	if (Ergebnis and TC_CP_STROKE)<>0 then
		LBText.Items.Add('TC_OP_STROKE');
	if (Ergebnis and TC_CR_90)<>0 then
		LBText.Items.Add('TC_CR_90');
	if (Ergebnis and TC_CR_ANY)<>0 then
		LBText.Items.Add('TC_CR_ANY');
	if (Ergebnis and TC_SF_X_YINDEP)<>0 then
		LBText.Items.Add('TC_SF_X_YINDEP');
	if (Ergebnis and TC_SA_DOUBLE)<>0 then
		LBText.Items.Add('TC_SA_DOUBLE');
	if (Ergebnis and TC_SA_INTEGER)<>0 then
		LBText.Items.Add('TC_SA_INTEGER');
	if (Ergebnis and TC_SA_CONTIN)<>0 then
		LBText.Items.Add('TC_SA_CONTIN');
	if (Ergebnis and TC_EA_DOUBLE)<>0 then
		LBText.Items.Add('TC_EA_DOUBLE');
	if (Ergebnis and TC_IA_ABLE)<>0 then
		LBText.Items.Add('TC_IA_ABLE');
	if (Ergebnis and TC_UA_ABLE)<>0 then
		LBText.Items.Add('TC_UA_ABLE');
	if (Ergebnis and TC_SO_ABLE)<>0 then
		LBText.Items.Add('TC_SO_ABLE');
	if (Ergebnis and TC_RA_ABLE)<>0 then
		LBText.Items.Add('TC_RA_ABLE');
	if (Ergebnis and TC_VA_ABLE)<>0 then
		LBText.Items.Add('TC_VA_ABLE');
end;

procedure TForm1.RefreshDevMode;
var	P : PDevMode;
		Device, Name, Port	: array[0..100] of Char;
		DevModeHandle			: THandle;
		PrintLibHandle			: THandle;
		EDevMode					: TExtDevMode;		{ Unit PRINT.PAS nicht WINTYPES!!!}
		StubDevMode				: PDevMode;
		TempTDevMode			: Boolean;
begin
	{ prfen, ob Struktur berhaupt existiert }
	TempTDevMode:= False;
	Printer.GetPrinter(Device, Name, Port, DevModeHandle);
	P := Ptr(DevModeHandle, 0);			{ Zeiger auf Struktur holen }
	if P=NIL then begin
   	{ eigene temporre Struktur anfordern }
		LDeviceName.Caption := 'Keine DevMode-Struktur initialisiert!';
		PrintLibHandle := LoadLibrary(Name);
		{ Sicherheitsabfrage }
		if PrintLibHandle<HINSTANCE_ERROR then begin
			LDeviceName.Caption := 'Library '+StrPas(Name)+' nicht geladen!';
			exit;
		end;
		@EDevMode := GetProcAddress(PrintLibHandle, 'ExtDeviceMode');
		{ Sicherheitsabfrage }
		if @EDevMode=NIL then begin
			LDeviceName.Caption := 'Funktion "ExtDeviceMode" im Treiber '+StrPas(Name)+' nicht implementiert!';
			exit;
		end;
		DevModeHandle := GlobalAlloc(HeapAllocFlags or GMEM_ZEROINIT,
											  EDevMode(0, PrintLibHandle, StubDevMode, Device, Port, StubDevMode, nil, 0));
		if DevModeHandle<>0 then begin
			P := Ptr(DevModeHandle, 0);
			{ mit anderen Werten fr DM_OUT_BUFFER kann man Drucker-Daten setzen! }
			if EDevMode(0, PrintLibHandle, P, Device, Port, P, nil, DM_OUT_BUFFER)<0 then begin
				GlobalFree(DevModeHandle);
				DevModeHandle := 0;
				LDeviceName.Caption := 'Erzeugung einer eigenen TDEVMODE-Struktur fehlgeschlagen!';
				exit;
			end
			else TempTDevMode := True;
		end
		else LDeviceName.Caption := 'Speicheranforderung fr DeviceMode-Struktur fehlgeschlagen!';
	end;
	{ jetzt Struktur auswerten }
	LDeviceName.Caption := 'dmDeviceName : '+P^.dmDeviceName;
	LSpecVersion.Caption := 'dmSpecVersion : '+IntToStr(P^.dmSpecVersion);
	LDriverVersion.Caption := 'dmDriverVersion : '+IntToStr(P^.dmDriverVersion);
	LSize.Caption := 'dmSize : '+IntToStr(P^.dmSize);
	LDriverExtra.Caption := 'dmDriverExtra : '+IntToStr(P^.dmDriverExtra);
	LFields.Caption := 'dmFields : '+IntToStr(P^.dmFields);
	if (P^.dmFields and dm_Orientation)=0 then
		LDVOrientation.Font.Color := clGray
	else LDVOrientation.Font.Color := clWindowText;
	if (P^.dmFields and dm_PaperSize)=0 then
		LPaperSize.Font.Color := clGray
	else LPaperSize.Font.Color := clWindowText;
	if (P^.dmFields and dm_PaperLength)=0 then
		LPaperLength.Font.Color := clGray
	else LPaperLength.Font.Color := clWindowtext;
	if (P^.dmFields and dm_PaperWidth)=0 then
		LPaperWidth.Font.Color := clGray
	else LPaperWidth.Font.Color := clWindowtext;
	if (P^.dmFields and dm_Scale)=0 then
		LScale.Font.Color := clGray
	else LScale.Font.Color := clWindowtext;
	if (P^.dmFields and dm_Copies)=0 then
		LCopies.Font.Color := clGray
	else LCopies.Font.Color := clWindowtext;
	if (P^.dmFields and dm_DefaultSource)=0 then
		LDefaultSource.Font.Color := clGray
	else LDefaultSource.Font.Color := clWindowtext;
	if (P^.dmFields and dm_PrintQuality)=0 then
		LPrintQuality.Font.Color := clGray
	else LPrintQuality.Font.Color := clWindowtext;
	if (P^.dmFields and dm_Color)=0 then
		LColor.Font.Color := clGray
	else LColor.Font.Color := clWindowtext;
	if (P^.dmFields and dm_Duplex)=0 then
		LDuplex.Font.Color := clGray
	else LDuplex.Font.Color := clWindowtext;
	if (P^.dmFields and dm_YResolution)=0 then
		LYResolution.Font.Color := clGray
	else LYResolution.Font.Color := clWindowtext;
	if (P^.dmFields and dm_TTOption)=0 then
		LTTOption.Font.Color := clGray
	else LTTOption.Font.Color := clWindowtext;
	LDVOrientation.Caption := 'dmOrientation : '+IntToStr(P^.dmOrientation);
	if P^.dmOrientation=1 then
		LDVOrientation.Caption := LDVOrientation.Caption+' = Portrait'
	else LDVOrientation.Caption := LDVOrientation.Caption+' = Landscape';
	LPaperSize.Caption := 'dmPaperSize : '+IntToStr(P^.dmPaperSize);
	CBPaperSize.ItemIndex := P^.dmPaperSize;
	LPaperLength.Caption := 'dmPaperLength : '+IntToStr(P^.dmPaperLength);
	LPaperWidth.Caption := 'dmPaperWidth : '+IntToStr(P^.dmPaperWidth);
	LScale.Caption := 'dmScale : '+IntToStr(P^.dmScale)+'/100';
	LCopies.Caption := 'dmCopies : '+IntToStr(P^.dmCopies);
	LDefaultSource.Caption := 'dmDefaultSource : '+IntToStr(P^.dmDefaultSource);
	CBSource.ItemIndex := P^.dmDefaultSource;
	LPrintQuality.Caption := 'dmPrintQuality : '+IntToStr(P^.dmPrintQuality);
	case P^.dmPrintQuality of
		-4 : LPrintQuality.Caption := LPrintQuality.Caption+' = High';
		-3 : LPrintQuality.Caption := LPrintQuality.Caption+' = Medium';
		-2 : LPrintQuality.Caption := LPrintQuality.Caption+' = Low';
		-1 : LPrintQuality.Caption := LPrintQuality.Caption+' = Draft';
	end;
	LColor.Caption := 'dmColor : '+IntToStr(P^.dmColor);
	if P^.dmColor=2 then						{ Achtung: Fehler in der Online-Hilfe! }
		LColor.Caption := LColor.Caption+' = Color'
	else LColor.Caption := LColor.Caption+' = Monochrom';
	LDuplex.Caption := 'dmDuplex : '+IntToStr(P^.dmDuplex);
	case P^.dmDuplex of
		1	: LDuplex.Caption := LDuplex.Caption+' = Simplex';
		2	: LDuplex.Caption := LDuplex.Caption+' = Horizontal';
		3	: LDuplex.Caption := LDuplex.Caption+' = Vertikal';
	end;
	LYResolution.Caption := 'dmYResolution : '+IntToStr(P^.dmYResolution);
	LTTOption.Caption := 'dmTTOption : '+IntToStr(P^.dmTTOption);
	case P^.dmTTOption of
		DMTT_BITMAP: LTTOption.Caption := LTTOption.Caption+' = als Grafik';
		DMTT_DOWNLOAD: LTTOption.Caption := LTTOption.Caption+' = per Download';
		DMTT_SUBDEV: LTTOption.Caption := LTTOption.Caption+' = Ersatzschriftart';
	end;
	if TempTDevMode then					{ temporre Struktur wieder freigeben }
		GlobalFree(DevModeHandle);
end;

procedure TForm1.RefreshDeviceCapabilities;
type	XPoint	= record
							case integer of
								0	: (Wert : LongInt);
								1	: (x, y : Word);
							end;
var	Puf						: String;
		DevCaps					: TDevCaps;
		Device, Name, Port	: array[0..100] of Char;
		DevModeHandle			: THandle;
		PrintLibHandle			: THandle;
		Ergebnis, D1, D2		: LongInt;
		Puffer					: array[0..6400] of Char;
		Zeiger					: PChar;
		i							: Integer;
		iZeiger					: PLONGINT;
		Point						: XPoint;
begin
	Printer.GetPrinter(Device, Name, Port, DevModeHandle);
	PrintLibHandle	:= LoadLibrary(Name);
	{ Sicherheitsabfrage }
	if PrintLibHandle<HINSTANCE_ERROR then begin
		GroupBox3.Caption := 'Library '+StrPas(Name)+' nicht geladen!';
		exit;
	end;
	@DevCaps := GetProcAddress(PrintLibHandle, 'DeviceCapabilities');
	{ Sicherheitsabfrage }
	if @DevCaps=NIL then begin
		GroupBox3.Caption := 'Funktion "DeviceCapabilities" im Treiber '+StrPas(Name)+' nicht implementiert!';
		exit;
	end;
{	DeviceCapabilities = function(DeviceName, Port: PChar; Index: Word;
											Output: PChar; DevMode : PDevMode): Longint; }
	Ergebnis := DevCaps(Name, Port, DC_BinNames, NIL, Ptr(DevModeHandle, 0));
	LBins.Caption := 'DC_BinNames : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_BinNames, @Puffer, Ptr(DevModeHandle, 0));
	Zeiger := Puffer;
	LBBins.Items.Clear;
	for i:=1 to Ergebnis do begin
		LBBins.Items.Add(StrPas(Zeiger));
		inc(Zeiger, 24);
	end;
	Ergebnis := DevCaps(Name, Port, DC_Copies, NIL, Ptr(DevModeHandle, 0));
	LDCCopies.Caption := 'DC_Copies : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_Driver, NIL, Ptr(DevModeHandle, 0));
	LDCDriver.Caption := 'DC_Driver : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_Duplex, NIL, Ptr(DevModeHandle, 0));
	LDCDuplex.Caption := 'DC_Duplex : '+IntToStr(Ergebnis);
	if Ergebnis=1 then
		LDCDuplex.Caption := LDCDuplex.Caption+' = Ja'
	else LDCDuplex.Caption := LDCDuplex.Caption+' = Nein';
	Ergebnis := DevCaps(Name, Port, DC_ENUMRESOLUTIONS, NIL, Ptr(DevModeHandle, 0));
	LResolutions.Caption := 'DC_EnumResolutions : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_ENUMRESOLUTIONS, @Puffer, Ptr(DevModeHandle, 0));
	iZeiger := PLONGINT(@Puffer);
	LBRes.Items.Clear;
	for i:=1 to Ergebnis do begin
		D1 := iZeiger^;
		inc(iZeiger);
		D2 := iZeiger^;
		inc(iZeiger);
		LBRes.Items.Add(IntToStr(D1)+' x '+IntToStr(D2));
	end;
	Ergebnis := DevCaps(Name, Port, DC_EXTRA, NIL, Ptr(DevModeHandle, 0));
	LDCEXTRA.Caption := 'DC_Extra : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_FIELDS, NIL, Ptr(DevModeHandle, 0));
	LDCFIELDS.Caption := 'DC_Fields : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_FILEDEPENDENCIES, NIL, Ptr(DevModeHandle, 0));
	LDCEnumFiles.Caption := 'DC_FileDependencies : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_FILEDEPENDENCIES, @Puffer, Ptr(DevModeHandle, 0));
	Zeiger := Puffer;
	LBFiles.Items.Clear;
	for i:=1 to Ergebnis do begin
		LBFiles.Items.Add(StrPas(Zeiger));
		inc(Zeiger, 64);
	end;
	Ergebnis := DevCaps(Name, Port, DC_MAXEXTENT, NIL, Ptr(DevModeHandle, 0));
	Point.Wert := Ergebnis;
	LDCMAXEXTENT.Caption := 'DC_MaxExtent : '+IntToStr(Point.x)+' x '+IntToStr(Point.y);
	Ergebnis := DevCaps(Name, Port, DC_MinEXTENT, NIL, Ptr(DevModeHandle, 0));
	Point.Wert := Ergebnis;
	LDCMinEXTENT.Caption := 'DC_MinExtent : '+IntToStr(Point.x)+' x '+IntToStr(Point.y);

	Ergebnis := DevCaps(Name, Port, DC_ORIENTATION, NIL, Ptr(DevModeHandle, 0));
	LDCORIENTATION.Caption := 'DC_Orientation : '+IntToStr(Ergebnis);
	case Ergebnis of
		0		: LDCORIENTATION.Caption := LDCORIENTATION.Caption+' = Keine';
		90		: LDCORIENTATION.Caption := LDCORIENTATION.Caption+' = 90-Drehung (z.B. HP)';
		270	: LDCORIENTATION.Caption := LDCORIENTATION.Caption+' = 270-Drehung (z.B. Matrix)';
	end;
	Ergebnis := DevCaps(Name, Port, DC_PAPERNAMES, NIL, Ptr(DevModeHandle, 0));
	LDCPAPERNAMES.Caption := 'DC_PaperNames : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_PAPERNAMES, @Puffer, Ptr(DevModeHandle, 0));
	Zeiger := Puffer;
	LBPapers.Items.Clear;
	for i:=1 to Ergebnis do begin
		LBPapers.Items.Add(StrPas(Zeiger));
		inc(Zeiger, 64);
	end;
	{FEHLT HIER, DA MAE BEI DC_PAPERNAMES AUCH ANGEZEIGT WERDEN: DC_PAPERSIZE
	kopiert die Mae der untersttzten Papierformate in zehntel Millimeter-Einheiten
	in ein Array von TPOINT-Strukturen in Output. Die Breite (x-Dimension) und Hhe
	(y-Dimension) einer Papiergre werden zurckgegeben, als ob das Papier der
	DMORIENT_PORTRAIT Orientierung entsprche.}
	Ergebnis := DevCaps(Name, Port, DC_SIZE, NIL, Ptr(DevModeHandle, 0));
	LDCSize.Caption := 'DC_Size : '+IntToStr(Ergebnis);
	Ergebnis := DevCaps(Name, Port, DC_TRUETYPE, NIL, Ptr(DevModeHandle, 0));
	LDCTrueType.Caption := 'DC_TrueType : '+IntToStr(Ergebnis);
	if (Ergebnis and DCTT_BITMAP)<>0 then
		LDCTrueType.Caption := LDCTrueType.Caption+' = BMP';
	if (Ergebnis and DCTT_DOWNLOAD)<>0 then
		LDCTrueType.Caption := LDCTrueType.Caption+' = DL';
	if (Ergebnis and DCTT_SUBDEV)<>0 then
		LDCTrueType.Caption := LDCTrueType.Caption+' = Ersatz';
	Ergebnis := DevCaps(Name, Port, DC_VERSION, NIL, Ptr(DevModeHandle, 0));
	LDCVERSION.Caption := 'DC_Version : '+IntToStr(Ergebnis);
end;

procedure TForm1.RefreshEscape;
var	Wert		: Integer;
		Name		: array[0..60] of Char;
		Point		: TPoint;
begin
	Wert := GetFaceName;
	if Escape(Printer.Handle, QueryEscSupport, sizeof(Integer), @Wert, NIL)>0 then begin
		LGetFaceName.Font.Color := clBlack;
		Escape(Printer.Handle, GetFaceName, 0, NIL, @Name[0]);
		LGetFaceName.Caption := 'GetFaceName :'+StrPas(Name);
	end
	else	LGetFaceName.Font.Color := clGray;
	Wert := GetPhysPageSize;
	if Escape(Printer.Handle, QueryEscSupport, sizeof(Integer), @Wert, NIL)>0 then begin
		LPhysPageSize.Font.Color := clBlack;
		Escape(Printer.Handle, GetPhysPageSize, 0, NIL, @Point);
		LPhysPageSize.Caption := 'GetPhysPageSize B:'+IntToStr(Point.x)+' - H:'+IntToStr(Point.y)
	end
	else	LPhysPageSize.Font.Color := clGray;
	Wert := GetPrintingOffset;
	if Escape(Printer.Handle, QueryEscSupport, sizeof(Integer), @Wert, NIL)>0 then begin
		LGetPrintingOffset.Font.Color := clBlack;
		Escape(Printer.Handle, GetPrintingOffset, 0, NIL, @Point);
		LGetPrintingOffset.Caption := 'GetPrintingOffset x:'+IntToStr(Point.x)+' - y:'+IntToStr(Point.y)
	end
	else	LGetPrintingOffset.Font.Color := clGray;
	Wert := GetScalingFactor;
	if Escape(Printer.Handle, QueryEscSupport, sizeof(Integer), @Wert, NIL)>0 then begin
		LGetScalingFactor.Font.Color := clBlack;
		Escape(Printer.Handle, GetScalingFactor, 0, NIL, @Name[0]);
		LGetScalingFactor.Caption := 'GetScalingFactor x: 2^'+IntToStr(Point.x)+' - y: 2^'+IntToStr(Point.y);
	end
	else	LGetScalingFactor.Font.Color := clGray;
	Wert := GetTechnology;
	if Escape(Printer.Handle, QueryEscSupport, sizeof(Integer), @Wert, NIL)>0 then begin
		LGetTechnology.Font.Color := clBlack;
		Escape(Printer.Handle, GetTechnology, 0, NIL, @Name[0]);
		LGetTechnology.Caption := 'GetTechnology :'+StrPas(Name);
	end
	else	LGetTechnology.Font.Color := clGray;
	Wert := GetVectorBrushSize;
	if Escape(Printer.Handle, QueryEscSupport, sizeof(Integer), @Wert, NIL)>0 then begin
		LGetVectorBrushSize.Font.Color := clBlack;
		Escape(Printer.Handle, GetVectorBrushSize, 0, NIL, @Point);
		LGetVectorBrushSize.Caption := 'GetVectorBrushSize :'+IntToStr(Point.y);
	end
	else	LGetVectorBrushSize.Font.Color := clGray;
	Wert := GetVectorPenSize;
	if Escape(Printer.Handle, QueryEscSupport, sizeof(Integer), @Wert, NIL)>0 then begin
		LGetVectorPenSize.Color := clBlack;
		Escape(Printer.Handle, GetVectorPenSize, 0, NIL, @Point);
		LGetVectorPenSize.Caption := 'GetVectorPenSize :'+IntToStr(Point.y);
	end
	else	LGetVectorPenSize.Font.Color := clGray;
	Wert := GetSetScreenParams;
	if Escape(Printer.Handle, QueryEscSupport, sizeof(Integer), @Wert, NIL)>0 then begin
		LGetSetScreenParams.Font.Color := clBlack;
		Escape(Printer.Handle, GetSetScreenParams, 0, NIL, @Point);
		LGetSetScreenParams.Caption := 'GetSetScreenParams Angle:'+IntToStr(INTEGER(Point.x))+
												 ' - Frequency:'+IntToStr(INTEGER(Point.y));
	end
	else	LGetSetScreenParams.Font.Color := clGray;
end;

procedure TForm1.LBPrinterClick(Sender: TObject);
Const	What	: array[0..1] of String = ('True', 'False');
Var	Offset	: WINTYPES.TPoint;
		Device, Name, Port	: array[0..100] of Char;
		PPuf		: PChar;
		DevMode	: THandle;
begin
	Printer.PrinterIndex := LBPrinter.itemindex;
	TabbedNotebook1.Enabled := True;
{	Printer.BeginDoc; UNNTIG! }

	{ Erst die Daten, die man aus der Printer-Unit herausholen kann }
	Printer.GetPrinter(Device, Name, Port, DevMode);
	LDevice.Caption := 'Device : '+StrPas(Device);
	LName.Caption := 'Name : '+StrPas(Name);
	LPort.Caption := 'Port : '+StrPas(Port);
	Label9.Caption := 'Aborted ist '+What[ord(Printer.Aborted)];
	ListBox2.Items := Printer.Fonts;
	Edit2.Text := IntToStr(Printer.PageHeight);
	Edit1.Text := IntToStr(Printer.PageWidth);
	Edit3.Text := FloatToStr(Printer.PageWidth/300*2.54);
	Edit4.Text := FloatToStr(Printer.PageHeight/300*2.54);
	{ Funktionierte erst irgendwie nicht... Studium der VCL-Sourcen brachte
	  die Lsung: vorher SetPrinter aufrufen! }
	Printer.SetPrinter(Device, Name, Port, 0);
	if Printer.Orientation=poPortrait then
		LOrientation.Caption := 'Ausrichtung ist Portrait'
	else LOrientation.Caption := 'Ausrichtung ist Landscape';
	Edit2.Text := IntToStr(Printer.PageHeight);
	Edit1.Text := IntToStr(Printer.PageWidth);
	Edit3.Text := FloatToStr(Printer.PageWidth/GetDeviceCaps(Printer.Handle, LogPixelsX)*2.54);
	Edit4.Text := FloatToStr(Printer.PageHeight/GetDeviceCaps(Printer.Handle, LogPixelsY)*2.54);
	Label11.Caption := 'Seiten-Nummer : '+IntToStr(Printer.PageNumber);
	Label12.Caption := 'Titel : '+Printer.Title;

	{ GetDeviceCaps-Funktion auswerten }
	RefreshGetDeviceCaps;
	{ DevMode-Struktur auswerten }
	RefreshDevMode;
	{ DeviceCapabilities auswerten }
	RefreshDeviceCapabilities;
	{ Escape auswerten }
	RefreshEscape;

{	Printer.Abort;       UNNTIG!
	Printer.EndDoc;
}
end;

procedure TForm1.LCopyrightClick(Sender: TObject);
begin
	Application.CreateForm(TAboutForm, AboutForm);
	AboutForm.ShowModal;
   AboutForm.Free;
end;

end.
