unit MainFrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Progress, Buttons, StdCtrls, Gauges, ExtCtrls;

{
  This project shows the use of the TProgressor and TProgressObserver classes.

  For more details about how to use these classes and examples look through
  the unit DemoOps and this unit MainFrm.
}

type
  TMainForm = class(TForm)
    StatusPanel: TPanel;
    ProgressPanel: TPanel;
    Gauge: TGauge;
    ProgressLabel: TLabel;
    StatusLine: TPanel;
    StatusLabel: TLabel;
    ToolBar: TPanel;
    RunBtn: TSpeedButton;
    CoarseObserver: TProgressObserver;
    AbortBtn: TSpeedButton;
    FineObserver: TProgressObserver;
    FineLabel: TLabel;
    procedure CoarseObserverDescriptionChange(Sender: TObject);
    procedure CoarseObserverProgressChange(Sender: TObject);
    procedure CoarseObserverFinish(Sender: TObject);
    procedure CoarseObserverStart(Sender: TObject);
    procedure RunBtnClick(Sender: TObject);
    procedure AbortBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FineObserverProgressChange(Sender: TObject);
  private
  public
  end;

var
  MainForm: TMainForm;

implementation

uses DemoOps;

{$R *.DFM}

procedure TMainForm.CoarseObserverDescriptionChange(Sender: TObject);
begin
  { Use the class function TProgressor.Instance to read the (changed) description
    We could also have called one of the observer's Description properties
    which simply wrap the TProgressor's description property }
  ProgressLabel.Caption := TProgressor.Instance.Description;
end;

procedure TMainForm.CoarseObserverProgressChange(Sender: TObject);
begin
  { Here we use one of the Observers to read the (changed) progress which
    wrap the TProgressor's Progress property.
    Also demonstrate the Accuracy property of the observers, the
    gauge is updated with accuracy of 10 percent }

  Gauge.Progress := CoarseObserver.Progress;
end;

procedure TMainForm.CoarseObserverFinish(Sender: TObject);
begin
  { Simply make the complete panel invisible when progress has finished.
    The align properties of the panels will take care of the rest }
  ProgressPanel.Visible := False;
end;

procedure TMainForm.CoarseObserverStart(Sender: TObject);
begin
  { Simply make the complete panel visible when progress starts.
    The align properties of the panels will take care of the rest }
  ProgressPanel.Visible := True;
end;

procedure TMainForm.RunBtnClick(Sender: TObject);
begin
  { avoid re-entrancy due to calls to Application.ProcessMessages by
    disabling the RunBtn while running.
    Protect this state with a try finally statement to make sure
    the RunBtn get's enabled again after the operation finished OR
    an exception was raised }
  RunBtn.Enabled := False;
  AbortBtn.Enabled := True;
  try

    Application.ProcessMessages;

    { Simulate action }
    LengthyOperation;

  finally
    { make sure to return to normal state again }
    RunBtn.Enabled := True;
    AbortBtn.Enabled := False;
  end;
end;

procedure TMainForm.AbortBtnClick(Sender: TObject);
begin
  { operation is aborted. The operations check the state of Aborted
    The progressor sets Aborted to False the first time StartProgress is called }
  CoarseObserver.Aborted := True;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  { Show hint in status line }
  Application.OnHint := ShowHint;
  ShowHint(Self);
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLabel.Caption := Application.Hint;
end;

procedure TMainForm.FineObserverProgressChange(Sender: TObject);
begin
  FineLabel.Caption := IntToStr(FineObserver.Progress);
end;

end.
