{
+----------------------------------------------------------------------------+
|                                                                          |
|                                                                       |
|                                                                      |
|                                                                       |
|                                                                       |
|                                                                    |
|                                                             |
|                                                        |
|                                                      |
|                       Copyright  1996-1997 by:  |
|                                                  |
|                           WHITE ANTS SYSTEMHOUSE BV  |
|                            Geleen 12                  |
|                                  8032 GB Zwolle             |
|                                        Netherlands                |
|                                                               |
|                                         Tel. +31 38 453 86 31      |
|                                              Fax. +31 38 453 41 22      |
|                                                                        |
|                                             www.whiteants.com          |
|                                            support@whiteants.com      |
|                                                                           |
+----------------------------------------------------------------------------+
  file     : IntLists
  version  : 1.0
  comment  : TIntList is an dynamic array of integers using a TList to store
             the integers
  author   : G. Beuze
  compiler : Delphi 1.0
+----------------------------------------------------------------------------+
| DISCLAIMER:                                                                |
| THIS SOURCE IS FREEWARE. YOU ARE ALLOWED TO USE IT IN YOUR OWN PROJECTS    |
| WITHOUT ANY RESTRICTIONS. YOU ARE NOT ALLOWED TO SELL THE SOURCE CODE.     |
| THERE IS NO WARRANTY AT ALL - YOU USE IT ON YOUR OWN RISC. WHITE ANTS DOES |
| NOT ASSUME ANY RESPONSIBILITY FOR ANY DAMAGE OR ANY LOSS OF TIME OR MONEY  |
| DUE THE USE OF ANY PART OF THIS SOURCE CODE.                               |
+----------------------------------------------------------------------------+
}
unit IntLists;

interface

uses Classes;

type
  TIntList = class(TObject)
  private
    FList: TList;
  protected
    function Get(Index: Integer): LongInt;
    function GetCount: Integer;
    procedure Put(Index: Integer; Item: LongInt);
    procedure SetCount(NewCount: Integer);
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Item: LongInt): Integer;
    procedure Clear;
    procedure Delete(Index: Integer);
    procedure Exchange(Index1, Index2: Integer);
    function IndexOf(Item: LongInt): Integer;
    procedure Insert(Index: Integer; Item: LongInt);
    procedure Move(CurIndex, NewIndex: Integer);
    function Remove(Item: LongInt): Integer;
    property Count: Integer read GetCount write SetCount;
    property Items[Index: Integer]: LongInt read Get write Put; default;
  end;


implementation

{ TIntList }

constructor TIntList.Create;
begin
  inherited Create;
  FList := TList.Create;
end;

destructor TIntList.Destroy;
begin
  FList.Free;
end;

function TIntList.Add(Item: LongInt): Integer;
begin
  FList.Add(Pointer(Item));
end;

procedure TIntList.Clear;
begin
  FList.Clear;
end;

procedure TIntList.Delete(Index: Integer);
begin
  FList.Delete(Index);
end;

procedure TIntList.Exchange(Index1, Index2: Integer);
begin
  FList.Exchange(Index1, Index2);
end;

function TIntList.Get(Index: Integer): LongInt;
begin
  Result := LongInt(FList[Index]);
end;

function TIntList.GetCount: Integer;
begin
  Result := FList.Count;
end;

function TIntList.IndexOf(Item: LongInt): Integer;
begin
  Result := FList.IndexOf(Pointer(Item));
end;

procedure TIntList.Insert(Index: Integer; Item: LongInt);
begin
  FList.Insert(Index, Pointer(Item));
end;

procedure TIntList.Move(CurIndex, NewIndex: Integer);
begin
  FList.Move(CurIndex, NewIndex);
end;

procedure TIntList.Put(Index: Integer; Item: LongInt);
begin
  FList[Index] := Pointer(Item);
end;

function TIntList.Remove(Item: LongInt): Integer;
begin
  Result := FList.Remove(Pointer(Item));
end;

procedure TIntList.SetCount(NewCount: Integer);
begin
  FList.Count := NewCount;
end;

end.
