unit DemoOps;

{ implements some demo operations which demonstrate the
  use of the TProgressor / TProgressObserver classes }
interface

procedure LengthyOperation;
{ The only thing LengthyOperation really does is wait for some time in some levels }


implementation

uses SysUtils, WinProcs, Forms, Progress;

{ delay approx ms milli seconds }
procedure Delay(Ms: LongInt);
var EndTime: LongInt;
begin
  EndTime := GetTickCount + MS;                       
  while GetTickCount < EndTime do Application.ProcessMessages;
end;

procedure SubOperation(Sub: Integer);
var I: Integer;
begin
  { start sub level of operation }
  TProgressor.Instance.StartProgress(0, Format('Running sub %d', [Sub]));
  try
    { protect again against exceptions which might cause us to remain busy forever }
    for I := 0 to 100 do
    begin
      { simulate activity }
      Delay(50);
      { update progress }
      TProgressor.Instance.Progress := I;
      { check is user aborted operation }
      if TProgressor.Instance.Aborted then
        Exit;
    end;
    Delay(50);
  finally
    { reset busy state }
    TProgressor.Instance.EndProgress;
  end;
end;

procedure LengthyOperation;
var I: Integer;
begin
  TProgressor.Instance.StartProgress(0, 'Running main loop');
  { protect progress with finally, or progress might remain busy forever
    if an exception is raised somewhere inside the operation }
  try
    for I := 0 to 3 do
    begin
      { simulate main loop level activity }
      Delay(500);

      { simulate sub activity }
      SubOperation(I);

      { check whether user aborted operation or closed application.
        Test this by closing the application while the operation is running }
      if TProgressor.Instance.Aborted then
      { exit will be caught by finally }
        Exit;
      { update progress }
      TProgressor.Instance.Progress := 25 * (I + 1);
    end;
    Delay(500);
  finally
    { reset busy state }
    TProgressor.Instance.EndProgress;
  end;
end;


end.
