unit Progrbar;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

const
  PBM_SETRANGE = WM_USER+1;
  PBM_SETPOS   = WM_USER+2;
  PBM_DELTAPOS = WM_USER+3;
  PBM_SETSTEP  = WM_USER+4;
  PBM_STEPIT   = WM_USER+5;

type
  TProgressBar = class(TWinControl)
  private
    iPos : Integer;
    iMin, iMax : Integer;
    iStep : Integer;

    procedure SetPosition (value : Integer);
    procedure SetMin (value : Integer);
    procedure SetMax (value : Integer);
    procedure SetStep (value : Integer);

  protected
    procedure CreateParams (var Params: TCreateParams); override;
    procedure CreateHandle; override;

  public
    constructor Create (AOwner : TComponent); override;
    procedure DeltaPos (delta : Integer);
    procedure StepIt;

  published
    property Position : Integer read iPos write SetPosition;
    property Min : Integer read iMin write SetMin;
    property Max : Integer read iMax write SetMax default 100;
    property Step : Integer read iStep write SetStep default 10;

    property Visible;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
  end;

procedure Register;

implementation

uses commctrl;

constructor TProgressbar.Create (AOwner : TComponent);
begin
  inherited Create (AOwner);
  iMax := 100;
  iStep := 10;
  Width := 200;
  Height := 30;
end;

procedure TProgressbar.CreateParams (var Params: TCreateParams);
begin
  InitCommonControls;
  inherited CreateParams(Params);
  CreateSubClass(Params, 'msctls_progress');
end;

procedure TProgressbar.CreateHandle;
begin
  inherited CreateHandle;
  if (iMin <> 0) or (iMax <> 100) then
    SendMessage (Handle, PBM_SETRANGE, 0, MAKELONG (iMin, iMax));

  if iPos <> 0 then
    SendMessage (Handle, PBM_SETPOS, iPos, 0);

  if iStep <> 10 then
    SendMessage (Handle, PBM_SETSTEP, iPos, 0);
end;

procedure TProgressBar.SetPosition (value : Integer);
begin
  if value <> iPos then
  begin
    iPos := value;
    SendMessage (handle, PBM_SETPOS, iPos, 0)
  end
end;

procedure TProgressBar.SetMin (value : Integer);
begin
  if value <> iMin then
  begin
    iMin := value;
    if iPos < iMin then iPos := iMin;
    SendMessage (handle, PBM_SETRANGE, 0, MAKELONG (iMin, iMax))
  end
end;

procedure TProgressBar.SetMax (value : Integer);
begin
  if value <> iMax then
  begin
    iMax := value;
    if iPos > iMax then iPos := iMax;
    SendMessage (handle, PBM_SETRANGE, 0, MAKELONG (iMin, iMax))
  end
end;

procedure TProgressBar.SetStep (value : Integer);
begin
  if value <> iStep then
  begin
    iStep := value;
    SendMessage (handle, PBM_SETSTEP, iStep, 0)
  end
end;

procedure TProgressBar.DeltaPos (delta : Integer);
begin
  SendMessage (handle, PBM_DELTAPOS, delta, 0)
end;

procedure TProgressBar.StepIt;
begin
  SendMessage (handle, PBM_STEPIT, 0, 0)
end;

procedure Register;
begin
  RegisterComponents('Windows95', [TProgressBar]);
end;

end.
