{*******************************************************}
{       TProgress & TLineList Demo for Delphi 1.0/3.0   }
{                                                       }
{       Copyright (c) 1997 Tibor F. Liska               }
{       Tel/Fax:    +36-1-165-2019                      }
{       Office:     +36-1-269-8284                      }
{       E-mail: liska@sztaki.hu                         }
{*******************************************************}
unit ProgTop;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin;

type
  TForm1 = class(TForm)
    cmCreate: TButton;
    cmProcess: TButton;
    cmClose: TButton;
    OpenDialog: TOpenDialog;
    Label1: TLabel;
    FileName: TLabel;
    Label2: TLabel;
    SpinEdit: TSpinEdit;
    cmProgress: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cmCreateClick(Sender: TObject);
    procedure cmProcessClick(Sender: TObject);
    procedure cmCloseClick(Sender: TObject);
    procedure cmProgressClick(Sender: TObject);
  private
      LineCount : Longint;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses ProgForm, LineList, Strings;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FileName.Caption := 'Not defined';
  cmProcess.Enabled := False;
  cmCreate.Enabled := True;
  SpinEdit.Enabled := True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if FileName.Caption <> 'Not defined' then
{$ifdef WIN32}
    DeleteFile(PChar(FileName.Caption));
{$else}
    DeleteFile(FileName.Caption);
{$endif}
end;

procedure TForm1.cmCreateClick(Sender: TObject);
  var
      i : Longint;
      Target : TStringList;
      OutFile : TFileStream;
begin
  if OpenDialog.Execute then
  try
    FileName.Caption := OpenDialog.FileName;
    Target := TStringList.Create;
    OutFile := TFileStream.Create(FileName.Caption, fmCreate);
    LineCount := SpinEdit.Value;

    Progress.Start('Create', LineCount); { Start progress }

    for i:=1 to LineCount do
    begin
      Progress.Step(1);                  { Step progress }
      Target.Add(IntToStr(i));
      if Target.Count > 1000 then
      begin
        Target.SaveToStream(OutFile);
        Target.Clear;
      end;
    end;
    Target.SaveToStream(OutFile);
    cmProcess.Enabled := True;
    cmCreate.Enabled := False;
    SpinEdit.Enabled := False;
  finally
    Progress.ShutUp;                     { Stop progress }
    Target.Free;
    OutFile.Free;
  end;
end;

procedure TForm1.cmProcessClick(Sender: TObject);
  var
      LineList : TLineList;
      Line : ShortString;
      i : Longint;
begin
  LineList := TLineList.Create(FileName.Caption, 25{6});
  try
    Progress.Start('Create', LineCount); { Start progress }

    for i:=1 to LineCount do
    begin
      Progress.Step(1);                  { Step progress }
      Line := LineList[0];

      { Process line ....}

      LineList.Delete(0);               { Line processed }
    end;
  finally
    Progress.ShutUp;                     { Stop progress }
    LineList.Free;
  end;
end;

procedure TForm1.cmProgressClick(Sender: TObject);
  var
      i, n : Integer;
begin
  n := 6000;
  try
    Progress.Start('Dummy progress', n); { Start progress }

    for i:=1 to n do
    begin
      Progress.Step1;                    { Step progress }

      { Do something ....}

    end;
  finally
    Progress.ShutUp;                     { Stop progress }
  end;
end;

procedure TForm1.cmCloseClick(Sender: TObject);
begin
    Close
end;

end.
