{*****************************************************}
{       TProgress 1.3 for Delphi 1.0/3.0              }
{                                                     }
{       Copyright (c) 1997 Tibor F. Liska             }
{       Tel/Fax:    +36-1-165-2019                    }
{       Office:     +36-1-269-8284                    }
{       E-mail: liska@sztaki.hu                       }
{*****************************************************}
unit ProgForm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Gauges, ExtCtrls, Strings;

type
  TProgress = class(TForm)
    Panel: TPanel;
    Gauge: TGauge;
    fdMax: TLabel;
    fdVal: TLabel;
    lbE1: TLabel;
    fdElapsed: TLabel;
    lbE2: TLabel;
    lbR1: TLabel;
    fdRest: TLabel;
    lbR2: TLabel;
    cmStop: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure cmStopClick(Sender: TObject);
    procedure AnyKey(Sender: TObject; var Key: Char);
  private
      Stopped : Boolean;
      StartTime : TDateTime;
      Caller : TForm;
  public
    procedure Start(Title: ShortString; Max: Longint);
    procedure ShutUp;
    procedure SetValue(Value: Longint);
    procedure Step(n: Longint);
    procedure Step1;
  end;

var
  Progress: TProgress;

implementation

{$R *.DFM}

procedure TProgress.FormCreate(Sender: TObject);
begin
  Stopped := False;
  Top := Screen.Height - Height;
  Left := Screen.Width - Width;
  LongTimeFormat := 'hh'+TimeSeparator+'mm'+TimeSeparator+'ss';
end;

procedure TProgress.cmStopClick(Sender: TObject);
begin
  Stopped := True;
end;

procedure TProgress.AnyKey(Sender: TObject; var Key: Char);
begin
  Key := #0;
  Stopped := True;
end;

procedure TProgress.Start(Title: ShortString; Max: Longint);
begin
  Caller := Screen.ActiveForm;
  if Caller.FormStyle = fsMDIChild then
     Caller := Application.MainForm;
  Caller.Enabled := False;
  if Title = '' then Caption := 'Copy'
                else Caption := Title;
  Gauge.Progress := 0;
{ Gauge.MinValue := 0; }
  Gauge.MaxValue := Max;
  fdMax.Caption := '/ ' + IntToStr(Max);
  StartTime := Now;
  Show;
end;

procedure TProgress.ShutUp;
begin
  if Caller <> nil then Caller.Enabled := True;
  Caller := nil;
  Hide;
end;

procedure TProgress.SetValue(Value: Longint);
  var
      Elapsed : TDateTime;
begin
  Application.ProcessMessages;
  if Stopped then
  begin
    Stopped := False;
    if idYes = MessageBox(Handle, 'Cancel progress?', ' ',
              mb_IconQuestion + mb_YesNo) then
      raise Exception.Create('Progress cancelled');
  end;
  Gauge.Progress := Value;
  fdVal.Caption := IntToStr(Value);
  Elapsed := Now - StartTime;
  fdElapsed.Caption :=  TimeToStr(Elapsed);
  if ((Value < 1000) and (Value <= Gauge.MaxValue div 10)) or
                         (Value >  Gauge.MaxValue) then
       fdRest.Caption :=  '??'+TimeSeparator+'??'+TimeSeparator+'??'
  else fdRest.Caption :=  TimeToStr(
         Elapsed * Gauge.MaxValue / Value - Elapsed);
  Application.ProcessMessages;
end;

procedure TProgress.Step(n: Longint);
begin
  SetValue(Gauge.Progress + n);
end;

procedure TProgress.Step1;
begin
  Step(1);
end;

end.
