# *******************************************************
# *                                                     *
# *     Pro VCL Extensions Library                      *
# *     MAKE script (version for C++Builder 1.0)        *
# *                                                     *
# *     Copyright (c) 1996-98 by Dmitry Barabash        *
# *                                                     *
# *******************************************************

# This MAKE script requires Borland MAKE Version 3.7 or later (MAKE.EXE),
# Borland Resource Compiler Version 4.0 or later (BRCC32.EXE).

# The script assumes that BRCC32.EXE is present on the current search
# path -- if this is not the case, modify the BRCC macros below to reflect
# the location of these executables.

# The LIB macros define the output directory for binaries and
# compiled units.

DCC = d:\pro\borland\cbuilder\bin\dcc32 -q -jphnv
BRCC = brcc32 -dCBUILDER
LIB = lib\cbuilder


# Implicit rule

default: \
$(LIB)\proutils.dcu \
$(LIB)\promedia.dcu \
$(LIB)\proconst.dcu \
$(LIB)\proconst.res \
$(LIB)\prolists.dcu \
$(LIB)\proctrls.dcu \
$(LIB)\provcl.dcu   \
$(LIB)\prochlst.dcu \
$(LIB)\prochlst.res \
$(LIB)\proclgrd.dcu \
$(LIB)\colorgr.dcu  \
$(LIB)\prodlgs.dcu  \
$(LIB)\prodlgs.res  \
$(LIB)\procalc.dcu  \
$(LIB)\prodbctl.dcu \
$(LIB)\proabout.dcu \
$(LIB)\protlbed.dcu \
$(LIB)\proreg.dcu   \
$(LIB)\proreg.dcr


$(LIB)\proutils.dcu: source\proutils.pas source\pro.inc
 $(DCC) source\proutils -n$(LIB) -e$(LIB)

$(LIB)\promedia.dcu: source\promedia.pas source\pro.inc
 $(DCC) source\promedia -n$(LIB) -e$(LIB)

$(LIB)\proconst.dcu: source\proconst.pas source\pro.inc
 $(DCC) source\proconst -r$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\proconst.res: source\proconst.rc source\proconst.pas
 $(BRCC) source\proconst.rc -fo$(LIB)\proconst.res

$(LIB)\prolists.dcu: source\prolists.pas source\pro.inc \
$(LIB)\proconst.dcu
 $(DCC) source\prolists -u$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\proctrls.dcu: source\proctrls.pas source\pro.inc \
$(LIB)\proconst.dcu
 $(DCC) source\proctrls -u$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\provcl.dcu: source\provcl.pas source\pro.inc $(LIB)\proctrls.dcu
 $(DCC) source\provcl -u$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\prochlst.dcu: source\prochlst.pas source\pro.inc \
$(LIB)\proctrls.dcu
 $(DCC) source\prochlst -u$(LIB) -r$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\prochlst.res: source\prochlst.rc
 $(BRCC) source\prochlst.rc -fo$(LIB)\prochlst.res

$(LIB)\proclgrd.dcu: source\proclgrd.pas source\pro.inc \
$(LIB)\proctrls.dcu $(LIB)\colorgr.dcu
 $(DCC) source\proclgrd -u$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\colorgr.dcu: source\colorgr.pas
 $(DCC) source\colorgr -u$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\prodlgs.dcu: source\prodlgs.pas source\pro.inc \
$(LIB)\proconst.dcu $(LIB)\proctrls.dcu
 $(DCC) source\prodlgs -u$(LIB) -r$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\prodlgs.res: source\prodlgs.rc
 $(BRCC) source\prodlgs.rc -fo$(LIB)\prodlgs.res

$(LIB)\procalc.dcu: source\procalc.pas source\pro.inc \
$(LIB)\proconst.dcu $(LIB)\proctrls.dcu $(LIB)\prodlgs.dcu
 $(DCC) source\procalc -u$(LIB) -n$(LIB) -e$(LIB)
 copy source\procalc.dfm $(LIB) > nul

$(LIB)\prodbctl.dcu: source\prodbctl.pas source\pro.inc \
$(LIB)\proctrls.dcu
 $(DCC) source\prodbctl -u$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\proabout.dcu: source\proabout.pas source\pro.inc \
$(LIB)\proctrls.dcu
 $(DCC) source\proabout -u$(LIB) -n$(LIB) -e$(LIB)
 copy source\proabout.dfm $(LIB) > nul

$(LIB)\protlbed.dcu: source\protlbed.pas source\pro.inc \
$(LIB)\proctrls.dcu $(LIB)\provcl.dcu
 $(DCC) source\protlbed -u$(LIB) -n$(LIB) -e$(LIB)
 copy source\protlbed.dfm $(LIB) > nul

$(LIB)\proreg.dcu: source\proreg.pas source\pro.inc \
$(LIB)\proutils.dcu \
$(LIB)\provcl.dcu   \
$(LIB)\promedia.dcu \
$(LIB)\proconst.dcu \
$(LIB)\proconst.res \
$(LIB)\prolists.dcu \
$(LIB)\proctrls.dcu \
$(LIB)\prochlst.dcu \
$(LIB)\prochlst.res \
$(LIB)\proclgrd.dcu \
$(LIB)\prodlgs.dcu  \
$(LIB)\prodlgs.res  \
$(LIB)\procalc.dcu  \
$(LIB)\prodbctl.dcu \
$(LIB)\proabout.dcu \
$(LIB)\protlbed.dcu
 $(DCC) source\proreg -u$(LIB) -n$(LIB) -e$(LIB)

$(LIB)\proreg.dcr: source\proreg.rc \
source\icons\prolabel.bmp \
source\icons\proclock.bmp \
source\icons\probtn.bmp   \
source\icons\prospbtn.bmp \
source\icons\prolbox.bmp  \
source\icons\prochlst.bmp \
source\icons\propanel.bmp \
source\icons\probordr.bmp \
source\icons\protlbar.bmp \
source\icons\proclgrd.bmp \
source\icons\prodrdlg.bmp \
source\icons\proconfm.bmp \
source\icons\prowarng.bmp \
source\icons\proinfo.bmp  \
source\icons\prostop.bmp  \
source\icons\propassw.bmp \
source\icons\prologin.bmp \
source\icons\proiview.bmp \
source\icons\procalc.bmp  \
source\icons\prodbtxt.bmp \
source\icons\prodblbx.bmp
 $(BRCC) source\proreg.rc -fo$(LIB)\proreg.dcr
