{*******************************************************}
{*                                                     *}
{*      Pro VCL Extensions Library                     *}
{*      VCL Utilities Unit                             *}
{*                                                     *}
{*      Copyright (c) 1996-98 by Dmitry Barabash       *}
{*                                                     *}
{*******************************************************}

unit ProVCL;

{$I PRO.INC}

interface

uses {$IFDEF WIN32} Windows, {$ELSE} WinTypes, WinProcs, {$ENDIF} SysUtils,
  Graphics, Forms, ExtCtrls, ProCtrls;


{ Graphics routines }

procedure FrameCtl3D(Canvas : TCanvas; Rect : TRect);
{ Draws a lowered 3D frame in style of Windows 95 on specified canvas }

procedure FrameCtl3DSides(Canvas : TCanvas; Rect : TRect; Sides : TSides;
  Lowered : Boolean);
{ Draws a 3D frame in style of Windows 95 on specified canvas. Sides
  parameter specifies which sides of frame will be drawn. Lowered
  parameter specifies whether the frame is lowered or raised. }


{ Service routine }

procedure Delay(MSecs : LongInt);
{ Delays a specified number of milliseconds.
  Written by Nivaldo Fernandes. }


{ Design routine }

function GetNewComponentName(Form : TForm; const AName : string) : string;
{ Returns a name of new component for specified form }

implementation

{ Graphics routines }

procedure FrameCtl3D(Canvas : TCanvas; Rect : TRect);
{ Draws a lowered 3D frame in style of Windows 95 on specified canvas }
begin
  Frame3D(Canvas, Rect, clBtnShadow, clBtnHighlight, 1);
  Frame3D(Canvas, Rect, clBtnText, clBtnFace, 1);
end; { FrameCtl3D }

procedure FrameCtl3DSides(Canvas : TCanvas; Rect : TRect; Sides : TSides;
  Lowered : Boolean);
{ Draws a 3D frame in style of Windows 95 on specified canvas. Sides
  parameter specifies which sides of frame will be drawn. Lowered
  parameter specifies whether the frame is lowered or raised. }
begin
  if Lowered then
  begin
    Frame3DSides(Canvas, Rect, Sides, clBtnShadow, clBtnHighlight, 1);
  {$IFDEF WIN32}
    Frame3DSides(Canvas, Rect, Sides, clBtnText, cl3DLight, 1);
  {$ELSE}
    Frame3DSides(Canvas, Rect, Sides, clBtnText, clBtnFace, 1);
  {$ENDIF}
  end
  else
  begin
    Frame3DSides(Canvas, Rect, Sides, clBtnHighlight, clBtnText, 1);
  {$IFDEF WIN32}
    Frame3DSides(Canvas, Rect, Sides, cl3DLight, clBtnShadow, 1);
  {$ELSE}
    Frame3DSides(Canvas, Rect, Sides, clBtnHighlight, clBtnShadow, 1);
  {$ENDIF}
  end;
end; { FrameCtl3DSides }


{ Service routine }

procedure Delay(MSecs : LongInt);
{ Delays a specified number of milliseconds.
  Written by Nivaldo Fernandes. }
var
  FirstTickCount : LongInt;
begin
  FirstTickCount := GetTickCount;
  repeat
    Application.ProcessMessages;
  until GetTickCount - FirstTickCount >= MSecs;
end; { Delay }


{ Design routine }

function GetNewComponentName(Form : TForm; const AName : string) : string;
{ Returns a name of new component for specified form }
var
  I : Integer;
begin
  I := 0;
  repeat
    Inc(I);
    Result := AName + IntToStr(I);
  until Form.FindComponent(Result) = nil;
end; { GetNewComponentName }

end.
