{*******************************************************}
{*                                                     *}
{*      Pro VCL Extensions Library                     *}
{*      ToolBarEdit Dialog Unit                        *}
{*                                                     *}
{*      Copyright (c) 1996-98 by Dmitry Barabash       *}
{*                                                     *}
{*******************************************************}

unit ProTlBEd;

{$I PRO.INC}

interface

uses Classes, Controls, Forms, StdCtrls, Buttons, ProCtrls, ProVCL;

{$IFNDEF DELPHI_3}
  {$IFNDEF CBUILDER_3}
    {$IFNDEF DELPHI_4}
      {$DEFINE DONT_USE_FLAT}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

{ TProToolBarEditForm }

type
  TProToolBarEditForm = class(TForm)
    { Blank group }
    BlankGroup: TGroupBox;
    BlankSpeedBtn: TProSpeedButton;

    { Files group }
    FilesGroup: TGroupBox;
    New1SpeedBtn: TProSpeedButton;
    New2SpeedBtn: TProSpeedButton;
    Open1SpeedBtn: TProSpeedButton;
    Open2SpeedBtn: TProSpeedButton;
    Open3SpeedBtn: TProSpeedButton;
    Save1SpeedBtn: TProSpeedButton;
    Save2SpeedBtn: TProSpeedButton;
    SaveAsSpeedBtn: TProSpeedButton;
    CloseSpeedBtn: TProSpeedButton;

    { Editing group }
    EditingGroup: TGroupBox;
    Cut1SpeedBtn: TProSpeedButton;
    Cut2SpeedBtn: TProSpeedButton;
    Copy1SpeedBtn: TProSpeedButton;
    Copy2SpeedBtn: TProSpeedButton;
    Copy3SpeedBtn: TProSpeedButton;
    Paste1SpeedBtn: TProSpeedButton;
    Paste2SpeedBtn: TProSpeedButton;
    SyntaxCheckSpeedBtn: TProSpeedButton;
    UndoSpeedBtn: TProSpeedButton;
    RedoSpeedBtn: TProSpeedButton;
    RepeatSpeedBtn: TProSpeedButton;

    { Searching group }
    SearchingGroup: TGroupBox;
    Find1SpeedBtn: TProSpeedButton;
    Find2SpeedBtn: TProSpeedButton;
    Replace1SpeedBtn: TProSpeedButton;
    Replace2SpeedBtn: TProSpeedButton;
    FindNext1SpeedBtn: TProSpeedButton;
    FindNext2SpeedBtn: TProSpeedButton;
    BrowseSpeedBtn: TProSpeedButton;

    { Formatting group }
    FormattingGroup: TGroupBox;
    FontSpeedBtn: TProSpeedButton;
    BoldSpeedBtn: TProSpeedButton;
    ItalicSpeedBtn: TProSpeedButton;
    UnderlineSpeedBtn: TProSpeedButton;
    LeftJustifySpeedBtn: TProSpeedButton;
    CenterJustifySpeedBtn: TProSpeedButton;
    RightJustifySpeedBtn: TProSpeedButton;
    JustifySpeedBtn: TProSpeedButton;
    BulletsSpeedBtn: TProSpeedButton;

    { Window group }
    WindowGroup: TGroupBox;
    Cascade1SpeedBtn: TProSpeedButton;
    Cascade2SpeedBtn: TProSpeedButton;
    Tile1SpeedBtn: TProSpeedButton;
    Tile2SpeedBtn: TProSpeedButton;
    MinAllSpeedBtn: TProSpeedButton;
    HorzTileSpeedBtn: TProSpeedButton;
    VertTileSpeedBtn: TProSpeedButton;

    { Communication group }
    CommGroup: TGroupBox;
    Printer1SpeedBtn: TProSpeedButton;
    Printer2SpeedBtn: TProSpeedButton;
    MailSpeedBtn: TProSpeedButton;
    FaxSpeedBtn: TProSpeedButton;

    { Deleting group }
    DeletingGroup: TGroupBox;
    RecycleSpeedBtn: TProSpeedButton;
    RemoveSpeedBtn: TProSpeedButton;
    BasketSpeedBtn: TProSpeedButton;
    TrashSpeedBtn: TProSpeedButton;

    { Viewing group }
    ViewingGroup: TGroupBox;
    View1SpeedBtn: TProSpeedButton;
    View2SpeedBtn: TProSpeedButton;
    ZoomIn1SpeedBtn: TProSpeedButton;
    ZoomIn2SpeedBtn: TProSpeedButton;
    ZoomOutSpeedBtn: TProSpeedButton;

    { Options group }
    OptionsGroup: TGroupBox;
    Options1SpeedBtn: TProSpeedButton;
    Options2SpeedBtn: TProSpeedButton;
    Options3SpeedBtn: TProSpeedButton;
    Options4SpeedBtn: TProSpeedButton;

    { Miscellaneous group }
    MiscGroup: TGroupBox;
    ExecuteSpeedBtn: TProSpeedButton;
    UtilsSpeedBtn: TProSpeedButton;
    HelpBookSpeedBtn: TProSpeedButton;
    HelpSpeedBtn: TProSpeedButton;

    { Database group }
    DatabaseGroup: TGroupBox;
    AddSpeedBtn: TProSpeedButton;
    EditSpeedBtn: TProSpeedButton;
    DeleteSpeedBtn: TProSpeedButton;
    FirstSpeedBtn: TProSpeedButton;
    PrevSpeedBtn: TProSpeedButton;
    NextSpeedBtn: TProSpeedButton;
    LastSpeedBtn: TProSpeedButton;

    SpacerCheckBox: TCheckBox;
    FlatCheckBox: TCheckBox;
    DoneButton: TProButton;

    procedure FormCreate(Sender: TObject);
    procedure SpeedButtonClick(Sender: TObject);
  public
    ToolBar : TProToolBar;
    ParentForm : TForm;
    SelectedBtn : TProSpeedButton;
  end;

implementation

{$R *.DFM}

{ TProToolBarEditForm }

procedure TProToolBarEditForm.FormCreate(Sender: TObject);
{ OnCreate event handler }
begin
{$IFNDEF WIN32}
  { Files group }
  New2SpeedBtn.Top := New2SpeedBtn.Top - 1;
  Open1SpeedBtn.Left := Open1SpeedBtn.Left - 1;
  Open2SpeedBtn.Left := Open2SpeedBtn.Left - 1;
  Open2SpeedBtn.Top := Open2SpeedBtn.Top - 1;
  Open3SpeedBtn.Left := Open3SpeedBtn.Left - 1;
  Open3SpeedBtn.Top := Open3SpeedBtn.Top - 2;
  Save1SpeedBtn.Left := Save1SpeedBtn.Left - 2;
  Save2SpeedBtn.Left := Save2SpeedBtn.Left - 2;
  Save2SpeedBtn.Top := Save2SpeedBtn.Top - 1;
  CloseSpeedBtn.Top := CloseSpeedBtn.Top - 2;

  { Editing group }
  Cut2SpeedBtn.Top := Cut2SpeedBtn.Top - 1;
  Copy1SpeedBtn.Left := Copy1SpeedBtn.Left - 1;
  Copy2SpeedBtn.Left := Copy2SpeedBtn.Left - 1;
  Copy2SpeedBtn.Top := Copy2SpeedBtn.Top - 1;
  Copy3SpeedBtn.Left := Copy3SpeedBtn.Left - 1;
  Copy3SpeedBtn.Top := Copy3SpeedBtn.Top - 2;
  Paste1SpeedBtn.Left := Paste1SpeedBtn.Left - 2;
  Paste2SpeedBtn.Left := Paste2SpeedBtn.Left - 2;
  Paste2SpeedBtn.Top := Paste2SpeedBtn.Top - 2;
  SyntaxCheckSpeedBtn.Left := SyntaxCheckSpeedBtn.Left - 1;
  UndoSpeedBtn.Top := UndoSpeedBtn.Top - 1;
  RedoSpeedBtn.Left := RedoSpeedBtn.Left - 1;
  RedoSpeedBtn.Top := RedoSpeedBtn.Top - 1;
  RepeatSpeedBtn.Left := RepeatSpeedBtn.Left - 1;
  RepeatSpeedBtn.Top := RepeatSpeedBtn.Top - 2;

  { Searching group }
  Find2SpeedBtn.Top := Find2SpeedBtn.Top - 1;
  Replace1SpeedBtn.Left := Replace1SpeedBtn.Left - 1;
  Replace2SpeedBtn.Left := Replace2SpeedBtn.Left - 1;
  Replace2SpeedBtn.Top := Replace2SpeedBtn.Top - 1;
  FindNext1SpeedBtn.Left := FindNext1SpeedBtn.Left - 2;
  FindNext2SpeedBtn.Left := FindNext2SpeedBtn.Left - 2;
  FindNext2SpeedBtn.Top := FindNext2SpeedBtn.Top - 1;

  { Formatting group }
  ItalicSpeedBtn.Left := ItalicSpeedBtn.Left - 1;
  UnderlineSpeedBtn.Left := UnderlineSpeedBtn.Left - 2;
  CenterJustifySpeedBtn.Left := CenterJustifySpeedBtn.Left - 1;
  RightJustifySpeedBtn.Left := RightJustifySpeedBtn.Left - 2;
  JustifySpeedBtn.Left := JustifySpeedBtn.Left - 3;

  { Window group }
  Tile1SpeedBtn.Left := Tile1SpeedBtn.Left - 1;
  MinAllSpeedBtn.Left := MinAllSpeedBtn.Left - 2;
  Tile2SpeedBtn.Left := Tile2SpeedBtn.Left - 1;
  HorzTileSpeedBtn.Left := HorzTileSpeedBtn.Left - 2;
  VertTileSpeedBtn.Left := VertTileSpeedBtn.Left - 3;

  { Communication group }
  Printer2SpeedBtn.Left := Printer2SpeedBtn.Left - 1;
  FaxSpeedBtn.Left := FaxSpeedBtn.Left - 1;

  { Deleting group }
  RemoveSpeedBtn.Left := RemoveSpeedBtn.Left - 1;
  BasketSpeedBtn.Left := BasketSpeedBtn.Left - 2;
  TrashSpeedBtn.Left := TrashSpeedBtn.Left - 3;

  { Viewing group }
  ZoomIn1SpeedBtn.Left := ZoomIn1SpeedBtn.Left - 1;
  ZoomIn2SpeedBtn.Left := ZoomIn2SpeedBtn.Left - 1;
  ZoomOutSpeedBtn.Left := ZoomOutSpeedBtn.Left - 2;

  { Options group }
  Options2SpeedBtn.Left := Options2SpeedBtn.Left - 1;
  Options3SpeedBtn.Left := Options3SpeedBtn.Left - 2;
  Options4SpeedBtn.Left := Options4SpeedBtn.Left - 3;

  { Miscellaneous group }
  HelpSpeedBtn.Left := HelpSpeedBtn.Left - 1;

  { Database group }
  EditSpeedBtn.Left := EditSpeedBtn.Left - 1;
  DeleteSpeedBtn.Left := DeleteSpeedBtn.Left - 2;
  PrevSpeedBtn.Left := PrevSpeedBtn.Left - 1;
  NextSpeedBtn.Left := NextSpeedBtn.Left - 2;
  LastSpeedBtn.Left := LastSpeedBtn.Left - 3;
{$ENDIF}

{$IFDEF DONT_USE_FLAT}
  FlatCheckBox.Visible := False;
{$ENDIF}

end; { TProToolBarEditForm.Create }

procedure TProToolBarEditForm.SpeedButtonClick(Sender: TObject);
{ Buttons' OnClick event handler }
var
  B : TProSpeedButton;
  MaxLeft, MaxTop, I, Spacer : Integer;
begin
  SelectedBtn := TProSpeedButton(Sender);

  if ParentForm <> nil then
  begin
    B := TProSpeedButton.Create(ParentForm);
    B.Parent := ToolBar;
    if ToolBar.Align in [alLeft, alRight] then
    begin
      B.Left := 4;
      MaxTop := 0;
      for I := 0 to B.Parent.ControlCount - 1 do
        if B.Parent.Controls[I].Top > MaxTop then
          MaxTop := B.Parent.Controls[I].Top;
      if MaxTop = 0 then
        B.Top := 4
      else
      begin
        if SpacerCheckBox.Checked then
          Spacer := 1
        else
          Spacer := 0;
      {$IFDEF WIN32}
        B.Top := MaxTop + 25 + (Spacer * 8);
      {$ELSE}
        B.Top := MaxTop + 24 + (Spacer * 8);
      {$ENDIF}
      end;
    end
    else           { alTop, alBottom, alClient, alNone }
    begin
      B.Top := 4;

      MaxLeft := 0;
      for I := 0 to B.Parent.ControlCount - 1 do
        if B.Parent.Controls[I].Left > MaxLeft then
          MaxLeft := B.Parent.Controls[I].Left;
      if MaxLeft = 0 then
        B.Left := 4
      else
      begin
        if SpacerCheckBox.Checked then
          Spacer := 1
        else
          Spacer := 0;
      {$IFDEF WIN32}
        B.Left := MaxLeft + 25 + (Spacer * 8);
      {$ELSE}
        B.Left := MaxLeft + 24 + (Spacer * 8);
      {$ENDIF}
      end;
    end;

    B.Name := GetNewComponentName(ParentForm, 'ProSpeedButton');

    B.Glyph.Assign(SelectedBtn.Glyph);
    B.NumGlyphs := SelectedBtn.NumGlyphs;
    B.Hint := SelectedBtn.Hint;
    B.ShowHint := True;

  {$IFNDEF DONT_USE_FLAT}
    if FlatCheckBox.Checked then
      B.Flat := True;
  {$ENDIF}

    SpacerCheckBox.Checked := False;
  end;
end; { TProToolBarEditForm.SpeedButtonClick }


end.
