{*******************************************************}
{*                                                     *}
{*      Pro VCL Extensions Library                     *}
{*      Register Unit                                  *}
{*                                                     *}
{*      Copyright (c) 1996-98 by Dmitry Barabash       *}
{*                                                     *}
{*******************************************************}

unit ProReg;

{$I PRO.INC}

interface

uses SysUtils, Classes, DsgnIntf;


{ Register procedure }

procedure Register;

implementation

uses
  Forms,
  StdCtrls,
  ExtCtrls,
  Buttons,
  ProCtrls,  { TProLabel, TProClockLabel, TProButton, TProSpeedButton, }
             { TProListBox, TProPanel, TProBorder, TProToolBar         }
  ProChLst,  { TProCheckListBox }
  ProClGrd,  { TProColorGrid }
  ProDlgs,   { TProSelDirDialog, TProConfirmDialog, TProWarningDialog, }
             { TProInfoDialog, TProStopDialog, TProPasswordDialog,     }
             { TProLoginDialog, TProImageViewDialog                    }
  ProCalc,   { TProCalcDialog }
  ProDBCtl,  { TProDBText, TProDBListBox }
  ProAbout,  { AboutComponentDialog }
  ProTlBEd;  { TProToolBarForm }


{ ComponentDescription function }

function ComponentDescription(Component : TComponent) : string;
{ Returns description of the component }
begin
  if Component is TProClockLabel then
    Result := 'This component shows date and time in label text ' +
              'format. Besides, this component includes the ' +
              'functionality of ProLabel component.'
  else if Component is TProLabel then
    Result := 'This component includes and extends the functionality ' +
              'of Label component. It features vertical alignment, ' +
              'it can have a shadow, allowing a 3D effect, and ' +
              'it can be rotated to any angle (TrueType fonts only).'
  else if Component is TProButton then
    Result := 'This component includes and extends the functionality ' +
              'of Button component. It includes Kind property to ' +
              'quickly create any of several predesigned command buttons.'
  else if Component is TProSpeedButton then
    Result := 'This component includes and extends the functionality ' +
              'of SpeedButton component. It includes three properties ' +
              'for repeat processing while the button is held down.'
  else if Component is TProListBox then
    Result := 'This component includes and extends the functionality ' +
              'of ListBox component. It is able to display a ' +
              'horizontal scroll bar.'
  else if Component is TProCheckListBox then
{$IFDEF OWN_CHECKLISTBOX}
    Result := 'This component displays a list with check boxes next ' +
              'to each item. If necessary, it displays a horizontal ' +
              'scroll bar.'
{$ELSE}
    Result := 'This component includes and extends the functionality ' +
              'of CheckListBox component. It is able to display a ' +
              'horizontal scroll bar.'
{$ENDIF}
  else if Component is TProToolBar then
    Result := 'Toolbar panel for buttons and other controls.'
  else if Component is TProPanel then
    Result := 'This component includes and extends the functionality ' +
              'of Panel component. It features enhanced border ' +
              'styles of Windows 95 and vertical alignment for caption.'
  else if Component is TProBorder then
    Result := 'This component represents a beveled outline. ' +
              'It features enhanced border styles of Windows 95.'
  else if Component is TProColorGrid then
    Result := 'Color grid component to select foreground and ' +
              'background colors.'
  else if Component is TProSelDirDialog then
    Result := 'This dialog component allows a user easily select ' +
              'a directory. If necessary, the desired directory ' +
              'will be created.'
  else if Component is TProConfirmDialog then
    Result := 'This dialog component allows a user to confirm ' +
              'any action.'
  else if Component is TProWarningDialog then
    Result := 'This dialog component allows to give a warning of ' +
              'any action.'
  else if Component is TProInfoDialog then
    Result := 'This dialog component allows to show a message.'
  else if Component is TProStopDialog then
    Result := 'This dialog component allows to show a stop message.'
  else if Component is TProPasswordDialog then
    Result := 'This dialog component allows to enter a password.'
  else if Component is TProLoginDialog then
    Result := 'This dialog component allows to enter a user name ' +
              'and a password.'
  else if Component is TProImageViewDialog then
    Result := 'This dialog component allows to view any image.'
  else if Component is TProCalcDialog then
    Result := 'Calculator dialog component.'
  else if Component is TProDBText then
    Result := 'This component includes and extends the functionality ' +
              'of DBText component. It can have a shadow, allowing ' +
              'a 3D effect, and it can be rotated to any angle ' +
              '(TrueType fonts only).'
  else if Component is TProDBListBox then
    Result := 'This component includes and extends the functionality ' +
              'of DBListBox component. It is able to display a ' +
              'horizontal scroll bar.';
end; { ComponentDescription }


{ TProCommonEditor component editor }

type
  TProCommonEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

function TProCommonEditor.GetVerbCount : Integer;
begin
  Result := 1;
end; { TProCommonEditor.GetVerbCount }

function TProCommonEditor.GetVerb(Index : Integer) : string;
begin
  Result := 'About...';
end; { TProCommonEditor.GetVerb }

procedure TProCommonEditor.ExecuteVerb(Index : Integer);
begin
  AboutComponentDialog(Component, ComponentDescription(Component));
end; { TProCommonEditor.ExecuteVerb }


{ TProLabelEditor component editor }

type
  TProLabelEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

function TProLabelEditor.GetVerbCount : Integer;
begin
  Result := 7;
end; { TProLabelEditor.GetVerbCount }

function TProLabelEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'Normal';
    1 : Result := 'Raised';
    2 : Result := 'Recessed';
    3 : Result := 'Shadow';
    4 : Result := 'Thick Shadow';
    5 : Result := '-';
    6 : Result := 'About...';
  end;
end; { TProLabelEditor.GetVerb }

procedure TProLabelEditor.ExecuteVerb(Index : Integer);
begin
  if Index = 6 then
  begin
    AboutComponentDialog(Component, ComponentDescription(Component));
    Exit;
  end
  else if Index = 0 then
    TProLabel(Component).ShadowStyle := ssNone
  else
    TProLabel(Component).ShadowStyle := TShadowStyle(Index + 1);
  Designer.Modified;
end; { TProLabelEditor.ExecuteVerb }


{ TProClockFormatProperty property editor }

type
  TProClockFormatProperty = class(TStringProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
    procedure GetValues(Proc : TGetStrProc); override;
  end;

function TProClockFormatProperty.GetAttributes : TPropertyAttributes;
begin
  Result := [paValueList, paMultiSelect, paAutoUpdate];
end; { TProClockFormatProperty.GetAttributes }

procedure TProClockFormatProperty.GetValues(Proc : TGetStrProc);
begin
  Proc('c');
  Proc('t');
  Proc('tt');
  Proc('ddddd');
  Proc('dddddd');
  Proc('ddddd t');
  Proc('ddddd tt');
  Proc('dddddd tt');
  Proc('d.mm.yyyy');
  Proc('d.mm.yyyy t');
  Proc('d.mm.yyyy tt');
end; { TProClockFormatProperty.GetValues }


{ TCommonButtonEditor component editor }

const
  ButtonScreen96 : array[0..2, 0..1] of Integer =
    ((80, 24), (80, 25), (75, 25));             { (72, 23) }
  ButtonScreen120 : array[0..2, 0..1] of Integer =
    ((100, 30), (100, 31), (92, 31));           { (96, 28) }

type
  TCommonButtonEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

function TCommonButtonEditor.GetVerbCount : Integer;
begin
  Result := 3;
end; { TCommonButtonEditor.GetVerbCount }

function TCommonButtonEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'Wide Normal Size';
    1 : Result := 'Wide Standard Size';
    2 : Result := 'Standard Size';
  end;
  if Screen.PixelsPerInch = 96 then
    Result := Format('%s (%dx%d)', [Result,
      ButtonScreen96[Index, 0], ButtonScreen96[Index, 1]])
  else if Screen.PixelsPerInch = 120 then
    Result := Format('%s (%dx%d)', [Result,
      ButtonScreen120[Index, 0], ButtonScreen120[Index, 1]]);
end; { TCommonButtonEditor.GetVerb }

procedure TCommonButtonEditor.ExecuteVerb(Index : Integer);
begin
  with TButton(Component) do
    if Screen.PixelsPerInch = 96 then
    begin
      Width := ButtonScreen96[Index, 0];
      Height := ButtonScreen96[Index, 1];
    end
    else if Screen.PixelsPerInch = 120 then
    begin
      Width := ButtonScreen120[Index, 0];
      Height := ButtonScreen120[Index, 1];
    end;
  Designer.Modified;
end; { TCommonButtonEditor.ExecuteVerb }


{ TProButtonEditor component editor }

type
  TProButtonEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

function TProButtonEditor.GetVerbCount : Integer;
begin
  Result := 5;
end; { TProButtonEditor.GetVerbCount }

function TProButtonEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'Wide Normal Size';
    1 : Result := 'Wide Standard Size';
    2 : Result := 'Standard Size';
    3 : Result := '-';
    4 : Result := 'About...';
  end;
  if Index < 3 then
  begin
    if Screen.PixelsPerInch = 96 then
      Result := Format('%s (%dx%d)', [Result,
        ButtonScreen96[Index, 0], ButtonScreen96[Index, 1]])
    else if Screen.PixelsPerInch = 120 then
      Result := Format('%s (%dx%d)', [Result,
        ButtonScreen120[Index, 0], ButtonScreen120[Index, 1]]);
  end;
end; { TProButtonEditor.GetVerb }

procedure TProButtonEditor.ExecuteVerb(Index : Integer);
begin
  with TProButton(Component) do
  begin
    { Show about component dialog }
    if Index = 4 then
    begin
      AboutComponentDialog(Component, ComponentDescription(Component));
      Exit;
    end;

    { Change button size }
    if Screen.PixelsPerInch = 96 then
    begin
      Width := ButtonScreen96[Index, 0];
      Height := ButtonScreen96[Index, 1];
    end
    else if Screen.PixelsPerInch = 120 then
    begin
      Width := ButtonScreen120[Index, 0];
      Height := ButtonScreen120[Index, 1];
    end;
  end;

  Designer.Modified;
end; { TProButtonEditor.ExecuteVerb }


{ TProPanelEditor component editor }

type
  TProPanelEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

function TProPanelEditor.GetVerbCount : Integer;
begin
  Result := 4;
end; { TProPanelEditor.GetVerbCount }

function TProPanelEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'Height For Standard Buttons';
    1 : Result := 'Height For Big Buttons';
    2 : Result := '-';
    3 : Result := 'About...';
  end;
end; { TProPanelEditor.GetVerb }

procedure TProPanelEditor.ExecuteVerb(Index : Integer);
begin
  with TProPanel(Component) do
    case Index of
      0 : Height := 31;
      1 : Height := 41;
      3 : begin
            AboutComponentDialog(Component, ComponentDescription(Component));
            Exit;
          end;
    end;
  Designer.Modified;
end; { TProPanelEditor.ExecuteVerb }


{ TProToolBarEditor component editor }

type
  TProToolBarEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

function TProToolBarEditor.GetVerbCount : Integer;
begin
  Result := 5;
end; { TProToolBarEditor.GetVerbCount }

function TProToolBarEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'Height For Standard Buttons';
    1 : Result := 'Height For Big Buttons';
    2 : Result := 'Add Buttons...';
    3 : Result := '-';
    4 : Result := 'About...';
  end;
end; { TProToolBarEditor.GetVerb }

procedure TProToolBarEditor.ExecuteVerb(Index : Integer);
begin
  with TProPanel(Component) do
    case Index of
      0 : Height := 31;
      1 : Height := 41;
      2 :
        begin
          with TProToolBarEditForm.Create(Application) do
          try
            ToolBar := TProToolBar(Component);
            ParentForm := TForm(GetParentForm(ToolBar));
            Caption :=  ParentForm.Name + '.' + ToolBar.Name + 
              ' - ToolBar Editor';
            Left := (Screen.Width - Width) shr 1;
            Top := ParentForm.Top + ToolBar.Top + ToolBar.Height + 35;
            ShowModal;
          finally
            Free;
          end;
        end;
      4 :
        begin
          AboutComponentDialog(Component, ComponentDescription(Component));
          Exit;
        end;
    end;
  Designer.Modified;
end; { TProToolBarEditor.ExecuteVerb }


{ TCommonSpeedButtonEditor component editor }

type
  TCommonSpeedButtonEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

function TCommonSpeedButtonEditor.GetVerbCount : Integer;
begin
  Result := 2;
end; { TCommonSpeedButtonEditor.GetVerbCount }

function TCommonSpeedButtonEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'Standard Size (25x25)';
    1 : Result := 'Big Size (31x31)';
  end;
end; { TCommonSpeedButtonEditor.GetVerb }

procedure TCommonSpeedButtonEditor.ExecuteVerb(Index : Integer);
begin
  with TSpeedButton(Component) do
    case Index of
      0 : begin
            Height := 25;
            Width := 25;
          end;
      1 : begin
            Height := 31;
            Width := 31;
          end;
    end;
  Designer.Modified;
end; { TCommonSpeedButtonEditor.ExecuteVerb }


{ TProSpeedButtonEditor component editor }

type
  TProSpeedButtonEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

function TProSpeedButtonEditor.GetVerbCount : Integer;
begin
  Result := 4;
end; { TProSpeedButtonEditor.GetVerbCount }

function TProSpeedButtonEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'Standard Size (25x25)';
    1 : Result := 'Big Size (31x31)';
    2 : Result := '-';
    3 : Result := 'About...';
  end;
end; { TProSpeedButtonEditor.GetVerb }

procedure TProSpeedButtonEditor.ExecuteVerb(Index : Integer);
begin
  with TSpeedButton(Component) do
    case Index of
      0 : begin
            Height := 25;
            Width := 25;
          end;
      1 : begin
            Height := 31;
            Width := 31;
          end;
      3 : begin
            AboutComponentDialog(Component, ComponentDescription(Component));
            Exit;
          end;
    end;
  Designer.Modified;
end; { TProSpeedButtonEditor.ExecuteVerb }


{ Register procedure }

procedure Register;
{ Registers the components, component editors and property editors }
begin
  RegisterComponents('Pro', [
    TProLabel, TProClockLabel, TProButton, TProSpeedButton, TProListBox,
    TProCheckListBox, TProPanel, TProBorder, TProToolBar, TProColorGrid,
    TProSelDirDialog, TProConfirmDialog, TProWarningDialog,
    TProInfoDialog, TProStopDialog, TProPasswordDialog, TProLoginDialog,
    TProImageViewDialog, TProCalcDialog, TProDBText, TProDBListBox]);

  RegisterComponentEditor(TButton, TCommonButtonEditor);
  RegisterComponentEditor(TSpeedButton, TCommonSpeedButtonEditor);

  RegisterComponentEditor(TProLabel, TProLabelEditor);
  RegisterComponentEditor(TProButton, TProButtonEditor);
  RegisterComponentEditor(TProSpeedButton, TProSpeedButtonEditor);
  RegisterComponentEditor(TProPanel, TProPanelEditor);
  RegisterComponentEditor(TProToolBar, TProToolBarEditor);
  RegisterComponentEditor(TProDBText, TProLabelEditor);

  RegisterComponentEditor(TProListBox, TProCommonEditor);
  RegisterComponentEditor(TProCheckListBox, TProCommonEditor);
  RegisterComponentEditor(TProBorder, TProCommonEditor);
  RegisterComponentEditor(TProColorGrid, TProCommonEditor);
  RegisterComponentEditor(TProSelDirDialog, TProCommonEditor);
  RegisterComponentEditor(TProConfirmDialog, TProCommonEditor);
  RegisterComponentEditor(TProWarningDialog, TProCommonEditor);
  RegisterComponentEditor(TProInfoDialog, TProCommonEditor);
  RegisterComponentEditor(TProStopDialog, TProCommonEditor);
  RegisterComponentEditor(TProPasswordDialog, TProCommonEditor);
  RegisterComponentEditor(TProLoginDialog, TProCommonEditor);
  RegisterComponentEditor(TProImageViewDialog, TProCommonEditor);
  RegisterComponentEditor(TProCalcDialog, TProCommonEditor);
  RegisterComponentEditor(TProDBListBox, TProCommonEditor);

  RegisterPropertyEditor(TypeInfo(string), TProClockLabel, 'Format',
    TProClockFormatProperty);
end; { Register }

end.
