{*******************************************************}
{*                                                     *}
{*      Pro VCL Extensions Library                     *}
{*      Multimedia Utilities Unit                      *}
{*                                                     *}
{*      Copyright (c) 1996-98 by Dmitry Barabash       *}
{*                                                     *}
{*******************************************************}

unit ProMedia;

{$I PRO.INC}

interface

uses Forms, MPlayer;

{ Multimedia routine }

procedure PlayMedia(Form : TForm; const AFileName : string);
{ Plays a media file }

implementation

{ Multimedia routine }

procedure PlayMedia(Form : TForm; const AFileName : string);
{ Plays a media file }
var
  MediaPlayer : TMediaPlayer;
begin
  with TMediaPlayer.Create(Form) do
  try
    Parent := Form;
    Visible := False;
    FileName := AFileName;
    Open;
    Wait := True;
    Play;
  finally
    Free;
  end;
end; { PlayMedia }

end.
