{*******************************************************}
{*                                                     *}
{*      Pro VCL Extensions Library                     *}
{*      AboutComponent Dialog Unit                     *}
{*                                                     *}
{*      Copyright (c) 1996-98 by Dmitry Barabash       *}
{*                                                     *}
{*******************************************************}

unit ProAbout;

interface

uses Classes, Controls, Forms, StdCtrls, ExtCtrls, ProCtrls;

{ TProAboutComponentForm }

type
  TProAboutComponentForm = class(TForm)
    LogoPanel: TProPanel;
    LogoLabel: TProLabel;
    InfoPanel: TProPanel;
    ComponentLabel: TProLabel;
    ProductLabel: TProLabel;
    Bevel: TBevel;
    DescriptionLabel: TProLabel;
    OKButton: TProButton;
    LblCopyright1: TLabel;
    LblHomePage1: TLabel;
    LblHomePage2: TLabel;
    LblCopyright2: TLabel;
    procedure LblCopyright2Click(Sender: TObject);
    procedure LblHomePage2Click(Sender: TObject);
  end;

{ Dialog procedure }

procedure AboutComponentDialog(Component : TComponent;
  const Description : string);
{ About dialog interface routine }

implementation

uses Windows, ShellAPI;

{$R *.DFM}

{ Dialog procedure }

procedure AboutComponentDialog(Component : TComponent;
  const Description : string);
{ About dialog interface routine }
var
  ComponentName : string;
begin
  with TProAboutComponentForm.Create(Application) do
  try
    ComponentName := Component.ClassName;
    Delete(ComponentName, 1, 1);
    Caption := 'About ' + ComponentName + ' Component';
    ComponentLabel.Caption := ComponentName;
    DescriptionLabel.Caption := Description;
    ShowModal;
  finally
    Free;
  end;
end; { ShowAboutComponent }


{ TProAboutComponentForm }

procedure TProAboutComponentForm.LblCopyright2Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar('mailto:dgb@farlep.net'), nil, nil, SW_SHOW);
end;

procedure TProAboutComponentForm.LblHomePage2Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar(LblHomePage2.Caption), nil, nil, SW_SHOW);
end;

end.
